/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableButton;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.Tile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class PaintableTools {
    private PaintableTools() {
    }

    public static Paintable wrapPaintable(Paintable object) {
        if (object != null) {
            return object;
        }
        return new Tile(object);
    }

    public static Icon makeIcon(Paintable paintable) {
        if (paintable == null) {
            return null;
        }
        return new PaintableComponent(paintable);
    }

    public static BufferedImage makeBufferedImage(Paintable paintable) {
        if (paintable == null) {
            return null;
        }
        XRect bounds = paintable.getBounds2D();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        w = w < 1 ? 1 : w;
        h = h < 1 ? 1 : h;
        BufferedImage b = new BufferedImage(w, h, 2);
        Graphics2D g = b.createGraphics();
        g.translate(-x, -y);
        paintable.paint(g);
        return b;
    }

    public static TexturePaint makeTexturePaint(Paintable paintable) {
        if (paintable == null) {
            return null;
        }
        return new TexturePaint(PaintableTools.makeBufferedImage(paintable), paintable.getBounds2D());
    }

    public static JButton makeButton(Paintable paintable) {
        return PaintableTools.makeButton(paintable, null, null, null);
    }

    public static JButton makeButton(Paintable paintable, Action action) {
        return PaintableTools.makeButton(paintable, action, null, null);
    }

    public static JButton makeButton(Paintable paintable, Action action, Color color) {
        return PaintableTools.makeButton(paintable, action, color, null);
    }

    public static JButton makeButton(Paintable paintable, Action action, Color color, Insets insets) {
        if (paintable == null) {
            return null;
        }
        return new PaintableButton(paintable, action, color, insets);
    }

    public static JPTComponent makeComponent(Paintable paintable) {
        return PaintableTools.makeComponent(paintable, null, false, null);
    }

    public static JPTComponent makeComponent(Paintable paintable, Color color) {
        return PaintableTools.makeComponent(paintable, color, false, null);
    }

    public static JPTComponent makeComponent(Paintable paintable, Color color, boolean opaque) {
        return PaintableTools.makeComponent(paintable, color, opaque, null);
    }

    public static JPTComponent makeComponent(Paintable paintable, Color color, boolean opaque, Border border) {
        if (paintable == null) {
            return null;
        }
        return new PaintableComponent(paintable, color, opaque, border);
    }
}

