/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Vector;

public class PaintableSequence
extends AbstractPaintable {
    private Vector paintablesequence = new Vector(16);
    private Mutator.StrategyUsage usage = Mutator.MUTATE_AS_ITEMS;

    public PaintableSequence() {
        this(null, null);
    }

    public PaintableSequence(Object[] objects) {
        this(objects, null);
    }

    public PaintableSequence(Object[] objects, Mutator.StrategyUsage usage) {
        this.appendSequence(objects);
        this.setMutatorStrategyUsage(usage);
    }

    public final void originalPaint(Graphics g) {
        if (g == null || !this.isVisible()) {
            return;
        }
        int N = this.length();
        if (N == 0) {
            return;
        }
        Graphics2D h = (Graphics2D)g.create();
        int i = N - 1;
        while (i >= 0) {
            Paintable paintable = this.getPaintable(i);
            if (paintable != null) {
                paintable.paint(h);
            }
            --i;
        }
    }

    public final XRect getActualBounds2D() {
        XRect bounds = null;
        int N = this.length();
        int i = 0;
        while (i < N) {
            XRect next;
            Paintable paintable = this.getPaintable(i);
            if (paintable != null && (next = paintable.getBounds2D()) != null && !(next.getWidth() <= 0.0) && !(next.getHeight() <= 0.0)) {
                bounds = bounds == null ? next : bounds.createUnionRect(next);
            }
            ++i;
        }
        return bounds;
    }

    public final boolean originalContains(double x, double y) {
        return this.hitsItem(x, y) != null;
    }

    public final void setMutator(AffineTransform M) {
        if (M == null) {
            return;
        }
        try {
            AffineTransform N = M.createInverse();
        }
        catch (NoninvertibleTransformException exception) {
            return;
        }
        int N = this.length();
        int i = 0;
        while (i < N) {
            Paintable paintable = this.getPaintable(i);
            if (paintable != null) {
                paintable.setMutator(M);
            }
            ++i;
        }
    }

    public void addPreMutation(AffineTransform M) {
        if (M == null) {
            return;
        }
        try {
            AffineTransform N = M.createInverse();
        }
        catch (NoninvertibleTransformException exception) {
            return;
        }
        int N = this.length();
        int i = 0;
        while (i < N) {
            Paintable paintable = this.getPaintable(i);
            if (paintable != null) {
                paintable.addPreMutation(M);
            }
            ++i;
        }
    }

    public void addPostMutation(AffineTransform M) {
        if (M == null) {
            return;
        }
        try {
            AffineTransform N = M.createInverse();
        }
        catch (NoninvertibleTransformException exception) {
            return;
        }
        int N = this.length();
        int i = 0;
        while (i < N) {
            Paintable paintable = this.getPaintable(i);
            if (paintable != null) {
                paintable.addPostMutation(M);
            }
            ++i;
        }
    }

    public void setMutator(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int N = this.length();
            int i = 0;
            while (i < N) {
                Paintable paintable = this.getPaintable(i);
                if (paintable != null) {
                    paintable.setMutator(strategy);
                }
                ++i;
            }
        } else {
            this.setMutator(strategy.mutator(this.getOriginalCenter()));
        }
    }

    public final void addPreMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int N = this.length();
            int i = 0;
            while (i < N) {
                Paintable paintable = this.getPaintable(i);
                if (paintable != null) {
                    paintable.addPreMutation(strategy);
                }
                ++i;
            }
        } else {
            this.addPreMutation(strategy.mutator(this.getOriginalCenter()));
        }
    }

    public final void addPostMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int N = this.length();
            int i = 0;
            while (i < N) {
                Paintable paintable = this.getPaintable(i);
                if (paintable != null) {
                    paintable.addPostMutation(strategy);
                }
                ++i;
            }
        } else {
            this.addPostMutation(strategy.mutator(this.getCenter()));
        }
    }

    public Paintable makePaintable(Object o) {
        return ComponentFactory.makePaintable(o);
    }

    public final int length() {
        return this.paintablesequence.size();
    }

    public final Paintable setPaintable(int index, Object o) {
        Paintable oldpaintable;
        if (index < 0 || index >= this.length()) {
            return null;
        }
        Paintable newpaintable = this.makePaintable(o);
        if (newpaintable != (oldpaintable = this.getPaintable(index))) {
            this.removeAndAddForwardingListener(oldpaintable, newpaintable);
            this.paintablesequence.set(index, newpaintable);
            this.firePropertyChange("set.paintable", null, null);
        }
        return newpaintable;
    }

    public final Paintable setPaintable(Object o, int index) {
        return this.setPaintable(index, o);
    }

    public final Paintable getPaintable(int index) {
        if (index < 0 || index >= this.length()) {
            return null;
        }
        return (Paintable)this.paintablesequence.get(index);
    }

    public final int getIndex(Paintable paintable) {
        int index = -1;
        if (paintable == null) {
            return index;
        }
        int length = this.length();
        int i = 0;
        while (i < length) {
            if (paintable == this.getPaintable(i)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public final Paintable addPaintable(int index, Object o) {
        int length = this.length();
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        Paintable paintable = this.makePaintable(o);
        this.addForwardingListener(paintable);
        this.paintablesequence.add(index, paintable);
        this.firePropertyChange("set.paintable", null, null);
        return paintable;
    }

    public final Paintable addPaintable(Object o, int index) {
        return this.addPaintable(index, o);
    }

    public final Paintable addPaintable(Object o) {
        return this.addPaintable(0, o);
    }

    public final Paintable addPaintableAtTop(Object o) {
        return this.addPaintable(0, o);
    }

    public final Paintable appendPaintable(Object o) {
        return this.addPaintable(Integer.MAX_VALUE, o);
    }

    public final Paintable[] setSequence(Object[] objects) {
        this.clear();
        return this.appendSequence(objects);
    }

    public final Paintable[] addSequence(int index, Object[] objects) {
        if (objects == null) {
            return null;
        }
        int N = objects.length;
        Paintable[] paintables = new Paintable[N];
        int length = this.length();
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        if (N > 0) {
            int i = 0;
            while (i < N) {
                paintables[i] = this.makePaintable(objects[i]);
                this.addForwardingListener(paintables[i]);
                this.paintablesequence.add(index + i, paintables[i]);
                ++i;
            }
            this.firePropertyChange("set.paintable", null, null);
        }
        return paintables;
    }

    public final Paintable[] addSequence(Object[] objects, int index) {
        return this.addSequence(index, objects);
    }

    public final Paintable[] addSequence(Object[] objects) {
        return this.addSequence(0, objects);
    }

    public final Paintable[] addSequenceAtTop(Object[] objects) {
        return this.addSequence(0, objects);
    }

    public final Paintable[] appendSequence(Object[] objects) {
        return this.addSequence(Integer.MAX_VALUE, objects);
    }

    public final Paintable removePaintable(int index) {
        if (index < 0 || index >= this.length()) {
            return null;
        }
        Paintable paintable = (Paintable)this.paintablesequence.get(index);
        this.removeForwardingListener(paintable);
        this.paintablesequence.remove(index);
        this.firePropertyChange("remove.paintable", null, null);
        return paintable;
    }

    public final void removePaintable(Paintable paintable) {
        this.removePaintable(this.getIndex(paintable));
    }

    public final Paintable[] removeSequence(int m, int n) {
        int c;
        if (m < 0) {
            m = 0;
        }
        if (n > this.length()) {
            n = this.length();
        }
        if ((c = n - m) <= 0) {
            return new Paintable[0];
        }
        Paintable[] result = new Paintable[c];
        while (n > m) {
            Paintable paintable = (Paintable)this.paintablesequence.get(--n);
            this.removeForwardingListener(paintable);
            this.paintablesequence.remove(n);
            result[--c] = paintable;
        }
        this.firePropertyChange("remove.paintable", null, null);
        return result;
    }

    public final Paintable[] clear() {
        return this.clearEverything();
    }

    public final Paintable[] clearSequence() {
        return this.removeSequence(0, Integer.MAX_VALUE);
    }

    public final Paintable[] clearEverything() {
        this.clearBothBackgrounds();
        return this.clearSequence();
    }

    public final void shiftPaintable(int i, int j) {
        int length = this.length();
        if (i < 0 || i >= length) {
            return;
        }
        if (j < 0 || j >= length) {
            return;
        }
        if (i == j) {
            return;
        }
        if (j > i) {
            --j;
        }
        Paintable paintable = (Paintable)this.paintablesequence.get(i);
        this.paintablesequence.remove(i);
        this.paintablesequence.add(j, paintable);
        this.firePropertyChange("shift.paintable", null, null);
    }

    public final void shiftPaintableToTop(int i) {
        this.shiftPaintable(i, 0);
    }

    public final void shiftPaintableToBottom(int i) {
        this.shiftPaintable(i, this.length() - 1);
    }

    public final void shiftPaintableUp(int i) {
        this.shiftPaintable(i, i - 1);
    }

    public final void shiftPaintableDown(int i) {
        this.shiftPaintable(i, i + 1);
    }

    public final void shiftPaintable(Paintable paintable, int i) {
        this.shiftPaintable(this.getIndex(paintable), i);
    }

    public final void shiftPaintableToTop(Paintable paintable) {
        this.shiftPaintable(this.getIndex(paintable), 0);
    }

    public final void shiftPaintableToBottom(Paintable paintable) {
        this.shiftPaintable(this.getIndex(paintable), this.length() - 1);
    }

    public final void shiftPaintableUp(Paintable paintable) {
        int index = this.getIndex(paintable);
        this.shiftPaintable(index, index - 1);
    }

    public final void shiftPaintableDown(Paintable paintable) {
        int index = this.getIndex(paintable);
        this.shiftPaintable(index, index + 1);
    }

    public final Paintable[] toArray() {
        return this.paintablesequence.toArray(new Paintable[0]);
    }

    public final void setMutatorStrategyUsage(Mutator.StrategyUsage usage) {
        if (usage != null) {
            this.usage = usage;
        }
    }

    public final Mutator.StrategyUsage getMutatorStrategyUsage() {
        return this.usage;
    }

    public final void setMutateAsGroup() {
        this.usage = Mutator.MUTATE_AS_GROUP;
    }

    public final void setMutateAsItems() {
        this.usage = Mutator.MUTATE_AS_ITEMS;
    }

    public final Paintable hits(double x, double y) {
        Paintable paintable = this.hitsItem(x, y);
        if (paintable == null) {
            return null;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            return paintable;
        }
        return this;
    }

    public final Paintable hits(Point2D p) {
        if (p == null) {
            return null;
        }
        return this.hits(p.getX(), p.getY());
    }

    public final Paintable hitsItem(double x, double y) {
        return this.getPaintable(this.hitsItemAtIndex(x, y));
    }

    public final Paintable hitsItem(Point2D p) {
        if (p == null) {
            return null;
        }
        return this.hitsItem(p.getX(), p.getY());
    }

    public final int hitsItemAtIndex(double x, double y) {
        int N = this.length();
        if (N == 0 || !this.possiblyContains(x, y)) {
            return -1;
        }
        int i = 0;
        while (i < N) {
            Paintable paintable = this.getPaintable(i);
            if (paintable != null && paintable.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int hitsItemAtIndex(Point2D p) {
        if (p == null) {
            return -1;
        }
        return this.hitsItemAtIndex(p.getX(), p.getY());
    }
}

