/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.SimpleAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.Icon;
import javax.swing.border.Border;

public class PaintableComponent
extends JPTComponent
implements Icon {
    public static final String SET_PAINTABLE = "set.paintable";
    private Paintable paintable = null;
    private Rectangle2D bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private RefreshListener listener = new RefreshListener();

    public PaintableComponent(Paintable paintable) {
        this(paintable, null, false, null);
    }

    public PaintableComponent(Paintable paintable, Color color) {
        this(paintable, color, false, null);
    }

    public PaintableComponent(Paintable paintable, Color color, boolean opaque) {
        this(paintable, color, opaque, null);
    }

    public PaintableComponent(Paintable paintable, Color color, boolean opaque, Border border) {
        if (paintable == null) {
            throw new NullPointerException("Null Paintable passed to PaintableComponent constructor");
        }
        this.paintable = paintable;
        if (color != null) {
            this.setBackground(color);
        }
        this.setOpaque(opaque);
        if (border != null) {
            this.setBorder(border);
        }
        this.refresh();
        this.addPropertyChangeListener(this.listener);
        this.paintable.addPropertyChangeListener(this.listener);
    }

    public void setPaintable(Paintable paintable) {
        if (paintable == null || paintable == this.paintable) {
            return;
        }
        this.paintable.removePropertyChangeListener(this.listener);
        this.paintable = paintable;
        this.paintable.addPropertyChangeListener(this.listener);
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public Paintable getPaintable() {
        return this.paintable;
    }

    public Rectangle2D getDefaultBounds2D() {
        XRect rect = this.paintable.getBounds2D();
        double x = rect.getMinX();
        double y = rect.getMinY();
        double w = ((RectangularShape)rect).getWidth();
        double h = ((RectangularShape)rect).getHeight();
        Insets insets = this.getInsets();
        if (insets != null) {
            x -= (double)insets.left;
            y -= (double)insets.top;
            w += (double)(insets.left + insets.right);
            h += (double)(insets.top + insets.bottom);
        }
        ((Rectangle2D)rect).setRect(x, y, w, h);
        return rect;
    }

    public Point2D getDefaultLocation() {
        Rectangle2D rect = this.getDefaultBounds2D();
        double x = rect.getMinX();
        double y = rect.getMinY();
        return new Point2D.Double(x, y);
    }

    public Dimension getPreferredSize() {
        Rectangle2D rect = this.getDefaultBounds2D();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        return new Dimension(w, h);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public Rectangle2D getIconBounds2D() {
        return this.paintable.getBounds2D();
    }

    public int getIconWidth() {
        return (int)this.getIconBounds2D().getWidth();
    }

    public int getIconHeight() {
        return (int)this.getIconBounds2D().getHeight();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color;
        if (g == null) {
            return;
        }
        Graphics2D h = (Graphics2D)g;
        Paint older = h.getPaint();
        XRect bounds = this.paintable.getBounds2D();
        int x0 = x - (int)bounds.getMinX();
        int y0 = y - (int)bounds.getMinY();
        h.translate(x0, y0);
        if (c != null && c.isOpaque() && (color = c.getBackground()) != null) {
            h.setPaint(color);
            h.fill(bounds);
        }
        this.paintable.paint(h);
        h.setPaint(older);
        h.translate(-x0, -y0);
    }

    protected void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        int x = 0;
        int y = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
        }
        this.paintIcon(this, g, x, y);
    }

    public void refresh() {
        boolean no_bounds_change;
        Rectangle2D rect = this.getDefaultBounds2D();
        boolean bl = no_bounds_change = this.bounds.getMinX() == rect.getMinX() && this.bounds.getMinY() == rect.getMinY() && this.bounds.getMaxX() == rect.getMaxX() && this.bounds.getMaxY() == rect.getMaxY();
        if (no_bounds_change) {
            this.repaint();
        } else {
            this.bounds = rect;
            int x = (int)rect.getMinX();
            int y = (int)rect.getMinY();
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            this.setSize(w, h);
            this.setLocation(x, y);
            this.refreshComponent();
        }
    }

    private class RefreshListener
    extends SimpleAction {
        private RefreshListener() {
        }

        public void perform() {
            PaintableComponent.this.refresh();
        }
    }
}

