/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.SimpleAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.Action;
import javax.swing.JButton;

public class PaintableButton
extends JButton {
    public static final String SET_PAINTABLE = "set.paintable";
    private static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 2);
    private Paintable paintable = null;
    private PaintableComponent component = null;
    private Rectangle2D bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private RefreshListener listener = new RefreshListener();

    public PaintableButton(Paintable paintable) {
        this(paintable, null, null, null);
    }

    public PaintableButton(Paintable paintable, Action action) {
        this(paintable, action, null, null);
    }

    public PaintableButton(Paintable paintable, Action action, Color color) {
        this(paintable, action, color, null);
    }

    public PaintableButton(Paintable paintable, Action action, Color color, Insets insets) {
        if (paintable == null) {
            throw new NullPointerException("Null Paintable passed to PaintableButton constructor");
        }
        this.paintable = paintable;
        this.component = new PaintableComponent(paintable);
        this.setAction(action);
        if (color != null) {
            this.setBackground(color);
        }
        if (insets == null) {
            insets = DEFAULT_INSETS;
        }
        this.setMargin(insets);
        this.refresh();
        this.addChangeListener(this.listener);
        this.addPropertyChangeListener(this.listener);
        this.paintable.addPropertyChangeListener(this.listener);
    }

    public void setPaintable(Paintable paintable) {
        if (paintable == null || paintable == this.paintable) {
            return;
        }
        this.paintable.removePropertyChangeListener(this.listener);
        this.paintable = paintable;
        this.component = new PaintableComponent(paintable);
        this.setIcon(this.component);
        this.paintable.addPropertyChangeListener(this.listener);
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public Paintable getPaintable() {
        return this.paintable;
    }

    public void setAction(Action action) {
        super.setAction(action);
        this.setText(null);
        this.setIcon(this.component);
    }

    public Rectangle2D getDefaultBounds2D() {
        XRect rect = this.paintable.getBounds2D();
        double x = rect.getMinX();
        double y = rect.getMinY();
        double w = ((RectangularShape)rect).getWidth();
        double h = ((RectangularShape)rect).getHeight();
        Insets insets = this.getInsets();
        if (insets != null) {
            x -= (double)insets.left;
            y -= (double)insets.top;
            w += (double)(insets.left + insets.right);
            h += (double)(insets.top + insets.bottom);
        }
        ((Rectangle2D)rect).setRect(x, y, w, h);
        return rect;
    }

    public Point2D getDefaultLocation() {
        Rectangle2D rect = this.getDefaultBounds2D();
        double x = rect.getMinX();
        double y = rect.getMinY();
        return new Point2D.Double(x, y);
    }

    public Dimension getPreferredSize() {
        Rectangle2D rect = this.getDefaultBounds2D();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        return new Dimension(w, h);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void refresh() {
        boolean no_bounds_change;
        Rectangle2D rect = this.getDefaultBounds2D();
        boolean bl = no_bounds_change = this.bounds.getMinX() == rect.getMinX() && this.bounds.getMinY() == rect.getMinY() && this.bounds.getMaxX() == rect.getMaxX() && this.bounds.getMaxY() == rect.getMaxY();
        if (no_bounds_change) {
            this.repaint();
        } else {
            this.bounds = rect;
            int x = (int)rect.getMinX();
            int y = (int)rect.getMinY();
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            this.setSize(w, h);
            this.setLocation(x, y);
            this.refreshComponent();
        }
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }

    private class RefreshListener
    extends SimpleAction {
        private RefreshListener() {
        }

        public void perform() {
            PaintableButton.this.refresh();
        }
    }
}

