/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.PaintAlgorithm;
import edu.neu.ccs.util.MathUtilities;
import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PaintTools {
    private PaintTools() {
    }

    public static TexturePaint makePaint(PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return PaintTools.makePaint(algorithm, algorithm.xPeriod(), algorithm.yPeriod());
    }

    public static TexturePaint makePaint(PaintAlgorithm algorithm, int width, int height) {
        return new TexturePaint(PaintTools.makeBufferedImage(algorithm, width, height), new Rectangle2D.Double(0.0, 0.0, width, height));
    }

    public static BufferedImage makeBufferedImage(PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return PaintTools.makeBufferedImage(algorithm, algorithm.xPeriod(), algorithm.yPeriod());
    }

    public static BufferedImage makeBufferedImage(PaintAlgorithm algorithm, int width, int height) {
        if (algorithm == null || width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                Color color = algorithm.color(x, y);
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                int a = color.getAlpha();
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, argb);
                ++y;
            }
            ++x;
        }
        return image;
    }

    public static PaintAlgorithm makePaintAlgorithm(BufferedImage image) {
        if (image == null) {
            return null;
        }
        final int xperiod = image.getWidth();
        final int yperiod = image.getHeight();
        if (xperiod == 0 || yperiod == 0) {
            return null;
        }
        final Color[][] colors = new Color[xperiod][yperiod];
        final int minx = image.getMinX();
        final int miny = image.getMinY();
        int maxx = minx + xperiod;
        int maxy = miny + yperiod;
        int x = minx;
        while (x < maxx) {
            int y = miny;
            while (y < maxy) {
                colors[x - minx][y - miny] = new Color(image.getRGB(x, y), true);
                ++y;
            }
            ++x;
        }
        return new PaintAlgorithm(){

            public Color color(int x, int y) {
                x -= minx;
                y -= miny;
                x = MathUtilities.modulus(x, xperiod);
                y = MathUtilities.modulus(y, yperiod);
                return colors[x][y];
            }

            public int xPeriod() {
                return xperiod;
            }

            public int yPeriod() {
                return yperiod;
            }
        };
    }

    public static PaintAlgorithm solid(Color c) {
        final Color d = c != null ? c : Color.black;
        return new PaintAlgorithm(){

            public Color color(int x, int y) {
                return d;
            }

            public int xPeriod() {
                return 1;
            }

            public int yPeriod() {
                return 1;
            }
        };
    }

    public static PaintAlgorithm turn45(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int period;
            {
                this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
            }

            public Color color(int x, int y) {
                return algorithm.color(x - y, x + y);
            }

            public int xPeriod() {
                return this.period;
            }

            public int yPeriod() {
                return this.period;
            }
        };
    }

    public static PaintAlgorithm turn90(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int xPeriod;
            final int yPeriod;
            {
                this.xPeriod = paintAlgorithm.yPeriod();
                this.yPeriod = paintAlgorithm.xPeriod();
            }

            public Color color(int x, int y) {
                return algorithm.color(-y, x);
            }

            public int xPeriod() {
                return this.xPeriod;
            }

            public int yPeriod() {
                return this.yPeriod;
            }
        };
    }

    public static PaintAlgorithm turn135(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int period;
            {
                this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
            }

            public Color color(int x, int y) {
                return algorithm.color(-x - y, x - y);
            }

            public int xPeriod() {
                return this.period;
            }

            public int yPeriod() {
                return this.period;
            }
        };
    }

    public static PaintAlgorithm turn180(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int xPeriod;
            final int yPeriod;
            {
                this.xPeriod = paintAlgorithm.xPeriod();
                this.yPeriod = paintAlgorithm.yPeriod();
            }

            public Color color(int x, int y) {
                return algorithm.color(-x, -y);
            }

            public int xPeriod() {
                return this.xPeriod;
            }

            public int yPeriod() {
                return this.yPeriod;
            }
        };
    }

    public static PaintAlgorithm turn225(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int period;
            {
                this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
            }

            public Color color(int x, int y) {
                return algorithm.color(-x + y, -x - y);
            }

            public int xPeriod() {
                return this.period;
            }

            public int yPeriod() {
                return this.period;
            }
        };
    }

    public static PaintAlgorithm turn270(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int xPeriod;
            final int yPeriod;
            {
                this.xPeriod = paintAlgorithm.yPeriod();
                this.yPeriod = paintAlgorithm.xPeriod();
            }

            public Color color(int x, int y) {
                return algorithm.color(y, -x);
            }

            public int xPeriod() {
                return this.xPeriod;
            }

            public int yPeriod() {
                return this.yPeriod;
            }
        };
    }

    public static PaintAlgorithm turn315(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int period;
            {
                this.period = MathUtilities.LCM(paintAlgorithm.xPeriod(), paintAlgorithm.yPeriod());
            }

            public Color color(int x, int y) {
                return algorithm.color(x + y, -x + y);
            }

            public int xPeriod() {
                return this.period;
            }

            public int yPeriod() {
                return this.period;
            }
        };
    }

    public static PaintAlgorithm reflect(final PaintAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int xPeriod;
            final int yPeriod;
            {
                this.xPeriod = paintAlgorithm.xPeriod();
                this.yPeriod = paintAlgorithm.yPeriod();
            }

            public Color color(int x, int y) {
                return algorithm.color(x, -y);
            }

            public int xPeriod() {
                return this.xPeriod;
            }

            public int yPeriod() {
                return this.yPeriod;
            }
        };
    }

    public static PaintAlgorithm translate(final PaintAlgorithm algorithm, final int x0, final int y0) {
        if (algorithm == null) {
            return null;
        }
        return new PaintAlgorithm(){
            final int xPeriod;
            final int yPeriod;
            {
                this.xPeriod = paintAlgorithm.xPeriod();
                this.yPeriod = paintAlgorithm.yPeriod();
            }

            public Color color(int x, int y) {
                return algorithm.color(x - x0, y - y0);
            }

            public int xPeriod() {
                return this.xPeriod;
            }

            public int yPeriod() {
                return this.yPeriod;
            }
        };
    }

    public static PaintAlgorithm stripeEtoW(Color color1, Color color2, int thick1, int thick2) {
        return PaintTools.stripeEtoW(PaintTools.solid(color1), PaintTools.solid(color2), thick1, thick2);
    }

    public static PaintAlgorithm stripeEtoW(final PaintAlgorithm algorithm1, final PaintAlgorithm algorithm2, int thick1, int thick2) {
        if (algorithm1 == null || algorithm2 == null) {
            return null;
        }
        final int s = MathUtilities.LCM(algorithm1.xPeriod(), algorithm2.xPeriod());
        final int t1 = thick1 >= 1 ? thick1 : 1;
        int t2 = thick2 >= 1 ? thick2 : 1;
        final int t = t1 + t2;
        return new PaintAlgorithm(){

            public Color color(int x, int y) {
                x = MathUtilities.modulus(x, s);
                if ((y = MathUtilities.modulus(y, t)) < t1) {
                    return algorithm1.color(x, y);
                }
                return algorithm2.color(x, y);
            }

            public int xPeriod() {
                return s;
            }

            public int yPeriod() {
                return t;
            }
        };
    }

    public static PaintAlgorithm stripeNEtoSW(Color color1, Color color2, int thick1, int thick2) {
        return PaintTools.turn45(PaintTools.stripeEtoW(PaintTools.solid(color1), PaintTools.solid(color2), thick1, thick2));
    }

    public static PaintAlgorithm stripeNEtoSW(PaintAlgorithm algorithm1, PaintAlgorithm algorithm2, int thick1, int thick2) {
        return PaintTools.turn45(PaintTools.stripeEtoW(algorithm1, algorithm2, thick1, thick2));
    }

    public static PaintAlgorithm stripeNtoS(Color color1, Color color2, int thick1, int thick2) {
        return PaintTools.turn90(PaintTools.stripeEtoW(PaintTools.solid(color1), PaintTools.solid(color2), thick1, thick2));
    }

    public static PaintAlgorithm stripeNtoS(PaintAlgorithm algorithm1, PaintAlgorithm algorithm2, int thick1, int thick2) {
        return PaintTools.turn90(PaintTools.stripeEtoW(algorithm1, algorithm2, thick1, thick2));
    }

    public static PaintAlgorithm stripeNWtoSE(Color color1, Color color2, int thick1, int thick2) {
        return PaintTools.turn135(PaintTools.stripeEtoW(PaintTools.solid(color1), PaintTools.solid(color2), thick1, thick2));
    }

    public static PaintAlgorithm stripeNWtoSE(PaintAlgorithm algorithm1, PaintAlgorithm algorithm2, int thick1, int thick2) {
        return PaintTools.turn135(PaintTools.stripeEtoW(algorithm1, algorithm2, thick1, thick2));
    }

    public static PaintAlgorithm checkHatch(Color color1, Color color2, int width1, int width2, int height1, int height2) {
        return PaintTools.checkHatch(PaintTools.solid(color1), PaintTools.solid(color2), width1, width2, height1, height2);
    }

    public static PaintAlgorithm checkHatch(final PaintAlgorithm algorithm1, final PaintAlgorithm algorithm2, int width1, int width2, int height1, int height2) {
        if (algorithm1 == null || algorithm2 == null) {
            return null;
        }
        final int w1 = width1 >= 1 ? width1 : 1;
        int w2 = width2 >= 1 ? width2 : 1;
        final int w = w1 + w2;
        final int h1 = height1 >= 1 ? height1 : 1;
        int h2 = height2 >= 1 ? height2 : 1;
        final int h = h1 + h2;
        return new PaintAlgorithm(){

            public Color color(int x, int y) {
                boolean useAlgorithm1;
                x = MathUtilities.modulus(x, w);
                y = MathUtilities.modulus(y, h);
                boolean bl = useAlgorithm1 = x < w1 && y < h1 || x >= w1 && y >= h1;
                if (useAlgorithm1) {
                    return algorithm1.color(x, y);
                }
                return algorithm2.color(x, y);
            }

            public int xPeriod() {
                return w;
            }

            public int yPeriod() {
                return h;
            }
        };
    }

    public static PaintAlgorithm checkHatchDiagonal(Color color1, Color color2, int width1, int width2, int height1, int height2) {
        return PaintTools.turn45(PaintTools.checkHatch(PaintTools.solid(color1), PaintTools.solid(color2), width1, width2, height1, height2));
    }

    public static PaintAlgorithm checkHatchDiagonal(PaintAlgorithm algorithm1, PaintAlgorithm algorithm2, int width1, int width2, int height1, int height2) {
        return PaintTools.turn45(PaintTools.checkHatch(algorithm1, algorithm2, width1, width2, height1, height2));
    }

    public static PaintAlgorithm crossHatch(Color color1, Color color2, int width1, int width2, int height1, int height2) {
        return PaintTools.crossHatch(PaintTools.solid(color1), PaintTools.solid(color2), width1, width2, height1, height2);
    }

    public static PaintAlgorithm crossHatch(final PaintAlgorithm algorithm1, final PaintAlgorithm algorithm2, int width1, int width2, int height1, int height2) {
        if (algorithm1 == null || algorithm2 == null) {
            return null;
        }
        final int w1 = width1 >= 1 ? width1 : 1;
        int w2 = width2 >= 1 ? width2 : 1;
        final int w = w1 + w2;
        final int h1 = height1 >= 1 ? height1 : 1;
        int h2 = height2 >= 1 ? height2 : 1;
        final int h = h1 + h2;
        return new PaintAlgorithm(){

            public Color color(int x, int y) {
                boolean useAlgorithm1;
                x = MathUtilities.modulus(x, w);
                y = MathUtilities.modulus(y, h);
                boolean bl = useAlgorithm1 = x < w1 || y < h1;
                if (useAlgorithm1) {
                    return algorithm1.color(x, y);
                }
                return algorithm2.color(x, y);
            }

            public int xPeriod() {
                return w;
            }

            public int yPeriod() {
                return h;
            }
        };
    }

    public static PaintAlgorithm crossHatchDiagonal(Color color1, Color color2, int width1, int width2, int height1, int height2) {
        return PaintTools.turn45(PaintTools.crossHatch(PaintTools.solid(color1), PaintTools.solid(color2), width1, width2, height1, height2));
    }

    public static PaintAlgorithm crossHatchDiagonal(PaintAlgorithm algorithm1, PaintAlgorithm algorithm2, int width1, int width2, int height1, int height2) {
        return PaintTools.turn45(PaintTools.crossHatch(algorithm1, algorithm2, width1, width2, height1, height2));
    }

    public static PaintAlgorithm dottedGrid(Color dotColor, Color backColor, int dotSize, int gridSize) {
        int ds;
        int minimum;
        int gs;
        int mod;
        if (dotColor == null) {
            dotColor = Color.black;
        }
        if (backColor == null) {
            backColor = Color.white;
        }
        if ((mod = (gs = gridSize >= (minimum = 2 * (ds = dotSize >= 1 ? dotSize : 1)) ? gridSize : minimum) % minimum) > 0) {
            gs += minimum - mod;
        }
        PaintAlgorithm a = PaintTools.checkHatch(dotColor, backColor, ds, ds, ds, ds);
        PaintAlgorithm b = PaintTools.solid(backColor);
        int hs = gs - ds;
        return PaintTools.crossHatch(a, b, ds, hs, ds, hs);
    }

    public static PaintAlgorithm dottedGridDiagonal(Color dotColor, Color backColor, int dotSize, int gridSize) {
        return PaintTools.turn45(PaintTools.dottedGrid(dotColor, backColor, dotSize, gridSize));
    }

    public static PaintAlgorithm brickEtoW(Color cellColor, Color edgeColor, int size) {
        if (cellColor == null) {
            cellColor = Colors.Brown;
        }
        if (edgeColor == null) {
            edgeColor = Color.black;
        }
        final Color color1 = cellColor;
        final Color color2 = edgeColor;
        int s = size >= 2 ? size : 2;
        final int z = 2 * s + 4;
        boolean bl = false;
        final int z1 = s + 1;
        final int z2 = s + 2;
        final int z3 = s + s + 3;
        return new PaintAlgorithm(){

            public Color color(int x, int y) {
                x = MathUtilities.modulus(x, z);
                if ((y = MathUtilities.modulus(y, z)) == 0 || y == z1 || y == z2 || y == z3) {
                    return color2;
                }
                if (y < z1 && (x == 0 || x == z3)) {
                    return color2;
                }
                if (y > z2 && (x == z1 || x == z2)) {
                    return color2;
                }
                return color1;
            }

            public int xPeriod() {
                return z;
            }

            public int yPeriod() {
                return z;
            }
        };
    }

    public static PaintAlgorithm brickNEtoSW(Color cellColor, Color edgeColor, int size) {
        return PaintTools.turn45(PaintTools.brickEtoW(cellColor, edgeColor, size));
    }

    public static PaintAlgorithm brickNtoS(Color cellColor, Color edgeColor, int size) {
        return PaintTools.turn90(PaintTools.brickEtoW(cellColor, edgeColor, size));
    }

    public static PaintAlgorithm brickNWtoSE(Color cellColor, Color edgeColor, int size) {
        return PaintTools.turn135(PaintTools.brickEtoW(cellColor, edgeColor, size));
    }
}

