/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.JPTComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;

public class PaintSwatch
extends JPTComponent
implements Icon {
    public static final String SET_PAINT = "set.paint";
    public static final String SET_SIZE = "set.size";
    public static final String SET_BORDER = "set.border";
    public static final int DEFAULT_SWATCH_SIZE = 20;
    public static final int BORDER_SIZE = 2;
    public static final Border BLACK_BORDER = BorderFactory.createLineBorder(Colors.Black, 2);
    public static final Border WHITE_BORDER = BorderFactory.createLineBorder(Colors.White, 2);
    public static final Border TRANSPARENT_BORDER = BorderFactory.createLineBorder(Colors.Transparent, 2);
    private Paint paint = Colors.transparent;
    private int xSize = 0;
    private int ySize = 0;
    private Rectangle2D area;

    public PaintSwatch() {
        this(null, 20, 20, BLACK_BORDER);
    }

    public PaintSwatch(Paint paint) {
        this(paint, 20, 20, BLACK_BORDER);
    }

    public PaintSwatch(Paint paint, int xSize, int ySize) {
        this(paint, xSize, ySize, BLACK_BORDER);
    }

    public PaintSwatch(Paint paint, Border border) {
        this(paint, 20, 20, border);
    }

    public PaintSwatch(Paint paint, int xSize, int ySize, Border border) {
        this.setPaint(paint);
        this.setSize(xSize, ySize);
        this.setBorder(border);
    }

    public Dimension getPreferredSize() {
        int w = this.xSize;
        int h = this.ySize;
        Insets insets = this.getInsets();
        if (insets != null) {
            w += insets.left + insets.right;
            h += insets.top + insets.bottom;
        }
        return new Dimension(w, h);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            paint = Colors.transparent;
        }
        if (this.paint == paint) {
            return;
        }
        this.paint = paint;
        this.repaint();
        this.firePropertyChange(SET_PAINT, null, null);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setSize(int xSize, int ySize) {
        xSize = xSize >= 1 ? xSize : 1;
        int n = ySize = ySize >= 1 ? ySize : 1;
        if (this.xSize == xSize && this.ySize == ySize) {
            return;
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.area = new Rectangle2D.Double(0.0, 0.0, xSize, ySize);
        this.refreshComponent();
        this.firePropertyChange(SET_SIZE, null, null);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public void setBorder(Border border) {
        if (border == null || this.getBorder() == border) {
            return;
        }
        super.setBorder(border);
        this.refreshComponent();
        this.firePropertyChange(SET_BORDER, null, null);
    }

    public int getIconWidth() {
        return this.xSize;
    }

    public int getIconHeight() {
        return this.ySize;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color;
        if (g == null) {
            return;
        }
        Graphics2D h = (Graphics2D)g;
        Paint older = h.getPaint();
        h.translate(x, y);
        if (c != null && c.isOpaque() && (color = c.getBackground()) != null) {
            h.setPaint(color);
            h.fill(this.area);
        }
        h.setPaint(this.paint);
        h.fill(this.area);
        h.setPaint(older);
        h.translate(-x, -y);
    }

    protected void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        int x = 0;
        int y = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
        }
        this.paintIcon(this, g, x, y);
    }
}

