/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.ShapePaintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public abstract class PaintMode {
    public static final PaintMode FILL = new PaintMode(){

        public void originalPaint(ShapePaintable paintable, Graphics g) {
            if (paintable == null || g == null) {
                return;
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return;
            }
            Graphics2D h = (Graphics2D)g.create();
            h.setPaint(paintable.getFillPaint());
            h.fill(shape);
        }

        public XRect getActualBounds2D(ShapePaintable paintable) {
            if (paintable == null) {
                return new XRect();
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return new XRect();
            }
            return new XRect(shape.getBounds2D());
        }

        public Shape getOutline(ShapePaintable paintable) {
            if (paintable == null) {
                return null;
            }
            return paintable.getShape();
        }

        public boolean originalContains(ShapePaintable paintable, double x, double y) {
            if (paintable == null) {
                return false;
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return false;
            }
            return shape.contains(x, y);
        }
    };
    public static final PaintMode DRAW = new PaintMode(){

        public void originalPaint(ShapePaintable paintable, Graphics g) {
            if (paintable == null || g == null) {
                return;
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return;
            }
            Graphics2D h = (Graphics2D)g.create();
            h.setPaint(paintable.getDrawPaint());
            h.fill(strokedShape);
        }

        public XRect getActualBounds2D(ShapePaintable paintable) {
            if (paintable == null) {
                return new XRect();
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return new XRect();
            }
            return new XRect(strokedShape.getBounds2D());
        }

        public Shape getOutline(ShapePaintable paintable) {
            if (paintable == null) {
                return null;
            }
            return paintable.getStrokedShape();
        }

        public boolean originalContains(ShapePaintable paintable, double x, double y) {
            if (paintable == null) {
                return false;
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return false;
            }
            return strokedShape.contains(x, y);
        }
    };
    public static final PaintMode FILL_DRAW = new PaintMode(){

        public void originalPaint(ShapePaintable paintable, Graphics g) {
            if (paintable == null || g == null) {
                return;
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return;
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return;
            }
            Graphics2D h = (Graphics2D)g.create();
            h.setPaint(paintable.getFillPaint());
            h.fill(shape);
            h.setPaint(paintable.getDrawPaint());
            h.fill(strokedShape);
        }

        public XRect getActualBounds2D(ShapePaintable paintable) {
            if (paintable == null) {
                return new XRect();
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return new XRect();
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return new XRect();
            }
            XRect bounds1 = new XRect(shape.getBounds2D());
            XRect bounds2 = new XRect(strokedShape.getBounds2D());
            XRect bounds = bounds1.createUnionRect(bounds2);
            return bounds;
        }

        public Shape getOutline(ShapePaintable paintable) {
            if (paintable == null) {
                return null;
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return null;
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return null;
            }
            Area area1 = new Area(shape);
            Area area2 = new Area(strokedShape);
            area1.add(area2);
            return area1;
        }

        public boolean originalContains(ShapePaintable paintable, double x, double y) {
            if (paintable == null) {
                return false;
            }
            Shape shape = paintable.getShape();
            if (shape == null) {
                return false;
            }
            Shape strokedShape = paintable.getStrokedShape();
            if (strokedShape == null) {
                return false;
            }
            return shape.contains(x, y) || strokedShape.contains(x, y);
        }
    };

    public abstract void originalPaint(ShapePaintable var1, Graphics var2);

    public abstract XRect getActualBounds2D(ShapePaintable var1);

    public abstract Shape getOutline(ShapePaintable var1);

    public abstract boolean originalContains(ShapePaintable var1, double var2, double var4);

    public final boolean originalContains(ShapePaintable paintable, Point2D p) {
        if (p == null) {
            return false;
        }
        return this.originalContains(paintable, p.getX(), p.getY());
    }

    public static void fill(Graphics g, Shape shape, Paint fillpaint) {
        ShapePaintable paintable = new ShapePaintable(shape, FILL, fillpaint);
        paintable.paint(g);
    }

    public static void draw(Graphics g, Shape shape, Paint drawpaint) {
        ShapePaintable paintable = new ShapePaintable(shape, DRAW, null, drawpaint);
        paintable.paint(g);
    }

    public static void draw(Graphics g, Shape shape, Paint drawpaint, Stroke drawstroke) {
        ShapePaintable paintable = new ShapePaintable(shape, DRAW, null, drawpaint, drawstroke);
        paintable.paint(g);
    }

    public static void filldraw(Graphics g, Shape shape, Paint fillpaint, Paint drawpaint) {
        ShapePaintable paintable = new ShapePaintable(shape, FILL_DRAW, fillpaint, drawpaint);
        paintable.paint(g);
    }

    public static void filldraw(Graphics g, Shape shape, Paint fillpaint, Paint drawpaint, Stroke drawstroke) {
        ShapePaintable paintable = new ShapePaintable(shape, FILL_DRAW, fillpaint, drawpaint, drawstroke);
        paintable.paint(g);
    }
}

