/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableSequenceComposite;
import edu.neu.ccs.gui.ShapePaintable;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PaintBar
extends PaintableSequenceComposite {
    private int number = 0;
    private int diameter = 0;
    private int gap = 0;
    private int base = 0;
    private int center = 0;
    private int skip = 0;
    private Rectangle2D.Double bounds;

    public PaintBar(Paint[] paints, int diameter, int gap, int orientation) {
        if (paints == null) {
            throw new NullPointerException("PaintBar constructor error: paints array is null");
        }
        int length = paints.length;
        if (length == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has no data");
        }
        if (diameter < 5) {
            diameter = 5;
        }
        if (gap < 0) {
            gap = 0;
        }
        this.diameter = diameter;
        this.gap = gap;
        this.base = gap / 2;
        this.skip = diameter + gap;
        this.center = this.skip / 2;
        int x = this.xCorner(0);
        int y = this.yCorner(0);
        int i = 0;
        while (i < length) {
            if (paints[i] != null) {
                if (orientation == 0) {
                    x = this.xCorner(i);
                } else {
                    y = this.yCorner(i);
                }
                this.installPaint(paints[i], x, y, diameter);
            }
            ++i;
        }
        if (this.number == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has only null data");
        }
        this.bounds = orientation == 0 ? new Rectangle2D.Double(0.0, 0.0, this.skip * length, this.skip) : new Rectangle2D.Double(0.0, 0.0, this.skip, this.skip * length);
        this.getPaintableSequence().setDefaultBounds2D(this.bounds);
    }

    public PaintBar(Paint[][] paints, int diameter, int gap) {
        if (paints == null) {
            throw new NullPointerException("PaintBar constructor error: paints array is null");
        }
        int rows = paints.length;
        if (rows == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has no data");
        }
        int cols = 0;
        if (diameter < 5) {
            diameter = 5;
        }
        if (gap < 0) {
            gap = 0;
        }
        this.diameter = diameter;
        this.gap = gap;
        this.base = gap / 2;
        this.skip = diameter + gap;
        this.center = this.skip / 2;
        int row = 0;
        while (row < rows) {
            if (paints[row] != null) {
                int y = this.yCorner(row);
                int limit = paints[row].length;
                cols = Math.max(cols, limit);
                int col = 0;
                while (col < limit) {
                    if (paints[row][col] != null) {
                        int x = this.xCorner(col);
                        this.installPaint(paints[row][col], x, y, diameter);
                    }
                    ++col;
                }
            }
            ++row;
        }
        if (this.number == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has only null data");
        }
        this.bounds = new Rectangle2D.Double(0.0, 0.0, this.skip * cols, this.skip * rows);
        this.getPaintableSequence().setDefaultBounds2D(this.bounds);
    }

    public int getPaintCount() {
        return this.number;
    }

    public Paint getPaint(int row, int col) {
        return this.hitsPaint(this.xCenter(col), this.yCenter(row));
    }

    public void setPaint(int row, int col, Paint paint) {
        int y;
        if (paint == null) {
            return;
        }
        int x = this.xCenter(col);
        if (!this.bounds.contains(x, y = this.yCenter(row))) {
            return;
        }
        Paintable paintable = this.getPaintableSequence().hits(x, y);
        if (paintable == null) {
            x = this.xCorner(col);
            y = this.yCorner(row);
            this.installPaint(paint, x, y, this.diameter);
        } else {
            ShapePaintable shapepaintable = (ShapePaintable)paintable;
            shapepaintable.setFillPaint(paint);
        }
    }

    public Paint hitsPaint(double x, double y) {
        Paintable paintable = this.getPaintableSequence().hits(x, y);
        if (paintable == null) {
            return null;
        }
        ShapePaintable shapepaintable = (ShapePaintable)paintable;
        return shapepaintable.getFillPaint();
    }

    public Paint hitsPaint(Point2D p) {
        if (p == null) {
            return null;
        }
        return this.hitsPaint(p.getX(), p.getY());
    }

    public int diameter() {
        return this.diameter;
    }

    public int gap() {
        return this.gap;
    }

    public int xCorner(int col) {
        return this.base + col * this.skip;
    }

    public int yCorner(int row) {
        return this.base + row * this.skip;
    }

    public int xCenter(int col) {
        return this.center + col * this.skip;
    }

    public int yCenter(int row) {
        return this.center + row * this.skip;
    }

    protected ShapePaintable getShapePaintable(int index) {
        if (index < 0 || index >= this.getPaintCount()) {
            return null;
        }
        return (ShapePaintable)this.getPaintableSequence().getPaintable(index);
    }

    private void installPaint(Paint paint, int x, int y, int diameter) {
        Ellipse2D.Double circle = new Ellipse2D.Double(x, y, diameter, diameter);
        ShapePaintable paintable = new ShapePaintable(circle, PaintMode.FILL, paint);
        this.getPaintableSequence().appendPaintable(paintable);
        ++this.number;
    }
}

