/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.TransformFactory;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class Mutator {
    public static final StrategyUsage MUTATE_AS_GROUP = new StrategyUsage();
    public static final StrategyUsage MUTATE_AS_ITEMS = new StrategyUsage();

    private Mutator() {
    }

    public static Strategy translate(final double tx, final double ty) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.translate(tx, ty);
            }
        };
    }

    public static Strategy rotate(final double degrees) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.rotate(x, y, degrees);
            }
        };
    }

    public static Strategy scale(final double degrees, final double s, final double t) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.scale(x, y, degrees, s, t);
            }
        };
    }

    public static Strategy shear(final double degrees, final double s) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.shear(x, y, degrees, s);
            }
        };
    }

    public static Strategy reflect(final double degrees) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.reflect(x, y, degrees);
            }
        };
    }

    public static Strategy glidereflect(final double degrees, final double distance) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.glidereflect(x, y, degrees, distance);
            }
        };
    }

    public static Strategy centeredTransform(final double m00, final double m10, final double m01, final double m11, final double m02, final double m12) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.centeredTransform(x, y, m00, m10, m01, m11, m02, m12);
            }
        };
    }

    public static Strategy transform(final AffineTransform T) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return T;
            }
        };
    }

    public static Strategy randomTranslate(final double maxshift) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.randomTranslate(maxshift);
            }
        };
    }

    public static Strategy randomRotate(final double maxangle) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.randomRotate(x, y, maxangle);
            }
        };
    }

    public static Strategy randomTranslateRotate(final double maxshift, final double maxangle) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.randomTranslateRotate(x, y, maxshift, maxangle);
            }
        };
    }

    public static Strategy randomScale(final double degrees, final double maxdelta) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.randomScale(x, y, degrees, maxdelta);
            }
        };
    }

    public static Strategy randomCenteredTransform(final double maxshift) {
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                return TransformFactory.randomCenteredTransform(x, y, maxshift);
            }
        };
    }

    public static Strategy compose(Strategy[] strategylist) {
        final Strategy[] list = strategylist == null ? new Strategy[]{} : strategylist;
        return new Strategy(){

            public AffineTransform mutator(double x, double y) {
                int N = list.length;
                AffineTransform[] transforms = new AffineTransform[N];
                int i = 0;
                while (i < N) {
                    transforms[i] = list[i] == null ? null : list[i].mutator(x, y);
                    ++i;
                }
                return TransformFactory.compose(transforms);
            }
        };
    }

    public static abstract class Strategy {
        public final AffineTransform mutator(Point2D center) {
            if (center == null) {
                return new AffineTransform();
            }
            return this.mutator(center.getX(), center.getY());
        }

        public abstract AffineTransform mutator(double var1, double var3);
    }

    public static class StrategyUsage {
        StrategyUsage() {
        }
    }
}

