/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Strings;
import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PaintableSequenceComposite;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextBounds;
import edu.neu.ccs.gui.TextPaintable;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;

public class MultiLineTextPaintable
extends PaintableSequenceComposite {
    public static final String SET_STRING = "set.string";
    public static final String SET_FONT = "set.font";
    public static final String SET_FILL_PAINT = "set.fill.paint";
    public static final String SET_ANCHOR_LOCATOR = "set.anchor.locator";
    public static final String SET_ANCHOR_POSITION = "set.anchor.position";
    private String string = "";
    private Font font = TextPaintable.getDefaultFont();
    private Paint fillpaint = Color.black;
    private TextBounds.Strategy strategy = TextBounds.LOOSE;
    private TextAnchor.Locator locator = TextAnchor.LEFT_ASCENTLINE;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;

    public MultiLineTextPaintable() {
        this(null, null, null, null, 0.0f, 0.0f);
    }

    public MultiLineTextPaintable(String string) {
        this(string, null, null, null, 0.0f, 0.0f);
    }

    public MultiLineTextPaintable(String string, float anchorX, float anchorY) {
        this(string, null, null, null, anchorX, anchorY);
    }

    public MultiLineTextPaintable(String string, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this(string, null, null, locator, anchorX, anchorY);
    }

    public MultiLineTextPaintable(String string, Font font) {
        this(string, font, null, null, 0.0f, 0.0f);
    }

    public MultiLineTextPaintable(String string, Font font, float anchorX, float anchorY) {
        this(string, font, null, null, anchorX, anchorY);
    }

    public MultiLineTextPaintable(String string, Font font, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this(string, font, null, locator, anchorX, anchorY);
    }

    public MultiLineTextPaintable(String string, Font font, Paint fillpaint) {
        this(string, font, fillpaint, null, 0.0f, 0.0f);
    }

    public MultiLineTextPaintable(String string, Font font, Paint fillpaint, float anchorX, float anchorY) {
        this(string, font, fillpaint, null, anchorX, anchorY);
    }

    public MultiLineTextPaintable(String string, Font font, Paint fillpaint, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this.initMLTP(string, font, fillpaint, locator, anchorX, anchorY);
    }

    protected void initMLTP(String string, Font font, Paint fillpaint, TextAnchor.Locator locator, float anchorX, float anchorY) {
        if (string != null) {
            this.string = string;
        }
        if (font != null) {
            this.font = font;
        }
        if (fillpaint != null) {
            this.fillpaint = fillpaint;
        }
        if (locator != null) {
            this.locator = locator;
        }
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.makeMLTP();
    }

    protected void makeMLTP() {
        PaintableSequence sequence = this.getPaintableSequence();
        sequence.clearSequence();
        String[] lines = this.getLines();
        int count = lines.length;
        TextPaintable dummy = new TextPaintable("0", this.font, this.fillpaint, this.strategy, this.locator, 0.0f, 0.0f);
        float lineheight = dummy.getLeadingLineY() - dummy.getAscentLineY();
        float x = this.anchorX;
        float y = this.anchorY;
        int i = 0;
        while (i < count) {
            TextPaintable paintable = new TextPaintable(lines[i], this.font, this.fillpaint, this.strategy, this.locator, x, y);
            sequence.appendPaintable(paintable);
            y += lineheight;
            ++i;
        }
    }

    public void setString(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.string)) {
            return;
        }
        this.string = string;
        this.makeMLTP();
        this.firePropertyChange(SET_STRING, null, null);
    }

    public String getString() {
        return this.string;
    }

    public String[] getLines() {
        return Strings.exactSplitList(this.string, '\n', false);
    }

    public void setFont(Font font) {
        if (font == null) {
            font = TextPaintable.getDefaultFont();
        }
        if (font.equals(this.font)) {
            return;
        }
        this.removeAndAddForwardingListener(this.font, font);
        this.font = font;
        PaintableSequence sequence = this.getPaintableSequence();
        int length = sequence.length();
        TextPaintable dummy = new TextPaintable("0", font, this.fillpaint, this.strategy, this.locator, 0.0f, 0.0f);
        float lineheight = dummy.getLeadingLineY() - dummy.getAscentLineY();
        float x = this.anchorX;
        float y = this.anchorY;
        int i = 0;
        while (i < length) {
            TextPaintable paintable = (TextPaintable)sequence.getPaintable(i);
            paintable.setFont(font);
            paintable.setAnchorPosition(x, y);
            y += lineheight;
            ++i;
        }
        this.firePropertyChange(SET_FONT, null, null);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFillPaint(Paint fillpaint) {
        if (fillpaint == null) {
            fillpaint = Color.black;
        }
        if (fillpaint.equals(this.fillpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.fillpaint, fillpaint);
        this.fillpaint = fillpaint;
        PaintableSequence sequence = this.getPaintableSequence();
        int length = sequence.length();
        int i = 0;
        while (i < length) {
            TextPaintable paintable = (TextPaintable)sequence.getPaintable(i);
            paintable.setFillPaint(fillpaint);
            ++i;
        }
        this.firePropertyChange(SET_FILL_PAINT, null, null);
    }

    public Paint getFillPaint() {
        return this.fillpaint;
    }

    public void setAnchorLocator(TextAnchor.Locator locator) {
        if (locator == null) {
            locator = TextAnchor.LEFT_ASCENTLINE;
        }
        if (locator.equals(this.locator)) {
            return;
        }
        this.locator = locator;
        PaintableSequence sequence = this.getPaintableSequence();
        int length = sequence.length();
        int i = 0;
        while (i < length) {
            TextPaintable paintable = (TextPaintable)sequence.getPaintable(i);
            paintable.setAnchorLocator(locator);
            ++i;
        }
        this.firePropertyChange(SET_ANCHOR_LOCATOR, null, null);
    }

    public TextAnchor.Locator getAnchorLocator() {
        return this.locator;
    }

    public void setAnchorPosition(float anchorX, float anchorY) {
        float dx = anchorX - this.anchorX;
        float dy = anchorY - this.anchorY;
        this.shiftAnchorPosition(dx, dy);
    }

    public void setAnchorPosition(float[] position) {
        if (position == null || position.length != 2) {
            return;
        }
        this.setAnchorPosition(position[0], position[1]);
    }

    public void shiftAnchorPosition(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        this.anchorX += dx;
        this.anchorY += dy;
        PaintableSequence sequence = this.getPaintableSequence();
        int length = sequence.length();
        int i = 0;
        while (i < length) {
            TextPaintable paintable = (TextPaintable)sequence.getPaintable(i);
            paintable.shiftAnchorPosition(dx, dy);
            ++i;
        }
        this.addPreMutation(TransformFactory.translate(-dx, -dy));
        this.addPostMutation(TransformFactory.translate(dx, dy));
        this.firePropertyChange(SET_ANCHOR_POSITION, null, null);
    }

    public float[] getAnchorPosition() {
        return new float[]{this.anchorX, this.anchorY};
    }

    public XPoint2D getOriginalCenter() {
        XPoint2D center = this.getDefaultOriginalCenter();
        if (center != null) {
            return center;
        }
        return new XPoint2D(this.anchorX, this.anchorY);
    }
}

