/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.BasePane;
import edu.neu.ccs.gui.ColorView;
import edu.neu.ccs.gui.TablePanel;
import java.awt.Color;
import java.awt.event.ActionListener;

public class MultiColorView
extends BasePane {
    private int GAP = 6;
    private ColorView[] colorviews = null;
    private Annotation[] annotations = null;
    private int viewcount = 0;
    private TablePanel colorpanel = null;
    private ActionSequence setColorActions = new ActionSequence();
    public static Color[] testcolors = new Color[]{Colors.red, Colors.blue, Colors.lime, Colors.orange, Colors.skyblue, Colors.darkviolet, Colors.tan, Colors.black};

    public MultiColorView(Color[] colors, String[] labels) {
        this.initializeColorViews(colors);
        this.initializeAnnotations(labels);
        this.createColorPanel();
    }

    public final int getViewCount() {
        return this.viewcount;
    }

    public final Color getColor(int index) {
        if ((index %= this.viewcount) < 0) {
            index += this.viewcount;
        }
        return this.colorviews[index].getColor();
    }

    public final void setColor(int index, Color color) {
        if (color == null) {
            return;
        }
        if (index < 0 || index >= this.viewcount) {
            return;
        }
        this.colorviews[index].setColor(color);
    }

    public final void setColorHelper(int index, Color color) {
        if (color == null) {
            return;
        }
        if (index < 0 || index >= this.viewcount) {
            return;
        }
        this.colorviews[index].setColorHelper(color);
    }

    public final Color[] getColors() {
        Color[] colors = new Color[this.viewcount];
        int index = 0;
        while (index < this.viewcount) {
            colors[index] = this.colorviews[index].getColor();
            ++index;
        }
        return colors;
    }

    public final void addAction(ActionListener action) {
        this.setColorActions.add(action);
    }

    public final boolean removeAction(ActionListener action) {
        return this.setColorActions.remove(action);
    }

    public final ColorView getColorView(int i) {
        if (i < 0 || i >= this.viewcount) {
            return null;
        }
        return this.colorviews[i];
    }

    /*
     * Unable to fully structure code
     */
    private void initializeColorViews(Color[] colors) {
        length = colors == null ? 0 : colors.length;
        i = 0;
        while (i < length) {
            if (colors[i] != null) {
                ++this.viewcount;
            }
            ++i;
        }
        if (this.viewcount == 0) {
            colors = new Color[]{Colors.red};
            this.viewcount = 1;
        }
        this.colorviews = new ColorView[this.viewcount];
        index = 0;
        i = 0;
        ** GOTO lbl22
        {
            ++index;
            do {
                if (colors[index] == null) continue block1;
                this.colorviews[i] = new ColorView(colors[index], true);
                this.colorviews[i].addAction(this.setColorActions);
                ++index;
                ++i;
lbl22:
                // 2 sources

            } while (i < this.viewcount);
        }
    }

    private void initializeAnnotations(String[] labels) {
        this.annotations = new Annotation[this.viewcount];
        int length = labels == null ? 0 : labels.length;
        int index = 0;
        int i = 0;
        while (i < length && index < this.viewcount) {
            if (labels[i] != null) {
                this.makeAnnotation(index, labels[i]);
                ++index;
            }
            ++i;
        }
        while (index < this.viewcount) {
            this.makeAnnotation(index, "Color " + index);
            ++index;
        }
    }

    private void makeAnnotation(int index, String label) {
        this.annotations[index] = new Annotation(label, this.labelFont);
    }

    private void createColorPanel() {
        this.colorpanel = new TablePanel(this.viewcount, 2, this.GAP, this.GAP, 7);
        int row = 0;
        while (row < this.viewcount) {
            this.colorpanel.addObject((Object)this.annotations[row], row, 0);
            this.colorpanel.addObject((Object)this.colorviews[row], row, 1);
            ++row;
        }
        this.addObject(this.colorpanel);
    }

    public static void main(String[] args) {
        new MultiColorView(testcolors, null).frame("MultiColorView Test");
    }
}

