/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.MouseActionEvent;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.event.MouseInputListener;

public class MouseActionAdapter
implements MouseInputListener,
Cloneable,
Serializable {
    protected ActionSequence clickedActions = new ActionSequence();
    protected ActionSequence enteredActions = new ActionSequence();
    protected ActionSequence exitedActions = new ActionSequence();
    protected ActionSequence pressedActions = new ActionSequence();
    protected ActionSequence releasedActions = new ActionSequence();
    protected ActionSequence draggedActions = new ActionSequence();
    protected ActionSequence movedActions = new ActionSequence();

    public MouseActionAdapter() {
        this(null);
    }

    public MouseActionAdapter(Component target) {
        this.addAsListenerTo(target);
    }

    public final void mouseClicked(MouseEvent evt) {
        this.clickedActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public final void mouseEntered(MouseEvent evt) {
        this.enteredActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public final void mouseExited(MouseEvent evt) {
        this.exitedActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public final void mousePressed(MouseEvent evt) {
        this.pressedActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public final void mouseReleased(MouseEvent evt) {
        this.releasedActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public final void mouseDragged(MouseEvent evt) {
        this.draggedActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public final void mouseMoved(MouseEvent evt) {
        this.movedActions.actionPerformed(new MouseActionEvent(evt, evt.getSource()));
    }

    public void addAsListenerTo(Component c) {
        if (c == null) {
            return;
        }
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
    }

    public void removeAsListenerTo(Component c) {
        if (c == null) {
            return;
        }
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this);
    }

    public void addMouseClickedAction(ActionListener a) {
        this.clickedActions.add(a);
    }

    public void addMouseEnteredAction(ActionListener a) {
        this.enteredActions.add(a);
    }

    public void addMouseExitedAction(ActionListener a) {
        this.exitedActions.add(a);
    }

    public void addMousePressedAction(ActionListener a) {
        this.pressedActions.add(a);
    }

    public void addMouseReleasedAction(ActionListener a) {
        this.releasedActions.add(a);
    }

    public void addMouseDraggedAction(ActionListener a) {
        this.draggedActions.add(a);
    }

    public void addMouseMovedAction(ActionListener a) {
        this.movedActions.add(a);
    }

    public void removeMouseClickedAction(ActionListener a) {
        this.clickedActions.remove(a);
    }

    public void removeMouseEnteredAction(ActionListener a) {
        this.enteredActions.remove(a);
    }

    public void removeMouseExitedAction(ActionListener a) {
        this.exitedActions.remove(a);
    }

    public void removeMousePressedAction(ActionListener a) {
        this.pressedActions.remove(a);
    }

    public void removeMouseReleasedAction(ActionListener a) {
        this.releasedActions.remove(a);
    }

    public void removeMouseDraggedAction(ActionListener a) {
        this.draggedActions.remove(a);
    }

    public void removeMouseMovedAction(ActionListener a) {
        this.movedActions.remove(a);
    }

    public void setMouseClickedActions(ActionSequence sequence) {
        if (sequence == null) {
            this.clickedActions.clear();
        } else {
            this.clickedActions = sequence;
        }
    }

    public void setMouseEnteredActions(ActionSequence sequence) {
        if (sequence == null) {
            this.enteredActions.clear();
        } else {
            this.enteredActions = sequence;
        }
    }

    public void setMouseExitedActions(ActionSequence sequence) {
        if (sequence == null) {
            this.exitedActions.clear();
        } else {
            this.exitedActions = sequence;
        }
    }

    public void setMousePressedActions(ActionSequence sequence) {
        if (sequence == null) {
            this.pressedActions.clear();
        } else {
            this.pressedActions = sequence;
        }
    }

    public void setMouseReleasedActions(ActionSequence sequence) {
        if (sequence == null) {
            this.releasedActions.clear();
        } else {
            this.releasedActions = sequence;
        }
    }

    public void setMouseDraggedActions(ActionSequence sequence) {
        if (sequence == null) {
            this.draggedActions.clear();
        } else {
            this.draggedActions = sequence;
        }
    }

    public void setMouseMovedActions(ActionSequence sequence) {
        if (sequence == null) {
            this.movedActions.clear();
        } else {
            this.movedActions = sequence;
        }
    }

    public ActionSequence getMouseClickedActions() {
        return this.clickedActions;
    }

    public ActionSequence getMouseEnteredActions() {
        return this.enteredActions;
    }

    public ActionSequence getMouseExitedActions() {
        return this.exitedActions;
    }

    public ActionSequence getMousePressedActions() {
        return this.pressedActions;
    }

    public ActionSequence getMouseReleasedActions() {
        return this.releasedActions;
    }

    public ActionSequence getMouseDraggedActions() {
        return this.draggedActions;
    }

    public ActionSequence getMouseMovedActions() {
        return this.movedActions;
    }

    public void uninstallAllMouseActions() {
        this.setMouseMovedActions(null);
        this.setMousePressedActions(null);
        this.setMouseReleasedActions(null);
        this.setMouseClickedActions(null);
        this.setMouseDraggedActions(null);
        this.setMouseEnteredActions(null);
        this.setMouseExitedActions(null);
    }
}

