/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.DropdownView;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.OptionsView;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class LookAndFeelTools
implements JPTConstants {
    private static final int MAX_ADJUSTMENT = 20;
    private static float netFontSizeAdjustment = 0.0f;
    public static final float MINIMUM_NET_FONT_SIZE_ADJUSTMENT = -2.0f;

    private LookAndFeelTools() {
    }

    public static void showSelectLookAndFeelDialog() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int length = info.length;
        String[] name = new String[length];
        String[] className = new String[length];
        int i = 0;
        while (i < length) {
            name[i] = info[i].getName();
            className[i] = info[i].getClassName();
            ++i;
        }
        String selectNameString = "Select Look and Feel:";
        OptionsView selectNameView = new OptionsView(name, 0, (LayoutManager)new TableLayout(1, length));
        String fontSizeAdjustString = "Font Size Adjustment:";
        String[] fontSizeAdjustList = new String[21];
        int i2 = 0;
        while (i2 <= 20) {
            fontSizeAdjustList[i2] = "" + i2;
            ++i2;
        }
        DropdownView fontSizeAdjustView = new DropdownView(fontSizeAdjustList, "0", true);
        fontSizeAdjustView.setMaximumRowCount(21);
        fontSizeAdjustView.setPreferredWidth(0, "00000000");
        TablePanel panel = new TablePanel(new Object[][]{{selectNameString, selectNameView}, {fontSizeAdjustString, fontSizeAdjustView}}, 5, 10, 7);
        String panelString = "Select Look and Feel";
        try {
            GeneralDialog.showOKCancelDialog(panel, panelString);
        }
        catch (Exception e) {
            return;
        }
        try {
            UIManager.setLookAndFeel(className[selectNameView.getSelectedIndex()]);
        }
        catch (Exception e) {
            return;
        }
        try {
            LookAndFeelTools.adjustAllDefaultFontSizes(fontSizeAdjustView.demandFloat());
        }
        catch (Exception e) {
            return;
        }
    }

    public static String[] getInstalledLookAndFeelNames() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int length = info.length;
        String[] name = new String[length];
        int i = 0;
        while (i < length) {
            name[i] = info[i].getName();
            ++i;
        }
        return name;
    }

    public static String[] getInstalledLookAndFeelClassNames() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int length = info.length;
        String[] className = new String[length];
        int i = 0;
        while (i < length) {
            className[i] = info[i].getClassName();
            ++i;
        }
        return className;
    }

    public static void adjustAllDefaultFontSizes(float delta) {
        if (netFontSizeAdjustment + delta < -2.0f) {
            delta = -2.0f - netFontSizeAdjustment;
        }
        netFontSizeAdjustment += delta;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Set keyset = defaults.keySet();
        Object[] keys = keyset.toArray();
        int length = keys.length;
        String fontWord = "font";
        int i = 0;
        while (i < length) {
            Object object;
            String key;
            if (keys[i] instanceof String && (key = (String)keys[i]).indexOf(fontWord) >= 0 && (object = defaults.get(key)) instanceof Font) {
                Font font = (Font)object;
                float size = font.getSize2D() + delta;
                font = new FontUIResource(font.deriveFont(size));
                defaults.put(key, font);
            }
            ++i;
        }
    }

    public static void setNetFontSizeAdjustment(float delta) {
        LookAndFeelTools.adjustAllDefaultFontSizes(delta - netFontSizeAdjustment);
    }

    public static float getNetFontSizeAdjustment() {
        return netFontSizeAdjustment;
    }
}

