/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbsoluteLayout;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.Tile;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JComponent;

public class LayeredComponent
extends JComponent {
    protected JComponent foreground = null;
    protected PaintableComponent lowerLayer = null;
    protected Paintable topmostPaintable = null;
    protected Paintable tilePaintable = null;
    protected XPoint2D corner = null;
    protected Tile tile1 = new Tile();
    protected Tile tile2 = new Tile(this.tile1);
    protected boolean centered = false;

    public LayeredComponent(JComponent foreground, Object topmost, Object tile, Paint paint, float opacity, boolean centered) {
        if (foreground == null) {
            String message = "Null foreground component passed to LayeredComponent";
            throw new NullPointerException(message);
        }
        this.foreground = foreground;
        foreground.setOpaque(false);
        Dimension size = foreground.getPreferredSize();
        int w = size.width;
        int h = size.height;
        XRect bounds = new XRect(0.0, 0.0, w, h);
        this.tile2.setDefaultBounds2D(bounds);
        this.tile2.setOpacity(opacity);
        this.centered = centered;
        this.setTopmostPaintable(topmost);
        this.setBackgroundPaint(paint);
        this.setBackgroundTile(tile);
        this.setLayout(new AbsoluteLayout());
        this.lowerLayer = new PaintableComponent(this.tile2);
        this.add(foreground);
        this.add(this.lowerLayer);
    }

    public void setTopmostPaintable(Object topmost) {
        this.topmostPaintable = ComponentFactory.makePaintable(topmost);
        this.corner = this.topmostPaintable != null ? this.topmostPaintable.getCorner() : null;
        this.tile1.setPaintable(this.topmostPaintable);
        this.setCentered(this.centered);
    }

    public Paintable getTopmostPaintable() {
        return this.topmostPaintable;
    }

    public void setBackgroundTile(Object tile) {
        this.tilePaintable = ComponentFactory.makePaintable(tile);
        this.tile2.setBackgroundTile(this.tilePaintable);
        this.repaint();
    }

    public Paintable getBackgroundTile() {
        return this.tilePaintable;
    }

    public void setBackgroundPaint(Paint paint) {
        this.tile2.setBackgroundPaint(paint);
        this.repaint();
    }

    public Paint getBackgroundPaint() {
        return this.tile2.getBackgroundPaint();
    }

    public void setOpacity(float opacity) {
        this.tile2.setOpacity(opacity);
        this.repaint();
    }

    public float getOpacity() {
        return this.tile2.getOpacity();
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
        if (this.topmostPaintable != null) {
            if (centered) {
                Dimension size = this.foreground.getPreferredSize();
                int w = size.width;
                int h = size.height;
                this.tile1.moveCenterTo(w / 2, h / 2);
            } else {
                this.tile1.moveCornerTo(this.corner);
            }
        }
        this.repaint();
    }

    public boolean isCentered() {
        return this.centered;
    }
}

