/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XInt;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class JPTFrame
extends JFrame
implements JPTConstants {
    public static final int EXIT_ON_CLOSE = 3;
    public static final int EXIT_ON_CLOSE_IF_LAST = 6;
    public static final int DEFAULT_CLOSE_OPERATION = 6;
    private static final Insets INSETS = new Insets(50, 50, 50, 50);
    protected static XInt counter = new XInt(0);
    protected int closeOperation = 6;
    protected Insets screen_insets = (Insets)INSETS.clone();

    public JPTFrame() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPTFrame(String title) {
        super(title);
        super.setDefaultCloseOperation(0);
        this.setDefaultCloseOperation(6);
        this.installWindowAdapter();
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() + 1);
        }
    }

    public void center() {
        this.setLocation(0);
    }

    public void setLocation(int location) {
        this.setLocation(location, this.screen_insets);
    }

    public void setLocation(int location, Insets insets) {
        if (insets == null) {
            insets = INSETS;
        }
        this.screen_insets = (Insets)insets.clone();
        if (this.screen_insets.left < 0) {
            this.screen_insets.left = 0;
        }
        if (this.screen_insets.right < 0) {
            this.screen_insets.right = 0;
        }
        if (this.screen_insets.top < 0) {
            this.screen_insets.top = 0;
        }
        if (this.screen_insets.bottom < 0) {
            this.screen_insets.bottom = 0;
        }
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point();
        int dx = size.width - this.screen_insets.left - this.screen_insets.right - this.getWidth();
        int dy = size.height - this.screen_insets.top - this.screen_insets.bottom - this.getHeight();
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        int flushWest = this.screen_insets.left;
        int centerWE = this.screen_insets.left + dx / 2;
        int flushEast = this.screen_insets.left + dx;
        int flushNorth = this.screen_insets.top;
        int centerNS = this.screen_insets.top + dy / 2;
        int flushSouth = this.screen_insets.top + dy;
        switch (location) {
            case 1: {
                p.setLocation(centerWE, flushNorth);
                break;
            }
            case 2: {
                p.setLocation(flushEast, flushNorth);
                break;
            }
            case 3: {
                p.setLocation(flushEast, centerNS);
                break;
            }
            case 4: {
                p.setLocation(flushEast, flushSouth);
                break;
            }
            case 5: {
                p.setLocation(centerWE, flushSouth);
                break;
            }
            case 6: {
                p.setLocation(flushWest, flushSouth);
                break;
            }
            case 7: {
                p.setLocation(flushWest, centerNS);
                break;
            }
            case 8: {
                p.setLocation(flushWest, flushNorth);
                break;
            }
            default: {
                p.setLocation(centerWE, centerNS);
            }
        }
        this.setLocation(p.x, p.y);
    }

    public Insets getScreenInsets() {
        return (Insets)this.screen_insets.clone();
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.getSize().width + this.getInsets().left + this.getInsets().right, this.getSize().height + this.getInsets().top + this.getInsets().bottom);
    }

    public void setDefaultCloseOperation(int operation) {
        switch (operation) {
            case -1: {
                this.closeOperation = 6;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                this.closeOperation = operation;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getDefaultCloseOperation() {
        return this.closeOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getJPTFrameCount() {
        XInt xInt = counter;
        synchronized (xInt) {
            return counter.getValue();
        }
    }

    public void dispose() {
        JPTFrame.decrementCounter();
        super.dispose();
    }

    public void normal() {
        this.setExtendedState(0);
    }

    public void iconify() {
        this.setExtendedState(1);
    }

    public void maximize() {
        this.setExtendedState(6);
    }

    public void toggle() {
        int state = this.getExtendedState();
        if (state != 0) {
            this.normal();
        } else {
            this.iconify();
        }
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), -1, null);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, int location) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), location, null);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, Insets insets) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), -1, insets);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, int location, Insets insets) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), location, insets);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, LayoutManager layout) {
        return JPTFrame.createQuickJPTFrame(title, object, layout, -1, null);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, LayoutManager layout, int location) {
        return JPTFrame.createQuickJPTFrame(title, object, layout, location, null);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, LayoutManager layout, Insets insets) {
        return JPTFrame.createQuickJPTFrame(title, object, layout, -1, insets);
    }

    public static JPTFrame createQuickJPTFrame(String title, Object object, LayoutManager layout, int location, Insets insets) {
        Component contents = ComponentFactory.makeComponent(object);
        JPTFrame f = new JPTFrame(title == null ? "" : title);
        if (layout != null) {
            f.getContentPane().setLayout(layout);
        }
        if (contents != null) {
            f.getContentPane().add(contents);
        }
        f.pack();
        f.setVisible(true);
        f.setLocation(location, insets);
        return f;
    }

    public static JPTFrame frame(Object object) {
        return JPTFrame.createQuickJPTFrame("", object, new CenterLayout(), -1, null);
    }

    public static JPTFrame frame(Object object, int location) {
        return JPTFrame.createQuickJPTFrame("", object, new CenterLayout(), location, null);
    }

    public static JPTFrame frame(Object object, String title) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), -1, null);
    }

    public static JPTFrame frame(Object object, String title, int location) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), location, null);
    }

    public static JPTFrame frame(Object object, String title, Insets insets) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), -1, insets);
    }

    public static JPTFrame frame(Object object, String title, int location, Insets insets) {
        return JPTFrame.createQuickJPTFrame(title, object, new CenterLayout(), location, insets);
    }

    protected static XInt getCounter() {
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementCounter() {
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementCounter() {
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() - 1);
        }
    }

    public void installWindowAdapter() {
        WindowActionAdapter adapter = new WindowActionAdapter(this);
        adapter.addWindowClosingAction(new SimpleAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                XInt xInt = JPTFrame.getCounter();
                synchronized (xInt) {
                    int operation = JPTFrame.this.getDefaultCloseOperation();
                    if (operation == 0) {
                        return;
                    }
                    JPTFrame.this.setVisible(false);
                    if (operation == 1) {
                        return;
                    }
                    JPTFrame.this.dispose();
                    if (operation == 2) {
                        return;
                    }
                    if (operation == 3 || JPTFrame.getJPTFrameCount() == 0) {
                        System.exit(0);
                    }
                }
            }
        });
    }
}

