/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Borders;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.KeyActionAdapter;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.SupportsPropertyChange;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public abstract class JPTComponent
extends JComponent
implements JPTConstants,
SupportsPropertyChange {
    private PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);
    private KeyActionAdapter keyActionAdapter = new KeyActionAdapter(this);
    private MouseActionAdapter mouseActionAdapter = new MouseActionAdapter(this);

    public final void addPropertyChangeListeners(PropertyChangeListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            this.addPropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public final void addPropertyChangeListeners(String propertyName, PropertyChangeListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            this.addPropertyChangeListener(propertyName, listeners[i]);
            ++i;
        }
    }

    public final boolean hasListeners(String propertyName) {
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners(propertyName);
        return listeners == null ? false : listeners.length > 0;
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final void firePropertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String property = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        this.firePropertyChange(property, oldValue, newValue);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange spc = (SupportsPropertyChange)object;
            spc.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange spc = (SupportsPropertyChange)object;
            spc.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object oldobject, Object newobject) {
        this.removeForwardingListener(oldobject);
        this.addForwardingListener(newobject);
    }

    public final KeyActionAdapter getKeyActionAdapter() {
        return this.keyActionAdapter;
    }

    public final MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActionAdapter;
    }

    public Border addBorder(Border border) {
        Border current = this.getBorder();
        if (border == null) {
            return current;
        }
        if (current == null) {
            this.setBorder(border);
            return border;
        }
        CompoundBorder compound = BorderFactory.createCompoundBorder(border, current);
        this.setBorder(compound);
        return compound;
    }

    public Border removeBorder() {
        Border current = this.getBorder();
        this.setBorder(null);
        return current;
    }

    public void emptyBorder(int thickness) {
        this.emptyBorder(thickness, thickness, thickness, thickness);
    }

    public void emptyBorder(int vgap, int hgap) {
        this.emptyBorder(vgap, hgap, vgap, hgap);
    }

    public void emptyBorder(int top, int left, int bottom, int right) {
        this.addBorder(Borders.empty(top, left, bottom, right));
    }

    public void matteBorder(int thickness, Color color) {
        this.matteBorder(thickness, thickness, thickness, thickness, color);
    }

    public void matteBorder(int vgap, int hgap, Color color) {
        this.matteBorder(vgap, hgap, vgap, hgap, color);
    }

    public void matteBorder(int top, int left, int bottom, int right, Color color) {
        this.addBorder(Borders.matte(top, left, bottom, right, color));
    }

    public void matteBorder(int thickness, Icon tileicon) {
        this.matteBorder(thickness, thickness, thickness, thickness, tileicon);
    }

    public void matteBorder(int vgap, int hgap, Icon tileicon) {
        this.matteBorder(vgap, hgap, vgap, hgap, tileicon);
    }

    public void matteBorder(int top, int left, int bottom, int right, Icon tileicon) {
        this.addBorder(Borders.matte(top, left, bottom, right, tileicon));
    }

    public void lineBorder() {
        this.lineBorder(Color.black, 1);
    }

    public void lineBorder(Color color) {
        this.lineBorder(color, 1);
    }

    public void lineBorder(Color color, int thickness) {
        this.addBorder(Borders.line(color, thickness));
    }

    public void etchBorderLowered() {
        this.addBorder(Borders.etchLowered());
    }

    public void etchBorderLowered(Color highlight, Color shadow) {
        this.addBorder(Borders.etchLowered(highlight, shadow));
    }

    public void etchBorderLowered(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.etchLowered(levels, highlight, shadow));
    }

    public void etchBorderRaised() {
        this.addBorder(Borders.etchRaised());
    }

    public void etchBorderRaised(Color highlight, Color shadow) {
        this.addBorder(Borders.etchRaised(highlight, shadow));
    }

    public void etchBorderRaised(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.etchRaised(levels, highlight, shadow));
    }

    public void bevelBorderLowered() {
        this.addBorder(Borders.bevelLowered());
    }

    public void bevelBorderLowered(Color highlight, Color shadow) {
        this.addBorder(Borders.bevelLowered(highlight, shadow));
    }

    public void bevelBorderLowered(Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelLowered(highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void bevelBorderLowered(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.bevelLowered(levels, highlight, shadow));
    }

    public void bevelBorderLowered(int levels, Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelLowered(levels, highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void bevelBorderRaised() {
        this.addBorder(Borders.bevelRaised());
    }

    public void bevelBorderRaised(Color highlight, Color shadow) {
        this.addBorder(Borders.bevelRaised(highlight, shadow));
    }

    public void bevelBorderRaised(Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelRaised(highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void bevelBorderRaised(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.bevelRaised(levels, highlight, shadow));
    }

    public void bevelBorderRaised(int levels, Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelRaised(levels, highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void titleBorder(String t, int hPosition, int vPosition, Border base, Font font, Color fontcolor) {
        TitledBorder border = Borders.title(t, hPosition, vPosition, base, font, fontcolor);
        this.addBorder(border);
    }

    public void setDeepBackground(Color c) {
        this.setBackground(c);
        Component[] components = this.getComponents();
        int length = components.length;
        int i = 0;
        while (i < length) {
            Component component = components[i];
            if (component != null) {
                if (component instanceof DisplayPanel) {
                    DisplayPanel panel = (DisplayPanel)component;
                    panel.setDeepBackground(c);
                } else if (component instanceof JPTComponent) {
                    JPTComponent thing = (JPTComponent)component;
                    thing.setDeepBackground(c);
                } else {
                    component.setBackground(c);
                }
            }
            ++i;
        }
    }

    public void setDeepBackground(Color c, Class type) {
        if (type == null) {
            return;
        }
        if (type.isInstance(this)) {
            this.setBackground(c);
        }
        Component[] components = this.getComponents();
        int length = components.length;
        int i = 0;
        while (i < length) {
            Component component = components[i];
            if (component != null) {
                if (component instanceof DisplayPanel) {
                    DisplayPanel panel = (DisplayPanel)component;
                    panel.setDeepBackground(c, type);
                } else if (component instanceof JPTComponent) {
                    JPTComponent thing = (JPTComponent)component;
                    thing.setDeepBackground(c, type);
                } else if (type.isInstance(component)) {
                    component.setBackground(c);
                }
            }
            ++i;
        }
    }

    public JPTFrame frame() {
        return this.frame(null, 0, null);
    }

    public JPTFrame frame(int location) {
        return this.frame(null, location, null);
    }

    public JPTFrame frame(String title) {
        return this.frame(title, 0, null);
    }

    public JPTFrame frame(String title, int location) {
        return this.frame(title, location, null);
    }

    public JPTFrame frame(String title, Insets insets) {
        return this.frame(title, 0, insets);
    }

    public JPTFrame frame(String title, int location, Insets insets) {
        return JPTFrame.frame(this, title, location, insets);
    }

    public GeneralDialog OKDialog() {
        return this.OKDialog(null);
    }

    public GeneralDialog OKDialog(String title) {
        GeneralDialog dialog = GeneralDialog.makeOKDialog(this, title);
        dialog.setVisible(true);
        return dialog;
    }

    public GeneralDialog OKCancelDialog() {
        return this.OKCancelDialog(null);
    }

    public GeneralDialog OKCancelDialog(String title) {
        GeneralDialog dialog = GeneralDialog.makeOKCancelDialog(this, title);
        dialog.setVisible(true);
        return dialog;
    }

    public GeneralDialog YesNoCancelDialog() {
        return this.YesNoCancelDialog(null);
    }

    public GeneralDialog YesNoCancelDialog(String title) {
        GeneralDialog dialog = GeneralDialog.makeYesNoCancelDialog(this, title);
        dialog.setVisible(true);
        return dialog;
    }

    public GeneralDialog generalDialog(Object[][] actionData) {
        return this.generalDialog(null, actionData, null);
    }

    public GeneralDialog generalDialog(Object[][] actionData, Object defaultAction) {
        return this.generalDialog(null, actionData, defaultAction);
    }

    public GeneralDialog generalDialog(String title, Object[][] actionData) {
        return this.generalDialog(title, actionData, null);
    }

    public GeneralDialog generalDialog(String title, Object[][] actionData, Object defaultAction) {
        GeneralDialog dialog = new GeneralDialog((Object)this, title, actionData, defaultAction);
        dialog.setVisible(true);
        return dialog;
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

