/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.JPTDialog;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Frame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class InputDialog
extends JPTDialog
implements JPTConstants {
    protected Stringable model = null;
    protected boolean cancelled = false;

    public InputDialog(TypedView viewObject) {
        super(InputDialog.getCompoundView(viewObject), (String)null, (Frame)null, true);
        this.setResizable(false);
        JPanel pane = (JPanel)this.getContentPane();
        pane.setBorder(new EmptyBorder(20, 20, 20, 20));
        InputProperties properties = this.view.getInputProperties();
        this.setTitle((String)properties.getProperty("dialog.title"));
        this.setDefaultCloseOperation(0);
        this.createWindowListener(properties);
        this.createActionsPanel(properties);
        this.pack();
        this.center();
    }

    public Stringable getModel() {
        return this.model;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public static Stringable showDemandDialog(TypedView viewObject) {
        InputDialog dialog = InputDialog.showInputDialog(viewObject, 0);
        return dialog.getModel();
    }

    public static Stringable showRequestDialog(TypedView viewObject) throws CancelledException {
        InputDialog dialog = InputDialog.showInputDialog(viewObject, 1);
        if (dialog.wasCancelled()) {
            throw new CancelledException();
        }
        return dialog.getModel();
    }

    protected void ok() {
        InputProperties properties = this.view.getInputProperties();
        int inputModel = (Integer)properties.getProperty("input.model");
        if (inputModel == 0) {
            this.demand();
        } else {
            this.request();
        }
    }

    protected void demand() {
        this.model = this.view.demandObject();
        this.setVisible(false);
        this.dispose();
    }

    protected void request() {
        try {
            this.model = this.view.requestObject();
            this.setVisible(false);
            this.dispose();
        }
        catch (CancelledException ex) {
            this.model = null;
        }
    }

    protected void reset() {
        this.view.reset();
    }

    protected void suggest() {
        InputProperties properties = this.view.getInputProperties();
        String suggestion = (String)properties.getProperty("suggestion");
        if (suggestion == null) {
            suggestion = "";
        }
        this.view.setViewState(suggestion);
    }

    protected void cancel() {
        this.cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    protected void refuse() {
        JOptionPane.showMessageDialog(this, "You must provide a valid value and press OK", "Input required", 0);
    }

    protected void createWindowListener(InputProperties properties) {
        int inputModel = (Integer)properties.getProperty("input.model");
        WindowActionAdapter adapter = new WindowActionAdapter(this);
        if (inputModel == 0) {
            adapter.addWindowClosingAction(new SimpleAction(){

                public void perform() {
                    InputDialog.this.refuse();
                }
            });
        } else {
            adapter.addWindowClosingAction(new SimpleAction(){

                public void perform() {
                    InputDialog.this.cancel();
                }
            });
        }
    }

    protected void createActionsPanel(InputProperties properties) {
        int inputModel = (Integer)properties.getProperty("input.model");
        String suggestion = (String)properties.getProperty("suggestion");
        this.addDefaultAction(new SimpleAction("OK"){

            public void perform() {
                InputDialog.this.ok();
            }
        });
        this.addAction(new SimpleAction("Reset"){

            public void perform() {
                InputDialog.this.reset();
            }
        });
        if (suggestion != null) {
            this.addAction(new SimpleAction("Suggest"){

                public void perform() {
                    InputDialog.this.suggest();
                }
            });
        }
        if (inputModel == 1) {
            this.addAction(new SimpleAction("Cancel"){

                public void perform() {
                    InputDialog.this.cancel();
                }
            });
        }
    }

    protected static TypedView getCompoundView(TypedView viewObject) {
        return new CompoundView(viewObject);
    }

    private static InputDialog showInputDialog(TypedView viewObject, int inputModel) {
        InputProperties oldProperties = InputDialog.setInputModel(viewObject, inputModel);
        InputDialog dialog = new InputDialog(viewObject);
        dialog.setVisible(true);
        viewObject.setInputProperties(oldProperties);
        return dialog;
    }

    private static InputProperties setInputModel(TypedView viewObject, int inputModel) {
        InputProperties oldProperties = viewObject.getInputProperties();
        InputProperties newProperties = new InputProperties(oldProperties);
        newProperties.setProperty("input.model", new Integer(inputModel));
        viewObject.setInputProperties(newProperties);
        return oldProperties;
    }

    static class CompoundView
    extends Display
    implements TypedView {
        private TypedView view = null;

        public CompoundView(TypedView viewObject) {
            super(viewObject, (String)viewObject.getInputProperties().getProperty("input.prompt"), null, 1, -1);
            this.view = viewObject;
        }

        public Stringable demandObject() {
            return this.view.demandObject();
        }

        public Stringable requestObject() throws CancelledException {
            return this.view.requestObject();
        }

        public void setInputProperties(InputProperties properties) {
            this.view.setInputProperties(properties);
        }

        public InputProperties getInputProperties() {
            return this.view.getInputProperties();
        }

        public Class getDataType() {
            return this.view.getDataType();
        }
    }
}

