/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.ImagePaintableLite;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.Tile;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;

public class ImageViewerBase
extends DisplayPanel {
    protected String[] imageFileNames;
    protected ImagePaintableLite[] paintables;
    protected int X_MAX = 0;
    protected int Y_MAX = 0;
    protected int Y_MAX_SMALL = 0;

    protected ImageViewerBase() {
    }

    protected JPTScrollPane makeGUI(boolean autoscale) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.X_MAX = size.width - 150;
        this.Y_MAX = size.height - 150;
        this.Y_MAX_SMALL = this.Y_MAX - 2 * ImageViewerBase.getAnnotationHeight();
        int length = this.imageFileNames.length;
        TablePanel panel = new TablePanel(length, 1, 0, 0, 0);
        int i = 0;
        while (i < length) {
            panel.addObject((Object)this.makeInnerGUI(i, autoscale), i, 0);
            ++i;
        }
        Dimension dimension = panel.getPreferredSize();
        dimension.width = dimension.width <= this.X_MAX ? dimension.width : this.X_MAX;
        dimension.height = dimension.height <= this.Y_MAX ? dimension.height : this.Y_MAX;
        JPTScrollPane scrollpane = new JPTScrollPane(panel);
        scrollpane.boundViewportPreferredSize(dimension);
        return scrollpane;
    }

    protected TablePanel makeInnerGUI(int index, boolean autoscale) {
        AbstractPaintable paintable = this.paintables[index];
        int width = this.paintables[index].getImageWidth();
        int height = this.paintables[index].getImageHeight();
        String title1 = this.imageFileNames[index];
        String title2 = "#" + index + ": " + width + " x " + height;
        if (autoscale && (width > this.X_MAX || height > this.Y_MAX_SMALL)) {
            double a = (double)this.X_MAX / (double)width;
            double b = (double)this.Y_MAX_SMALL / (double)height;
            double s = Math.min(a, b);
            AffineTransform scaleTransform = TransformFactory.scale(0.0, 0.0, 0.0, s, s);
            paintable = new Tile((Object)paintable, scaleTransform);
        }
        return new TablePanel(new Object[]{paintable, title1, title2}, 1, 0, 0, 0);
    }

    protected static int getAnnotationHeight() {
        Annotation test = new Annotation("Xy");
        Dimension size = test.getPreferredSize();
        return size.height;
    }
}

