/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ImagePaintable;
import edu.neu.ccs.gui.ImagePaintableLite;
import edu.neu.ccs.util.TextTools;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.ImageIcon;

public class ImageTools {
    public static final FilenameFilter imageFilter = new FilenameFilter(){

        public boolean accept(File directory, String name) {
            if (name == null) {
                return false;
            }
            int length = name.length();
            if (length < 5) {
                return false;
            }
            return (name = name.substring(length - 4).toLowerCase()).equals(".jpg") || name.equals(".gif") || name.equals(".png");
        }
    };

    private ImageTools() {
    }

    public static Image[] readImages(String directory, String[] imageFileNames) {
        if (directory == null || imageFileNames == null) {
            return new Image[0];
        }
        int length = imageFileNames.length;
        Image[] images = new Image[length];
        int i = 0;
        while (i < length) {
            String path = TextTools.makePath(directory, imageFileNames[i]);
            images[i] = new ImageIcon(path).getImage();
            ++i;
        }
        return images;
    }

    public static Image[] readImages(String directory, String filelist) {
        String[] imageFileNames = ImageTools.readImageFileNames(directory, filelist);
        return ImageTools.readImages(directory, imageFileNames);
    }

    public static Image[] readAllImages(String directory) {
        String[] imageFileNames = ImageTools.readAllImageFileNames(directory);
        return ImageTools.readImages(directory, imageFileNames);
    }

    public static ImagePaintable[] readImagesAsPaintable(String directory, String[] imageFileNames) {
        if (directory == null || imageFileNames == null) {
            return new ImagePaintable[0];
        }
        int length = imageFileNames.length;
        ImagePaintable[] paintables = new ImagePaintable[length];
        int i = 0;
        while (i < length) {
            String path = TextTools.makePath(directory, imageFileNames[i]);
            paintables[i] = new ImagePaintable(path);
            ++i;
        }
        return paintables;
    }

    public static ImagePaintable[] readImagesAsPaintable(String directory, String filelist) {
        String[] imageFileNames = ImageTools.readImageFileNames(directory, filelist);
        return ImageTools.readImagesAsPaintable(directory, imageFileNames);
    }

    public static ImagePaintable[] readAllImagesAsPaintable(String directory) {
        String[] imageFileNames = ImageTools.readAllImageFileNames(directory);
        return ImageTools.readImagesAsPaintable(directory, imageFileNames);
    }

    public static ImagePaintableLite[] readImagesAsPaintableLite(String directory, String[] imageFileNames) {
        if (directory == null || imageFileNames == null) {
            return new ImagePaintableLite[0];
        }
        int length = imageFileNames.length;
        ImagePaintableLite[] paintables = new ImagePaintableLite[length];
        int i = 0;
        while (i < length) {
            String path = TextTools.makePath(directory, imageFileNames[i]);
            paintables[i] = new ImagePaintableLite(path);
            ++i;
        }
        return paintables;
    }

    public static ImagePaintableLite[] readImagesAsPaintableLite(String directory, String filelist) {
        String[] imageFileNames = ImageTools.readImageFileNames(directory, filelist);
        return ImageTools.readImagesAsPaintableLite(directory, imageFileNames);
    }

    public static ImagePaintableLite[] readAllImagesAsPaintableLite(String directory) {
        String[] imageFileNames = ImageTools.readAllImageFileNames(directory);
        return ImageTools.readImagesAsPaintableLite(directory, imageFileNames);
    }

    public static String[] readAllImageFileNames(String directory) {
        if (directory == null) {
            return new String[0];
        }
        File imagesDirectory = new File(directory);
        String[] files = imagesDirectory.list(imageFilter);
        if (files == null) {
            return new String[0];
        }
        return files;
    }

    public static String[] readImageFileNames(String directory, String filelist) {
        if (directory == null) {
            return new String[0];
        }
        if (filelist == null) {
            return ImageTools.readAllImageFileNames(directory);
        }
        if ((filelist = filelist.trim()).length() == 0) {
            return ImageTools.readAllImageFileNames(directory);
        }
        return TextTools.readFileNames(directory, filelist);
    }
}

