/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePaintableLite
extends AbstractPaintable {
    public static final String SET_IMAGE = "set.image";
    public static final String SET_TOP_LEFT_CORNER = "set.top.left.corner";
    private String imageFileName = null;
    private URL imageURL = null;
    private double xCorner = 0.0;
    private double yCorner = 0.0;
    private int width = 0;
    private int height = 0;

    public ImagePaintableLite() {
    }

    public ImagePaintableLite(String filename) {
        this.setImageByFileName(filename);
    }

    public ImagePaintableLite(String filename, Point2D corner) {
        this.setImageByFileName(filename);
        this.setTopLeftCorner(corner);
    }

    public ImagePaintableLite(String filename, double x, double y) {
        this.setImageByFileName(filename);
        this.setTopLeftCorner(x, y);
    }

    public ImagePaintableLite(URL url) {
        this.setImageByURL(url);
    }

    public ImagePaintableLite(URL url, Point2D corner) {
        this.setImageByURL(url);
        this.setTopLeftCorner(corner);
    }

    public ImagePaintableLite(URL url, double x, double y) {
        this.setImageByURL(url);
        this.setTopLeftCorner(x, y);
    }

    public final void originalPaint(Graphics g) {
        if (g == null || !this.isVisible()) {
            return;
        }
        Image image = this.fetchImage();
        if (image == null) {
            return;
        }
        Graphics2D h = (Graphics2D)g.create();
        AffineTransform T = TransformFactory.translate(this.xCorner, this.yCorner);
        h.drawImage(image, T, null);
    }

    public final XRect getActualBounds2D() {
        if (this.width == 0 || this.height == 0) {
            return null;
        }
        return new XRect(this.xCorner, this.yCorner, this.width, this.height);
    }

    public final boolean originalContains(double x, double y) {
        if (this.width <= 0 || this.height <= 0) {
            return false;
        }
        return this.possiblyContains(x, y);
    }

    public final void setImageByFileName(String filename) {
        this.imageURL = null;
        this.imageFileName = filename;
        this.setImageSizeParameters();
    }

    public final void setImageByURL(URL url) {
        this.imageFileName = null;
        this.imageURL = url;
        this.setImageSizeParameters();
    }

    public final void setTopLeftCorner(Point2D corner) {
        if (corner == null) {
            return;
        }
        this.setTopLeftCorner(corner.getX(), corner.getY());
    }

    public final void setTopLeftCorner(double x, double y) {
        if (x != this.xCorner || y != this.yCorner) {
            this.xCorner = x;
            this.yCorner = y;
            this.firePropertyChange(SET_TOP_LEFT_CORNER, null, null);
        }
    }

    public final Point2D getTopLeftCorner() {
        return new Point2D.Double(this.xCorner, this.yCorner);
    }

    public final int getImageWidth() {
        return this.width;
    }

    public final int getImageHeight() {
        return this.height;
    }

    private final ImageIcon fetchImageIcon() {
        if (this.imageFileName != null) {
            return new ImageIcon(this.imageFileName);
        }
        if (this.imageURL != null) {
            return new ImageIcon(this.imageURL);
        }
        return null;
    }

    private final Image fetchImage() {
        ImageIcon imageicon = this.fetchImageIcon();
        if (imageicon == null) {
            return null;
        }
        return imageicon.getImage();
    }

    private final void setImageSizeParameters() {
        Image image = this.fetchImage();
        if (image == null) {
            this.width = 0;
            this.height = 0;
        } else {
            JPanel panel = new JPanel();
            this.width = image.getWidth(panel);
            this.height = image.getHeight(panel);
        }
        this.firePropertyChange(SET_IMAGE, null, null);
    }
}

