/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePaintable
extends AbstractPaintable {
    public static final String SET_IMAGE = "set.image";
    public static final String SET_TOP_LEFT_CORNER = "set.top.left.corner";
    private Image image = null;
    private double xCorner = 0.0;
    private double yCorner = 0.0;
    private int width = 0;
    private int height = 0;

    public ImagePaintable() {
    }

    public ImagePaintable(Image image) {
        this.setImage(image);
    }

    public ImagePaintable(Image image, Point2D corner) {
        this.setImage(image);
        this.setTopLeftCorner(corner);
    }

    public ImagePaintable(Image image, double x, double y) {
        this.setImage(image);
        this.setTopLeftCorner(x, y);
    }

    public ImagePaintable(ImageIcon imageicon) {
        this.setImageByImageIcon(imageicon);
    }

    public ImagePaintable(ImageIcon imageicon, Point2D corner) {
        this.setImageByImageIcon(imageicon);
        this.setTopLeftCorner(corner);
    }

    public ImagePaintable(ImageIcon imageicon, double x, double y) {
        this.setImageByImageIcon(imageicon);
        this.setTopLeftCorner(x, y);
    }

    public ImagePaintable(String filename) {
        this.setImageByFileName(filename);
    }

    public ImagePaintable(String filename, Point2D corner) {
        this.setImageByFileName(filename);
        this.setTopLeftCorner(corner);
    }

    public ImagePaintable(String filename, double x, double y) {
        this.setImageByFileName(filename);
        this.setTopLeftCorner(x, y);
    }

    public ImagePaintable(URL url) {
        this.setImageByURL(url);
    }

    public ImagePaintable(URL url, Point2D corner) {
        this.setImageByURL(url);
        this.setTopLeftCorner(corner);
    }

    public ImagePaintable(URL url, double x, double y) {
        this.setImageByURL(url);
        this.setTopLeftCorner(x, y);
    }

    public final void originalPaint(Graphics g) {
        if (this.image == null || g == null || !this.isVisible()) {
            return;
        }
        Graphics2D h = (Graphics2D)g.create();
        AffineTransform T = TransformFactory.translate(this.xCorner, this.yCorner);
        h.drawImage(this.image, T, null);
    }

    public final XRect getActualBounds2D() {
        if (this.image == null) {
            return null;
        }
        return new XRect(this.xCorner, this.yCorner, this.width, this.height);
    }

    public final boolean originalContains(double x, double y) {
        if (this.width <= 0 || this.height <= 0) {
            return false;
        }
        return this.possiblyContains(x, y);
    }

    public final void setImage(Image image) {
        if (image == this.image) {
            return;
        }
        this.removeAndAddForwardingListener(this.image, image);
        this.image = image;
        this.setImageSizeParameters();
    }

    public final void setImageByImageIcon(ImageIcon imageicon) {
        if (imageicon == null) {
            this.setImage(null);
        } else {
            this.setImage(imageicon.getImage());
        }
    }

    public final void setImageByFileName(String filename) {
        if (filename == null) {
            this.setImage(null);
        } else {
            this.setImageByImageIcon(new ImageIcon(filename));
        }
    }

    public final void setImageByURL(URL url) {
        if (url == null) {
            this.setImage(null);
        } else {
            this.setImageByImageIcon(new ImageIcon(url));
        }
    }

    public final Image getImage() {
        return this.image;
    }

    public final void setTopLeftCorner(Point2D corner) {
        if (corner == null) {
            return;
        }
        this.setTopLeftCorner(corner.getX(), corner.getY());
    }

    public final void setTopLeftCorner(double x, double y) {
        if (x != this.xCorner || y != this.yCorner) {
            this.xCorner = x;
            this.yCorner = y;
            this.firePropertyChange(SET_TOP_LEFT_CORNER, null, null);
        }
    }

    public final Point2D getTopLeftCorner() {
        return new Point2D.Double(this.xCorner, this.yCorner);
    }

    public final int getImageWidth() {
        return this.width;
    }

    public final int getImageHeight() {
        return this.height;
    }

    private final void setImageSizeParameters() {
        if (this.image == null) {
            this.width = 0;
            this.height = 0;
        } else {
            JPanel panel = new JPanel();
            this.width = this.image.getWidth(panel);
            this.height = this.image.getHeight(panel);
        }
        this.firePropertyChange(SET_IMAGE, null, null);
    }
}

