/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.DialogAction;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class GeneralDialog
extends JDialog
implements JPTConstants,
ConsoleAware {
    public static final String WINDOW_CLOSED = "Window Closed";
    protected Component component = null;
    protected ActionsPanel actionsPanel = new ActionsPanel();
    protected TablePanel contentPanel = null;
    protected DisplayPanel wrapperPanel = null;
    protected DialogAction windowClosingAction = null;
    protected Action windowOpenedAction = null;
    protected WindowActionAdapter windowActionAdapter = null;
    protected Frame parentFrame = null;
    protected Dialog parentDialog = null;
    protected String response = "";
    protected boolean cancelled = false;

    public GeneralDialog(Object displayObject) {
        this(displayObject, "", (Object[][])null, (Object)null, true, (Frame)null);
    }

    public GeneralDialog(Object displayObject, String title) {
        this(displayObject, title, (Object[][])null, (Object)null, true, (Frame)null);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData) {
        this(displayObject, title, actionData, (Object)null, true, (Frame)null);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, boolean modal) {
        this(displayObject, title, actionData, (Object)null, modal, (Frame)null);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, boolean modal, Frame parent) {
        this(displayObject, title, actionData, null, modal, parent);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, boolean modal, Dialog parent) {
        this(displayObject, title, actionData, null, modal, parent);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, Object defaultAction) {
        this(displayObject, title, actionData, defaultAction, true, (Frame)null);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, Object defaultAction, boolean modal) {
        this(displayObject, title, actionData, defaultAction, modal, (Frame)null);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, Object defaultAction, boolean modal, Frame parent) {
        super(parent, title == null ? "" : title, modal);
        this.parentFrame = parent;
        this.initializeGeneralDialog(displayObject, actionData, defaultAction);
    }

    public GeneralDialog(Object displayObject, String title, Object[][] actionData, Object defaultAction, boolean modal, Dialog parent) {
        super(parent, title == null ? "" : title, modal);
        this.parentDialog = parent;
        this.initializeGeneralDialog(displayObject, actionData, defaultAction);
    }

    public void setVisible(boolean makeVisible) {
        if (this.isVisible() == makeVisible) {
            return;
        }
        if (makeVisible) {
            this.pack();
            this.center();
            super.setVisible(true);
        } else {
            super.setVisible(false);
            this.dispose();
        }
    }

    public void center() {
        Rectangle bounds;
        int xCenter = 0;
        int yCenter = 0;
        if (this.parentFrame != null) {
            bounds = this.parentFrame.getBounds();
            xCenter = bounds.x + bounds.width / 2;
            yCenter = bounds.y + bounds.height / 2;
        } else if (this.parentDialog != null) {
            bounds = this.parentDialog.getBounds();
            xCenter = bounds.x + bounds.width / 2;
            yCenter = bounds.y + bounds.height / 2;
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            xCenter = dimension.width / 2;
            yCenter = dimension.height / 2;
        }
        int xSize = this.getWidth();
        int ySize = this.getHeight();
        this.setLocation(xCenter - xSize / 2, yCenter - ySize / 2);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.wrapperPanel.setBackground(c);
        this.contentPanel.setBackground(c);
        this.component.setBackground(c);
        this.actionsPanel.setBackground(c);
    }

    public void setDeepBackground(Color c) {
        super.setBackground(c);
        this.wrapperPanel.setDeepBackground(c);
    }

    public void setDeepBackground(Color c, Class type) {
        if (type == null) {
            return;
        }
        if (type.isInstance(this)) {
            super.setBackground(c);
        }
        this.wrapperPanel.setDeepBackground(c, type);
    }

    public Component getDialogContents() {
        return this.component;
    }

    public ActionsPanel getDialogActionsPanel() {
        return this.actionsPanel;
    }

    public Action[] getActions() {
        return this.getDialogActionsPanel().getActions();
    }

    public DialogAction[] getDialogActions() {
        Action[] actionList = this.getActions();
        int length = actionList.length;
        DialogAction[] dialogActionList = new DialogAction[length];
        int i = 0;
        while (i < length) {
            if (actionList[i] instanceof DialogAction) {
                dialogActionList[i] = (DialogAction)actionList[i];
            }
            ++i;
        }
        return dialogActionList;
    }

    public JButton addAction(DialogAction action) {
        return this.getDialogActionsPanel().addAction(action);
    }

    public JButton addAction(Action action, Object finish) {
        return this.addAction(new DialogAction(this, action, finish));
    }

    public JButton addAction(String name, Object finish) {
        return this.addAction(new DialogAction(this, name, finish));
    }

    public JButton addAction(String name, Icon icon, Object finish) {
        return this.addAction(new DialogAction(this, name, icon, finish));
    }

    public void setDefaultButton(JButton button) {
        this.getDialogActionsPanel().setDefaultButton(button);
    }

    public void setDefaultButton(Action action) {
        this.getDialogActionsPanel().setDefaultButton(action);
    }

    public void setDefaultButton(String name) {
        this.getDialogActionsPanel().setDefaultButton(name);
    }

    public Action getWindowOpenedAction() {
        return this.windowOpenedAction;
    }

    public void setWindowOpenedAction(Action action) {
        if (this.windowOpenedAction != null) {
            this.windowActionAdapter.removeWindowOpenedAction(this.windowOpenedAction);
        }
        this.windowOpenedAction = action;
        if (this.windowOpenedAction != null) {
            this.windowActionAdapter.addWindowOpenedAction(this.windowOpenedAction);
        }
    }

    public DialogAction getWindowClosingAction() {
        return this.windowClosingAction;
    }

    public DialogAction getDefaultWindowClosingAction() {
        return new DialogAction(this, WINDOW_CLOSED, DialogAction.AUTO_CLOSE);
    }

    public void setWindowClosingAction(DialogAction action) {
        if (this.windowClosingAction != null) {
            this.windowActionAdapter.removeWindowClosingAction(this.windowClosingAction);
        }
        this.windowClosingAction = action != null ? action : this.getDefaultWindowClosingAction();
        this.windowActionAdapter.addWindowClosingAction(this.windowClosingAction);
    }

    public void setWindowClosingAction(Action action, Object finish) {
        this.setWindowClosingAction(new DialogAction(this, action, finish));
    }

    public void setWindowClosingAction(String name, Object finish) {
        this.setWindowClosingAction(new DialogAction(this, name, finish));
    }

    public WindowActionAdapter getWindowActionAdapter() {
        return this.windowActionAdapter;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public static GeneralDialog makeOneButtonDialog(Object displayObject, String title, Action action) {
        GeneralDialog dialog = new GeneralDialog(displayObject, title, (Object[][])new Object[][]{{action}}, action);
        dialog.setWindowClosingAction(action, DialogAction.AUTO_CLOSE);
        return dialog;
    }

    public static String showOneButtonDialog(Object displayObject, String title, Action action) {
        GeneralDialog dialog = GeneralDialog.makeOneButtonDialog(displayObject, title, action);
        dialog.setVisible(true);
        return dialog.getResponse();
    }

    public static GeneralDialog makeOneButtonDialog(Object displayObject, String title, String name) {
        return GeneralDialog.makeOneButtonDialog(displayObject, title, DialogAction.makeTrivialAction(name));
    }

    public static String showOneButtonDialog(Object displayObject, String title, String name) {
        GeneralDialog dialog = GeneralDialog.makeOneButtonDialog(displayObject, title, name);
        dialog.setVisible(true);
        return dialog.getResponse();
    }

    public static GeneralDialog makeOneButtonDialog(Object displayObject, String title, String name, Icon icon) {
        return GeneralDialog.makeOneButtonDialog(displayObject, title, DialogAction.makeTrivialAction(name, icon));
    }

    public static String showOneButtonDialog(Object displayObject, String title, String name, Icon icon) {
        GeneralDialog dialog = GeneralDialog.makeOneButtonDialog(displayObject, title, name, icon);
        dialog.setVisible(true);
        return dialog.getResponse();
    }

    public static GeneralDialog makeOKDialog(Object displayObject, String title) {
        return GeneralDialog.makeOneButtonDialog(displayObject, title, "OK");
    }

    public static String showOKDialog(Object displayObject, String title) {
        GeneralDialog dialog = GeneralDialog.makeOKDialog(displayObject, title);
        dialog.setVisible(true);
        return dialog.getResponse();
    }

    public static GeneralDialog makeOKCancelDialog(Object displayObject, String title) {
        Action OK = DialogAction.makeTrivialAction("OK");
        Action Cancel = DialogAction.makeTrivialAction("Cancel");
        Object[][] actionData = new Object[][]{{OK}, {Cancel, DialogAction.SET_CANCEL}};
        GeneralDialog dialog = new GeneralDialog(displayObject, title, actionData, OK);
        dialog.setWindowClosingAction(Cancel, DialogAction.SET_CANCEL);
        return dialog;
    }

    public static String showOKCancelDialog(Object displayObject, String title) throws CancelledException {
        GeneralDialog dialog = GeneralDialog.makeOKCancelDialog(displayObject, title);
        dialog.setVisible(true);
        if (dialog.wasCancelled()) {
            throw new CancelledException();
        }
        return dialog.getResponse();
    }

    public static GeneralDialog makeYesNoCancelDialog(Object displayObject, String title) {
        Action Yes = DialogAction.makeTrivialAction("Yes");
        Action No = DialogAction.makeTrivialAction("No");
        Action Cancel = DialogAction.makeTrivialAction("Cancel");
        Object[][] actionData = new Object[][]{{Yes}, {No}, {Cancel, DialogAction.SET_CANCEL}};
        GeneralDialog dialog = new GeneralDialog(displayObject, title, actionData, Yes);
        dialog.setWindowClosingAction(Cancel, DialogAction.SET_CANCEL);
        return dialog;
    }

    public static String showYesNoCancelDialog(Object displayObject, String title) throws CancelledException {
        GeneralDialog dialog = GeneralDialog.makeYesNoCancelDialog(displayObject, title);
        dialog.setVisible(true);
        if (dialog.wasCancelled()) {
            throw new CancelledException();
        }
        return dialog.getResponse();
    }

    protected void initializeGeneralDialog(Object displayObject, Object[][] actionData, Object defaultAction) {
        this.component = this.makeComponent(displayObject);
        if (this.component == null) {
            this.component = new JPanel();
        }
        this.actionsPanel.addActions(DialogAction.makeDialogActions(this, actionData));
        this.createContentPane();
        if (defaultAction instanceof Action) {
            this.setDefaultButton((Action)defaultAction);
        } else if (defaultAction instanceof String) {
            this.setDefaultButton((String)defaultAction);
        }
        this.installWindowActionAdapter();
    }

    protected Component makeComponent(Object o) {
        return ComponentFactory.makeComponent(o);
    }

    protected void createContentPane() {
        this.contentPanel = new TablePanel(2, 1, 5, 5, 1);
        this.contentPanel.add(this.component);
        this.contentPanel.add(this.actionsPanel);
        this.wrapperPanel = new DisplayPanel(new CenterLayout());
        this.wrapperPanel.add(this.contentPanel);
        this.setContentPane(this.wrapperPanel);
    }

    protected void installWindowActionAdapter() {
        this.setDefaultCloseOperation(0);
        this.windowActionAdapter = new WindowActionAdapter(this);
        this.setWindowClosingAction(null);
    }

    protected void setResponseAndClose(String userResponse) {
        this.response = userResponse != null ? userResponse : "";
        this.closeDialog();
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    protected void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

