/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.BasePane;
import edu.neu.ccs.gui.BooleanView;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.MultiColorView;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PlotTool;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SimpleFunctionBuilder;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TextPaintable;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JTabbedPane;

public class FunctionsPlotter
extends BasePane {
    protected int SMALLGAP = this.getGap();
    protected int LARGEGAP = 2 * this.SMALLGAP;
    protected int EXTRAGAP = 20;
    protected int BORDER = 4;
    protected int VALUEWIDTH = this.getSmallFieldWidth();
    protected int NAMESWIDTH = this.getMediumFieldWidth();
    protected int PLOTSIZE = 480;
    protected int PLOTINSET = 10;
    protected int WINDOWSIZE = this.PLOTSIZE + 2 * this.PLOTINSET;
    protected int PIXELGAP = 1;
    protected int MAXWIDTH = 800;
    protected TextFieldView functionNames = new TextFieldView(this.fieldFont, this.NAMESWIDTH);
    protected TextFieldView xMinimum = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected TextFieldView xMaximum = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected TextFieldView xSpacing = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected TextFieldView yMinimum = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected TextFieldView yMaximum = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected TextFieldView ySpacing = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected Annotation functionNamesLabel = new Annotation("Names of Functions to Plot", this.labelFont);
    protected Annotation xMinimumLabel = new Annotation("Minimum x", this.labelFont);
    protected Annotation xMaximumLabel = new Annotation("Maximum x", this.labelFont);
    protected Annotation xSpacingLabel = new Annotation("x Grid Spacing", this.labelFont);
    protected Annotation yMinimumLabel = new Annotation("Minimum y", this.labelFont);
    protected Annotation yMaximumLabel = new Annotation("Maximum y", this.labelFont);
    protected Annotation ySpacingLabel = new Annotation("y Grid Spacing", this.labelFont);
    protected SimpleAction yScalingAction = new SimpleAction(){

        public void perform() {
            FunctionsPlotter.this.yScalingMethod();
        }
    };
    protected BooleanView yScalingCheckBox = new BooleanView("Compute y Scaling Automatically", this.yScalingAction, true);
    protected SimpleAction xSpacingAction = new SimpleAction(){

        public void perform() {
            FunctionsPlotter.this.xSpacingMethod();
        }
    };
    protected BooleanView xSpacingCheckBox = new BooleanView("Compute x Grid Spacing Automatically", this.xSpacingAction, true);
    protected SimpleAction ySpacingAction = new SimpleAction(){

        public void perform() {
            FunctionsPlotter.this.ySpacingMethod();
        }
    };
    protected BooleanView ySpacingCheckBox = new BooleanView("Compute y Grid Spacing Automatically", this.ySpacingAction, true);
    protected Object[][] xStuff = new Object[][]{{this.xMinimumLabel, this.xMinimum}, {this.xMaximumLabel, this.xMaximum}};
    protected TablePanel xPanel = new TablePanel(this.xStuff, this.SMALLGAP, this.SMALLGAP, 0);
    protected Object[][] yStuff = new Object[][]{{this.yMinimumLabel, this.yMinimum}, {this.yMaximumLabel, this.yMaximum}};
    protected TablePanel yPanel = new TablePanel(this.yStuff, this.SMALLGAP, this.SMALLGAP, 0);
    protected Object[] xSpacingStuff = new Object[]{this.xSpacingLabel, this.xSpacing};
    protected HTable xSpacingPanel = new HTable(this.xSpacingStuff, this.SMALLGAP, this.SMALLGAP, 0);
    protected Object[] ySpacingStuff = new Object[]{this.ySpacingLabel, this.ySpacing};
    protected HTable ySpacingPanel = new HTable(this.ySpacingStuff, this.SMALLGAP, this.SMALLGAP, 0);
    protected Object[] parameterStuff = new Object[]{this.functionNamesLabel, this.functionNames, this.xPanel, this.yScalingCheckBox, this.yPanel, this.xSpacingCheckBox, this.xSpacingPanel, this.ySpacingCheckBox, this.ySpacingPanel};
    protected VTable parameterPanel = new VTable(this.parameterStuff, this.SMALLGAP, this.SMALLGAP, 7);
    protected Color[] colors = new Color[]{Colors.red, Colors.blue, Colors.lime, Colors.orange, Colors.skyblue, Colors.tan};
    protected String[] labels = new String[]{"Function 1", "Function 2", "Function 3", "Function 4", "Function 5", "Function 6"};
    protected MultiColorView multiColorView = new MultiColorView(this.colors, this.labels);
    protected SimpleAction plotAction = new SimpleAction("Plot Functions"){

        public void perform() {
            FunctionsPlotter.this.plotMethod();
        }
    };
    protected JButton plotButton = new JButton(this.plotAction);
    protected SimpleAction dataAction = new SimpleAction("Show Plot Data Table"){

        public void perform() {
            FunctionsPlotter.this.showDataTable();
        }
    };
    protected JButton dataButton = new JButton(this.dataAction);
    protected SimpleAction clearCoordinatesAction = new SimpleAction("Clear Coordinates in Plot Pane"){

        public void perform() {
            FunctionsPlotter.this.clearCoordinates();
        }
    };
    protected JButton clearCoordinatesButton = new JButton(this.clearCoordinatesAction);
    protected Object[] controlStuff = new Object[]{this.parameterPanel, this.multiColorView, this.plotButton, this.dataButton};
    protected VTable controlPanel = new VTable(this.controlStuff, this.LARGEGAP, this.LARGEGAP, 0);
    protected BufferedPanel window = new BufferedPanel(this.WINDOWSIZE, this.WINDOWSIZE);
    protected MouseAction motionAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent event) {
            FunctionsPlotter.this.motionMethod(event);
        }
    };
    protected MouseAction pressedAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent event) {
            FunctionsPlotter.this.pressedMethod(event);
        }
    };
    protected MouseAction exitedAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent event) {
            FunctionsPlotter.this.clearMouseXY();
        }
    };
    protected TextFieldView xMouse = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected TextFieldView yMouse = new TextFieldView(this.fieldFont, this.VALUEWIDTH);
    protected Annotation xMouseLabel = new Annotation("x", this.labelFont);
    protected Annotation yMouseLabel = new Annotation("y", this.labelFont);
    protected Object[] coordinatesStuff = new Object[]{this.xMouseLabel, this.xMouse, this.yMouseLabel, this.yMouse};
    protected HTable coordinatesPanel = new HTable(this.coordinatesStuff, this.SMALLGAP, this.SMALLGAP, 0);
    protected Object[] graphicsStuff = new Object[]{this.window, this.coordinatesPanel, this.clearCoordinatesButton};
    protected VTable graphicsPanel = new VTable(this.graphicsStuff, this.LARGEGAP, this.LARGEGAP, 0);
    protected Object[] plotPaneStuff = new Object[]{this.controlPanel, this.graphicsPanel};
    protected HTable plotPanePanel = new HTable(this.plotPaneStuff, this.LARGEGAP, this.LARGEGAP, 1);
    protected SimpleFunctionBuilder builder = new SimpleFunctionBuilder();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected BaseParser parser = ParserUtilities.getDefaultParser();
    protected DecimalFormat xFormat = null;
    protected DecimalFormat yFormat = null;
    protected boolean hasPlot = false;
    protected PlotTool plottool = new PlotTool();
    protected Rectangle2D world = null;
    protected Rectangle2D image = new XRect(0.0, 0.0, this.WINDOWSIZE, this.WINDOWSIZE);
    protected Stroke stroke = new BasicStroke(2.0f);
    protected Point2D[][] data = null;
    protected String names = null;
    protected double xmin = 0.0;
    protected double xmax = 0.0;
    protected double ymin = 0.0;
    protected double ymax = 0.0;
    protected double xgrid = 0.0;
    protected double ygrid = 0.0;

    public FunctionsPlotter() {
        this.initializeFunctionsPlotter();
        this.addObject(this.tabbedPane);
    }

    protected void initializeFunctionsPlotter() {
        this.yScalingCheckBox.setFont(this.labelFont);
        this.yScalingMethod();
        this.xSpacingCheckBox.setFont(this.labelFont);
        this.xSpacingMethod();
        this.ySpacingCheckBox.setFont(this.labelFont);
        this.ySpacingMethod();
        this.parameterPanel.emptyBorder(this.BORDER);
        this.parameterPanel.titleBorder("Function Plot Parameters", this.labelFont, Color.black);
        this.multiColorView.emptyBorder(this.BORDER);
        this.multiColorView.titleBorder("Function Plot Colors", this.labelFont, Color.black);
        this.window.emptyBorder(this.BORDER);
        this.window.titleBorder("Function Plot Pane", this.labelFont, Color.black);
        this.coordinatesPanel.emptyBorder(this.BORDER);
        this.coordinatesPanel.titleBorder("Function Plot Coordinates", this.labelFont, Color.black);
        this.plotButton.setFont(this.buttonFont);
        this.plotButton.setBackground(Colors.yellow);
        this.dataButton.setFont(this.buttonFont);
        this.dataButton.setBackground(Colors.skyblue);
        this.clearCoordinatesButton.setFont(this.buttonFont);
        this.clearCoordinatesButton.setBackground(Colors.lime);
        this.tabbedPane.setFont(this.labelFont);
        this.tabbedPane.addTab("Function Plot", this.plotPanePanel);
        this.tabbedPane.addTab("Function Definition", this.builder);
        MouseActionAdapter adapter = this.window.getMouseActionAdapter();
        adapter.addMouseMovedAction(this.motionAction);
        adapter.addMouseDraggedAction(this.motionAction);
        adapter.addMousePressedAction(this.pressedAction);
        adapter.addMouseExitedAction(this.exitedAction);
    }

    protected void yScalingMethod() {
        boolean manualyscale = !this.yScalingCheckBox.getBooleanValue();
        this.yMinimum.setEnabled(manualyscale);
        this.yMaximum.setEnabled(manualyscale);
    }

    protected void xSpacingMethod() {
        boolean manualxgrid = !this.xSpacingCheckBox.getBooleanValue();
        this.xSpacing.setEnabled(manualxgrid);
    }

    protected void ySpacingMethod() {
        boolean manualygrid = !this.ySpacingCheckBox.getBooleanValue();
        this.ySpacing.setEnabled(manualygrid);
    }

    protected void plotMethod() {
        this.hasPlot = false;
        this.window.clearPanelAndSequence();
        this.clearMouseXY();
        this.names = this.functionNames.getViewState();
        boolean autoyscale = this.yScalingCheckBox.getBooleanValue();
        boolean autoxgrid = this.xSpacingCheckBox.getBooleanValue();
        boolean autoygrid = this.ySpacingCheckBox.getBooleanValue();
        this.xmin = 0.0;
        this.xmax = 0.0;
        this.ymin = 0.0;
        this.ymax = 0.0;
        this.xgrid = 0.0;
        this.ygrid = 0.0;
        try {
            this.xmin = this.xMinimum.requestDouble();
            this.xmax = this.xMaximum.requestDouble();
            if (this.xmin == this.xmax) {
                this.PlotLimitError('x');
                return;
            }
            if (!autoyscale) {
                this.ymin = this.yMinimum.requestDouble();
                this.ymax = this.yMaximum.requestDouble();
                if (this.ymin == this.ymax) {
                    this.PlotLimitError('y');
                    return;
                }
            }
            if (!autoxgrid) {
                this.xgrid = this.xSpacing.requestDouble();
                if (this.xgrid <= 0.0) {
                    this.GridSpacingError('x');
                    return;
                }
            }
            if (!autoygrid) {
                this.ygrid = this.ySpacing.requestDouble();
                if (this.ygrid <= 0.0) {
                    this.GridSpacingError('y');
                    return;
                }
            }
        }
        catch (CancelledException cancelled) {
            return;
        }
        this.data = null;
        int steps = this.PLOTSIZE / this.PIXELGAP;
        try {
            this.data = this.parser.makeTable(this.names, this.xmin, this.xmax, steps);
        }
        catch (ParseException exception) {
            this.FunctionError(exception.getMessage());
            return;
        }
        if (this.data == null || this.data.length == 0) {
            this.FunctionError("No function names");
            return;
        }
        if (autoyscale) {
            this.world = PlotTool.makeBoundsRectangle2D(this.data);
            this.ymin = this.world.getMinY();
            this.ymax = this.world.getMaxY();
            if (this.ymin == this.ymax) {
                this.PlotLimitError('y');
                return;
            }
        } else {
            XRect rect = new XRect();
            rect.setX1Y1X2Y2(this.xmin, this.ymin, this.xmax, this.ymax);
            this.world = rect;
        }
        this.setDecimalFormats();
        this.plotData();
    }

    protected void plotData() {
        if (this.data == null) {
            return;
        }
        Graphics2D g = this.window.getBufferGraphics();
        this.plottool.setWorldBounds(this.world);
        this.plottool.setImageBounds(this.image);
        this.plottool.setInset(this.PLOTINSET);
        Point2D grid = this.plottool.autoSpacing(20);
        if (this.xgrid <= 0.0) {
            this.xgrid = grid.getX();
        }
        if (this.ygrid <= 0.0) {
            this.ygrid = grid.getY();
        }
        Color gridcolor = PlotTool.DEFAULT_GRID_COLOR;
        this.plottool.plotGridLines(g, gridcolor, this.xgrid, this.ygrid);
        this.plottool.autoAxes(g);
        Paint[] plotcolors = this.multiColorView.getColors();
        this.plottool.plotData(g, this.data, plotcolors, this.stroke);
        this.window.repaint();
        this.hasPlot = true;
    }

    protected void showDataTable() {
        if (!this.hasPlot) {
            return;
        }
        PaintableComponent dataTable = this.makeDataTable();
        Dimension dimension = dataTable.getPreferredSize();
        int w = dimension.width;
        if (w > this.MAXWIDTH) {
            w = this.MAXWIDTH;
        }
        int h = 600;
        int hsbPolicy = 30;
        int vsbPolicy = 22;
        JPTScrollPane scrollpane = new JPTScrollPane(dataTable, vsbPolicy, hsbPolicy);
        scrollpane.boundViewportPreferredSize(w, h);
        scrollpane.OKDialog("Plot Data");
    }

    protected PaintableComponent makeDataTable() {
        XRect bounds;
        int col;
        if (!this.hasPlot) {
            return null;
        }
        String[] list = Strings.splitCommaList(this.names);
        int fcns = list.length;
        int cols = fcns + 1;
        int steps = this.PLOTSIZE / this.PIXELGAP;
        int rows = steps + 3;
        String[][] string = new String[rows][cols];
        int row = 0;
        string[row][0] = "x";
        int fcn = 0;
        while (fcn < fcns) {
            col = fcn + 1;
            string[row][col] = list[fcn];
            ++fcn;
        }
        int step = 0;
        while (step <= steps) {
            row = step + 1;
            string[row][0] = this.formatDouble(this.data[0][step].getX(), this.xFormat);
            int fcn2 = 0;
            while (fcn2 < fcns) {
                col = fcn2 + 1;
                string[row][col] = this.formatDouble(this.data[fcn2][step].getY(), this.yFormat);
                ++fcn2;
            }
            ++step;
        }
        row = steps + 2;
        string[row][0] = "x";
        fcn = 0;
        while (fcn < fcns) {
            col = fcn + 1;
            string[row][col] = list[fcn];
            ++fcn;
        }
        int[] maxlength = new int[cols];
        col = 0;
        while (col < cols) {
            row = 0;
            while (row <= steps + 2) {
                int length = string[row][col].length();
                if (length > maxlength[col]) {
                    maxlength[col] = length;
                }
                ++row;
            }
            ++col;
        }
        Font font = this.fieldFont;
        int[] textwidth = new int[cols];
        int textheight = 0;
        col = 0;
        while (col < cols) {
            String test = "";
            int i = 0;
            while (i < maxlength[col]) {
                test = String.valueOf(test) + "0";
                ++i;
            }
            TextPaintable paintable = new TextPaintable(test, font);
            bounds = paintable.getLooseBounds();
            textwidth[col] = 1 + (int)bounds.getWidth();
            if (col == 0) {
                textheight = 1 + (int)bounds.getHeight();
            }
            ++col;
        }
        int[] rightside = new int[cols];
        rightside[0] = textwidth[0] + this.SMALLGAP;
        col = 1;
        while (col < cols) {
            rightside[col] = rightside[col - 1] + textwidth[col] + this.EXTRAGAP;
            ++col;
        }
        int[] middle = new int[cols];
        col = 0;
        while (col < cols) {
            middle[col] = rightside[col] - textwidth[col] / 2;
            ++col;
        }
        int size = rows * cols;
        int index = 0;
        Object[] paintables = new Paintable[size];
        TextAnchor.Locator MID = TextAnchor.CENTER_ASCENTLINE;
        TextAnchor.Locator RHS = TextAnchor.RIGHT_ASCENTLINE;
        row = 0;
        while (row < rows) {
            int[] position;
            TextAnchor.Locator locator;
            int anchorY = this.SMALLGAP + row * textheight;
            if (row == 0 || row == steps + 2) {
                locator = MID;
                position = middle;
            } else {
                locator = RHS;
                position = rightside;
            }
            col = 0;
            while (col < cols) {
                int anchorX = position[col];
                paintables[index++] = new TextPaintable(string[row][col], font, locator, (float)anchorX, (float)anchorY);
                ++col;
            }
            ++row;
        }
        PaintableSequence sequence = new PaintableSequence(paintables);
        int w = rightside[cols - 1] + this.SMALLGAP;
        int h = rows * textheight + 2 * this.SMALLGAP;
        bounds = new XRect(0.0, 0.0, w, h);
        sequence.setDefaultBounds2D(bounds);
        return new PaintableComponent(sequence);
    }

    protected void setDecimalFormats() {
        double xpixel = Math.abs(this.xmax - this.xmin) / (double)this.PLOTSIZE;
        double ypixel = Math.abs(this.ymax - this.ymin) / (double)this.PLOTSIZE;
        this.xFormat = new DecimalFormat(this.makeFormatString(xpixel));
        this.yFormat = new DecimalFormat(this.makeFormatString(ypixel));
    }

    protected String makeFormatString(double pixel) {
        if ((pixel = Math.abs(pixel)) == 0.0 || pixel >= 1.0) {
            return "0";
        }
        String s = "0.";
        while (pixel < 1.0) {
            pixel *= 10.0;
            s = String.valueOf(s) + "0";
        }
        return s;
    }

    protected String formatDouble(double z, DecimalFormat zFormat) {
        if (Double.isNaN(z)) {
            return "NaN";
        }
        if (z == Double.POSITIVE_INFINITY) {
            return "+Infinity";
        }
        if (z == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        return zFormat.format(z);
    }

    protected void PlotLimitError(char c) {
        GeneralDialog.showOKDialog("Minumum and maximum " + c + " must be distinct", "Plot Limit Error");
    }

    protected void GridSpacingError(char c) {
        GeneralDialog.showOKDialog(String.valueOf(c) + " Grid Spacing must be positive", "Grid Spacing Error");
    }

    protected void FunctionError(String message) {
        GeneralDialog.showOKDialog(message, "Function Error");
    }

    protected void motionMethod(MouseEvent event) {
        if (this.hasPlot) {
            int x = event.getX();
            int y = event.getY();
            double xx = this.plottool.inverseXScale(x);
            double yy = this.plottool.inverseYScale(y);
            this.xMouse.setViewState(this.xFormat.format(xx));
            this.yMouse.setViewState(this.yFormat.format(yy));
        }
    }

    protected void pressedMethod(MouseEvent event) {
        if (this.hasPlot) {
            int x = event.getX();
            int y = event.getY();
            double xx = this.plottool.inverseXScale(x);
            double yy = this.plottool.inverseYScale(y);
            String xs = this.xFormat.format(xx);
            String ys = this.yFormat.format(yy);
            String s = "(" + xs + "," + ys + ")";
            TextPaintable tp = new TextPaintable(s, this.fieldFont, TextAnchor.CENTER_BASELINE, (float)x, (float)y);
            XRect bounds = tp.getBounds2D();
            double x1 = bounds.getMinX();
            double y1 = bounds.getMinY();
            double x2 = bounds.getMaxX();
            double y2 = bounds.getMaxY();
            if (x1 < 0.0) {
                tp.move(-x1, 0.0);
            }
            if (y1 < 0.0) {
                tp.move(0.0, -y1);
            }
            if (x2 > (double)this.WINDOWSIZE) {
                tp.move((double)this.WINDOWSIZE - x2, 0.0);
            }
            if (y2 > (double)this.WINDOWSIZE) {
                tp.move(0.0, (double)this.WINDOWSIZE - y2);
            }
            this.window.appendPaintable(tp);
            this.window.repaint();
        }
    }

    protected void clearMouseXY() {
        this.xMouse.setViewState("");
        this.yMouse.setViewState("");
    }

    protected void clearCoordinates() {
        this.window.clearSequence();
        this.window.repaint();
    }

    public static void main(String[] args) {
        new FunctionsPlotter().frame("Functions Plotter");
    }
}

