/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BooleanView;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Dropdown;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TextPaintable;
import edu.neu.ccs.gui.VTable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;

public class FontSampler
extends DisplayPanel {
    protected int minimum = 8;
    protected int gap = 12;
    protected int deltaw = 40;
    protected int deltah = 60;
    protected int width = 17 * this.deltaw;
    protected int height = 7 * this.deltah;
    protected BufferedPanel window = new BufferedPanel(this.width, this.height);
    protected GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    protected String[] familyList = this.ge.getAvailableFontFamilyNames();
    protected SimpleAction showFont = new SimpleAction("Show Font"){

        public void perform() {
            FontSampler.this.showFont();
        }
    };
    protected Dropdown fontDropdown = new Dropdown(this.familyList);
    protected TextFieldView fontSizeTFV = new TextFieldView("24", 60);
    protected BooleanView boldBox = new BooleanView("Bold", this.showFont, false);
    protected BooleanView italicBox = new BooleanView("Italic", this.showFont, false);
    protected Object[] fontStuff = new Object[]{"Font Name", this.fontDropdown};
    protected HTable fontPanel = new HTable(this.fontStuff, this.gap, this.gap, 0);
    protected Object[] paramsStuff = new Object[]{"Font Size", this.fontSizeTFV, this.boldBox, this.italicBox};
    protected HTable paramsTable = new HTable(this.paramsStuff, this.gap, this.gap, 0);
    protected Object[] mainStuff = new Object[]{this.window, this.fontPanel, this.paramsTable};
    protected VTable mainPanel = new VTable(this.mainStuff, this.gap, this.gap, 0);

    public FontSampler() {
        this.fontDropdown.setMaximumRowCount(16);
        this.fontDropdown.addActionListener(this.showFont);
        this.fontSizeTFV.addActionListener(this.showFont);
        this.window.lineBorder(Color.black, 2);
        this.window.emptyBorder(4);
        this.add(this.mainPanel);
        this.showFont();
    }

    protected void showFont() {
        this.window.clearPanel();
        Graphics2D graphics = this.window.getBufferGraphics();
        Font font = this.getCurrentFont();
        TextPaintable paintable = new TextPaintable(null, font, null, null, TextAnchor.CENTER_BASELINE, 0.0f, 0.0f);
        int row = 2;
        while (row < 8) {
            int y = this.deltah * (row - 1);
            int next = 16 * row;
            int col = 0;
            while (col <= 15) {
                int x = this.deltaw * (col + 1);
                int code = next + col;
                if (code == 127) break;
                String s = "" + (char)code;
                paintable.setString(s);
                paintable.setAnchorPosition(x, y);
                paintable.paint(graphics);
                ++col;
            }
            ++row;
        }
        this.window.repaint();
    }

    public Font getCurrentFont() {
        String name = this.fontDropdown.getViewState();
        int size = this.fontSizeTFV.demandInt();
        if (size < this.minimum) {
            size = this.minimum;
            this.fontSizeTFV.setViewState("" + size);
        }
        int style = (this.boldBox.getBooleanValue() ? 1 : 0) | (this.italicBox.getBooleanValue() ? 2 : 0);
        return new Font(name, style, size);
    }

    public static void main(String[] args) {
        new FontSampler().frame("Font Sampler", 1);
    }
}

