/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XString;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileView
extends DisplayPanel
implements TypedView,
Fragile {
    public static final String LAST_PATH = "last.path";
    public static final String DEFAULT_FILENAME = "";
    public static final String DEFAULT_BUTTON_LABEL = "Browse";
    public static final int DEFAULT_ALIGNMENT = 4;
    protected static final FileFilter ALL_FILES_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }
    };
    protected static String lastPath = null;
    protected int align = 4;
    protected TextFieldView field = null;
    protected JButton browse = null;
    protected InputProperties properties = new InputProperties();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FileView() {
        this(DEFAULT_FILENAME, 4);
    }

    public FileView(String name) {
        this(name, 4);
    }

    public FileView(String name, int align) {
        try {
            lastPath = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.field = new TextFieldView(name);
        this.field.setPreferredWidth(100);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.field, "Center");
        this.setAlignment(align);
        this.addMalformedDataListener(this);
    }

    public Stringable demandObject() {
        return new XString(this.getViewState());
    }

    public Stringable requestObject() throws CancelledException {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties p) {
        if (p == null) {
            p = InputProperties.BASE_PROPERTIES;
        }
        InputProperties oldProperties = this.getInputProperties();
        this.properties = p;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(oldProperties)) {
            this.firePropertyChange("input.properties", oldProperties, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void setViewState(String data) {
        this.field.setViewState(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.field.getViewState();
    }

    public void setDefaultViewState(String data) {
        this.field.setDefaultViewState(data);
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState(String data) {
        return this.field.getDefaultViewState();
    }

    public void reset() {
        this.field.reset();
    }

    public void setEnabled(boolean isEnabled) {
        this.field.setEnabled(isEnabled);
        this.browse.setEnabled(isEnabled);
        super.setEnabled(isEnabled);
    }

    public void addMalformedDataListener(MalformedDataListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.neu.ccs.gui.MalformedDataListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeMalformedDataListener(MalformedDataListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.neu.ccs.gui.MalformedDataListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public File demandExistingFile() {
        return new File(this.demandExistingFilename());
    }

    public File demandFile() {
        return new File(this.demandFilename());
    }

    public String demandExistingFilename() {
        try {
            return this.performRequest(false, true);
        }
        catch (CancelledException ex) {
            return null;
        }
    }

    public String demandFilename() {
        try {
            return this.performRequest(true, true);
        }
        catch (CancelledException ex) {
            return null;
        }
    }

    public File requestExistingFile() throws CancelledException {
        return new File(this.requestExistingFilename());
    }

    public File requestFile() throws CancelledException {
        return new File(this.requestFilename());
    }

    public String requestExistingFilename() throws CancelledException {
        return this.performRequest(false, false);
    }

    public String requestFilename() throws CancelledException {
        return this.performRequest(true, false);
    }

    public void setAlignment(int alignment) {
        int oldAlignment = this.getAlignment();
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = alignment;
                break;
            }
            case -1: {
                this.align = 4;
                break;
            }
            default: {
                return;
            }
        }
        if (this.browse == null) {
            this.browse = new JButton(DEFAULT_BUTTON_LABEL);
            this.browse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fc = new JFileChooser(FileView.this.getLastPath());
                    fc.setFileFilter(ALL_FILES_FILTER);
                    if (fc.showOpenDialog(null) == 0) {
                        FileView.this.setViewState(fc.getSelectedFile().getPath());
                        FileView.this.setLastPath(fc.getSelectedFile().getPath());
                    }
                }
            });
        } else {
            this.remove(this.browse);
        }
        this.add((Component)this.browse, JPTUtilities.getBorderLayoutLocation(alignment));
        if (this.getAlignment() != oldAlignment) {
            this.firePropertyChange("alignment", oldAlignment, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setLastPath(String path) {
        String oldPath = this.getLastPath();
        lastPath = path;
        if (this.getLastPath() != null && !this.getLastPath().equals(oldPath)) {
            this.firePropertyChange(LAST_PATH, oldPath, this.getLastPath());
        }
    }

    public String getLastPath() {
        return lastPath;
    }

    protected JButton getBrowseButton() {
        return this.browse;
    }

    protected void fireDataMalformed(MalformedDataEvent evt) {
        Object[] obj = this.listenerList.getListenerList();
        int i = obj.length - 2;
        while (i >= 0) {
            if (obj[i] != null) {
                Object object = obj[i];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("edu.neu.ccs.gui.MalformedDataListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object.equals(clazz)) {
                    MalformedDataListener m = (MalformedDataListener)obj[i];
                    m.dataMalformed(evt);
                }
            }
            i -= 2;
        }
    }

    protected String performRequest(boolean anyValid, boolean mandatory) throws CancelledException {
        boolean alert = false;
        File file = new File(this.field.getViewState());
        JFileChooser fc = null;
        while (!file.exists()) {
            int selection;
            try {
                if (anyValid && file.createNewFile()) {
                    file.delete();
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!alert) {
                alert = true;
                this.fireDataMalformed(new MalformedDataEvent(this, this.field.getViewState(), new ParseException("Path/filename is not valid.", -1)));
            }
            if (fc == null) {
                fc = new JFileChooser(file);
                fc.setMultiSelectionEnabled(false);
                fc.setFileFilter(ALL_FILES_FILTER);
            }
            if ((selection = fc.showDialog(this, "Select")) == 0) {
                file = fc.getSelectedFile();
                this.field.setViewState(file.getPath());
                this.setLastPath(file.getPath());
                continue;
            }
            if (selection == 1 && !mandatory) {
                if (alert) {
                    this.fireDataMalformed(new MalformedDataEvent((Object)this, null));
                }
                throw new CancelledException();
            }
            fc.setSelectedFile(file);
        }
        if (alert) {
            this.fireDataMalformed(new MalformedDataEvent((Object)this, this.field.getViewState()));
        }
        return this.field.getViewState();
    }

    public static class ExtensionFileFilter
    extends FileFilter
    implements Cloneable,
    Serializable {
        private String ext = null;
        private String extInLowerCase = null;
        private int extLength = 0;

        public ExtensionFileFilter(String extension) {
            this.ext = extension;
            if (this.ext != null) {
                this.extLength = this.ext.length();
                this.extInLowerCase = this.ext.toLowerCase();
            }
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (this.extLength == 0) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int offset = name.length() - this.extLength;
            if (offset < 0) {
                return false;
            }
            return name.regionMatches(true, offset, this.ext, 0, this.extLength);
        }

        public String getDescription() {
            if (this.ext == null) {
                return "All files: *.*";
            }
            return String.valueOf(this.ext) + " files: *." + this.extInLowerCase;
        }
    }
}

