/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XObject;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.InputDialog;
import edu.neu.ccs.gui.TypedView;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.JLabel;

public class ErrorDialog
extends InputDialog {
    protected Annotation errorMessage = null;
    protected String originalValue = null;
    protected StringableFilter filter = null;

    public ErrorDialog(Stringable modelObject, TypedView viewObject, StringableFilter filterObject, ParseException exception) {
        super(viewObject);
        if (modelObject == null || viewObject == null || exception == null) {
            throw new NullPointerException("Null parameter in constructor.");
        }
        this.model = modelObject;
        this.filter = filterObject;
        this.originalValue = this.view.getViewState();
        this.errorMessage = new Annotation(XObject.formatErrorMessage(exception, this.view.getViewState()));
        int size = new JLabel("0").getFont().getSize() + 2;
        this.errorMessage.setFont(new Font("monospaced", 1, size));
        this.getContentPane().add((Component)this.errorMessage, "North");
        this.pack();
        this.center();
    }

    protected void ok() {
        try {
            block6: {
                try {
                    this.model.fromStringData(this.view.getViewState());
                    if (this.filter == null) break block6;
                    try {
                        this.model = this.filter.filterStringable(this.model);
                    }
                    catch (FilterException ex) {
                        throw new ParseException(ex.getMessage(), -1);
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), -1);
                }
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (ParseException ex) {
            this.errorMessage.setText(XObject.formatErrorMessage(ex, this.view.getViewState()));
            this.pack();
            this.center();
        }
    }

    protected void reset() {
        this.view.setViewState(this.originalValue);
    }

    protected void cancel() {
        this.reset();
        super.cancel();
    }
}

