/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JComboBox;

public class Dropdown
extends JComboBox
implements Displayable,
JPTConstants {
    public static final String PREFERRED_WIDTH = "set.preferred.width";
    public static final int DEFAULT_WIDTH = 125;
    protected static final String DEFAULT_SELECTION = "";
    protected int preferredWidth = 125;
    protected int minimumWidth = 0;
    protected Vector itemList = null;
    protected String defaultViewState = "";

    public Dropdown() {
        this.initializeDropdown(null, DEFAULT_SELECTION, null, 0, false);
    }

    public Dropdown(int minWidth) {
        this.initializeDropdown(null, DEFAULT_SELECTION, null, minWidth, false);
    }

    public Dropdown(Font font) {
        this.initializeDropdown(null, DEFAULT_SELECTION, font, 0, false);
    }

    public Dropdown(Font font, int minWidth) {
        this.initializeDropdown(null, DEFAULT_SELECTION, font, minWidth, false);
    }

    public Dropdown(String[] items) {
        this.initializeDropdown(items, DEFAULT_SELECTION, null, 0, false);
    }

    public Dropdown(String[] items, int minWidth) {
        this.initializeDropdown(items, DEFAULT_SELECTION, null, minWidth, false);
    }

    public Dropdown(String[] items, Font font) {
        this.initializeDropdown(items, DEFAULT_SELECTION, font, 0, false);
    }

    public Dropdown(String[] items, Font font, int minWidth) {
        this.initializeDropdown(items, DEFAULT_SELECTION, font, minWidth, false);
    }

    public Dropdown(String[] items, String selection) {
        this.initializeDropdown(items, selection, null, 0, false);
    }

    public Dropdown(String[] items, String selection, int minWidth) {
        this.initializeDropdown(items, selection, null, minWidth, false);
    }

    public Dropdown(String[] items, String selection, Font font) {
        this.initializeDropdown(items, selection, font, 0, false);
    }

    public Dropdown(String[] items, String selection, Font font, int minWidth) {
        this.initializeDropdown(items, selection, font, minWidth, false);
    }

    public Dropdown(String[] items, String selection, boolean editable) {
        this.initializeDropdown(items, selection, null, 0, editable);
    }

    public Dropdown(String[] items, String selection, int minWidth, boolean editable) {
        this.initializeDropdown(items, selection, null, minWidth, editable);
    }

    public Dropdown(String[] items, String selection, Font font, boolean editable) {
        this.initializeDropdown(items, selection, font, 0, editable);
    }

    public Dropdown(String[] items, String selection, Font font, int minWidth, boolean editable) {
        this.initializeDropdown(items, selection, font, minWidth, editable);
    }

    protected void initializeDropdown(String[] items, String selection, Font font, int minWidth, boolean editable) {
        this.itemList = new Vector();
        this.setEditable(editable);
        if (font != null) {
            super.setFont(font);
        }
        if (items != null) {
            int length = items.length;
            int i = 0;
            while (i < length) {
                this.addItem(items[i]);
                ++i;
            }
        }
        this.setMinimumWidth(minWidth);
        this.autoSetPreferredWidth();
        this.setViewState(selection);
        this.setDefaultViewState(selection);
    }

    public void addItem(Object item) {
        if (item == null) {
            return;
        }
        if (!(item instanceof String)) {
            return;
        }
        this.itemList.add(item);
        super.addItem(item);
    }

    public void insertItemAt(Object item, int index) {
        if (item == null) {
            return;
        }
        if (!(item instanceof String)) {
            return;
        }
        this.itemList.add(index, item);
        super.insertItemAt(item, index);
    }

    public void removeItem(Object item) {
        if (item == null) {
            return;
        }
        if (!(item instanceof String)) {
            return;
        }
        this.itemList.remove(item);
        super.removeItem(item);
    }

    public void removeItemAt(int index) {
        this.itemList.remove(index);
        super.removeItemAt(index);
    }

    public void removeAllItems() {
        super.removeAllItems();
        this.itemList.clear();
    }

    public void addItems(String[] items) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            this.addItem(items[i]);
            ++i;
        }
        this.refresh();
    }

    public void setItems(String[] items) {
        this.removeAllItems();
        this.addItems(items);
    }

    public void removeItems(String[] items) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                this.removeItem(items[i]);
            }
            ++i;
        }
    }

    public String[] getItems() {
        String[] base = new String[]{};
        if (this.itemList == null || this.itemList.size() == 0) {
            return base;
        }
        return this.itemList.toArray(base);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int width = this.getPreferredWidth();
        if (width > 0) {
            dimension.width = width + dimension.height;
        }
        return dimension;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void autoSetPreferredWidth() {
        int minWidth = this.getMinimumWidth();
        int samWidth = TextFieldView.getWidthEstimate(this.getFont(), this.getItems());
        this.setPreferredWidth(minWidth, samWidth);
    }

    public void setMinimumWidth(int minWidth) {
        this.minimumWidth = minWidth;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setPreferredWidth(int width) {
        int oldWidth = this.getPreferredWidth();
        this.preferredWidth = width < 0 ? -1 : (width == 0 ? 125 : width);
        this.refreshComponent();
        this.firePropertyChange(PREFERRED_WIDTH, oldWidth, this.preferredWidth);
    }

    public void setPreferredWidth(int minWidth, String sample) {
        int samWidth = TextFieldView.getSampleWidth(this.getFont(), sample);
        this.setPreferredWidth(minWidth, samWidth);
    }

    public void setPreferredWidth(int minWidth, int samWidth) {
        this.setMinimumWidth(minWidth);
        if (samWidth <= 0) {
            this.setPreferredWidth(minWidth);
        } else {
            if (minWidth == 0) {
                minWidth = 125;
            }
            this.setPreferredWidth(Math.max(minWidth, samWidth));
        }
    }

    public void setFont(Font font) {
        if (this.itemList == null) {
            super.setFont(font);
            return;
        }
        if (font == null) {
            font = Dropdown.getDefaultFont();
        }
        String defaultViewState = this.getDefaultViewState();
        String[] items = this.getItems();
        String selection = this.getViewState();
        int minWidth = this.getMinimumWidth();
        boolean editable = this.isEditable();
        this.removeAllItems();
        this.initializeDropdown(items, selection, font, minWidth, editable);
        this.setDefaultViewState(defaultViewState);
        this.firePropertyChange("set.font", null, null);
    }

    public static Font getDefaultFont() {
        return new JComboBox().getFont();
    }

    public void setViewState(String data) {
        if (data == null) {
            return;
        }
        String olddata = this.getViewState();
        if (data.equals(olddata)) {
            return;
        }
        boolean madeChange = false;
        int i = 0;
        while (i < this.getItemCount()) {
            String s = this.getItemAt(i).toString();
            if (s != null && s.equals(data)) {
                this.setSelectedIndex(i);
                madeChange = true;
                break;
            }
            ++i;
        }
        if (!madeChange && this.isEditable()) {
            this.setSelectedItem(data);
            madeChange = true;
        }
        if (madeChange) {
            this.firePropertyChange("view.state", olddata, data);
        }
    }

    public String getViewState() {
        return (String)this.getSelectedItem();
    }

    public void setDefaultViewState(String data) {
        String oldDefaultViewState = this.defaultViewState;
        this.defaultViewState = data = data == null ? DEFAULT_SELECTION : data;
        if (!oldDefaultViewState.equals(this.defaultViewState)) {
            this.firePropertyChange("default.view.state", 0, 1);
        }
    }

    public String getDefaultViewState() {
        return this.defaultViewState;
    }

    public void reset() {
        this.setViewState(this.getDefaultViewState());
    }

    public void refresh() {
        this.autoSetPreferredWidth();
        this.refreshComponent();
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

