/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Strings;
import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.AlertListener;
import edu.neu.ccs.gui.Borders;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class DisplayPanel
extends JPanel
implements Displayable,
MalformedDataListener,
JPTConstants {
    public static final String CODEC = "codec";
    protected Color background = SystemColor.control;
    protected String codec = CodecUtilities.getDefaultCodec();

    public DisplayPanel() {
    }

    public DisplayPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public DisplayPanel(LayoutManager layout) {
        super(layout);
    }

    public DisplayPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public Displayable[] getDisplayables() {
        int count = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof Displayable) {
                ++count;
            }
            ++i;
        }
        Displayable[] array = new Displayable[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.getComponentCount()) {
            Component c = this.getComponent(i2);
            if (c instanceof Displayable) {
                array[count++] = (Displayable)((Object)c);
            }
            ++i2;
        }
        return array;
    }

    public void setViewState(String data) {
        if (data == null) {
            return;
        }
        this.setViewStates(Strings.decode(data));
    }

    public void setViewStates(String[] data) {
        if (data == null) {
            return;
        }
        Displayable[] array = this.getDisplayables();
        int count = Math.min(data.length, array.length);
        int i = 0;
        while (i < count) {
            array[i].setViewState(data[i]);
            ++i;
        }
        this.firePropertyChange("view.state", null, null);
    }

    public String getViewState() {
        return CodecUtilities.encode(this.getViewStates(), this.getCodec());
    }

    public String[] getViewStates() {
        Displayable[] array = this.getDisplayables();
        int length = array.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = array[i].getViewState();
            ++i;
        }
        return result;
    }

    public void setDefaultViewState(String data) {
        if (data == null) {
            return;
        }
        this.setDefaultViewStates(Strings.decode(data));
    }

    public void setDefaultViewStates(String[] data) {
        if (data == null) {
            return;
        }
        Displayable[] array = this.getDisplayables();
        int count = Math.min(data.length, array.length);
        int i = 0;
        while (i < count) {
            array[i].setDefaultViewState(data[i]);
            ++i;
        }
        this.firePropertyChange("default.view.state", null, null);
    }

    public String getDefaultViewState() {
        return CodecUtilities.encode(this.getDefaultViewStates(), this.getCodec());
    }

    public String[] getDefaultViewStates() {
        Displayable[] array = this.getDisplayables();
        int length = array.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = array[i].getDefaultViewState();
            ++i;
        }
        return result;
    }

    public void setEnabled(boolean isEnabled) {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(isEnabled);
            ++i;
        }
        super.setEnabled(isEnabled);
    }

    public void reset() {
        Displayable[] array = this.getDisplayables();
        int count = array.length;
        int i = 0;
        while (i < count) {
            array[i].reset();
            ++i;
        }
    }

    public void dataMalformed(MalformedDataEvent evt) {
        if (evt.isAlertOn()) {
            this.startAlert(evt);
        } else {
            this.endAlert(evt);
        }
    }

    public void startAlert(AlertEvent evt) {
        this.background = this.getBackground();
        this.setBackground(SystemColor.textHighlight);
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof AlertListener) {
                AlertListener a = (AlertListener)((Object)c);
                a.startAlert(evt);
            }
            ++i;
        }
    }

    public void endAlert(AlertEvent evt) {
        this.setBackground(this.background);
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof AlertListener) {
                AlertListener a = (AlertListener)((Object)c);
                a.endAlert(evt);
            }
            ++i;
        }
    }

    public Border addBorder(Border border) {
        Border current = this.getBorder();
        if (border == null) {
            return current;
        }
        if (current == null) {
            this.setBorder(border);
            return border;
        }
        CompoundBorder compound = BorderFactory.createCompoundBorder(border, current);
        this.setBorder(compound);
        return compound;
    }

    public Border removeBorder() {
        Border current = this.getBorder();
        this.setBorder(null);
        return current;
    }

    public void emptyBorder(int thickness) {
        this.emptyBorder(thickness, thickness, thickness, thickness);
    }

    public void emptyBorder(int vgap, int hgap) {
        this.emptyBorder(vgap, hgap, vgap, hgap);
    }

    public void emptyBorder(int top, int left, int bottom, int right) {
        this.addBorder(Borders.empty(top, left, bottom, right));
    }

    public void matteBorder(int thickness, Color color) {
        this.matteBorder(thickness, thickness, thickness, thickness, color);
    }

    public void matteBorder(int vgap, int hgap, Color color) {
        this.matteBorder(vgap, hgap, vgap, hgap, color);
    }

    public void matteBorder(int top, int left, int bottom, int right, Color color) {
        this.addBorder(Borders.matte(top, left, bottom, right, color));
    }

    public void matteBorder(int thickness, Icon tileicon) {
        this.matteBorder(thickness, thickness, thickness, thickness, tileicon);
    }

    public void matteBorder(int vgap, int hgap, Icon tileicon) {
        this.matteBorder(vgap, hgap, vgap, hgap, tileicon);
    }

    public void matteBorder(int top, int left, int bottom, int right, Icon tileicon) {
        this.addBorder(Borders.matte(top, left, bottom, right, tileicon));
    }

    public void lineBorder() {
        this.lineBorder(Color.black, 1);
    }

    public void lineBorder(Color color) {
        this.lineBorder(color, 1);
    }

    public void lineBorder(int thickness) {
        this.lineBorder(Color.black, thickness);
    }

    public void lineBorder(Color color, int thickness) {
        this.addBorder(Borders.line(color, thickness));
    }

    public void etchBorderLowered() {
        this.addBorder(Borders.etchLowered());
    }

    public void etchBorderLowered(Color highlight, Color shadow) {
        this.addBorder(Borders.etchLowered(highlight, shadow));
    }

    public void etchBorderLowered(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.etchLowered(levels, highlight, shadow));
    }

    public void etchBorderRaised() {
        this.addBorder(Borders.etchRaised());
    }

    public void etchBorderRaised(Color highlight, Color shadow) {
        this.addBorder(Borders.etchRaised(highlight, shadow));
    }

    public void etchBorderRaised(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.etchRaised(levels, highlight, shadow));
    }

    public void bevelBorderLowered() {
        this.addBorder(Borders.bevelLowered());
    }

    public void bevelBorderLowered(Color highlight, Color shadow) {
        this.addBorder(Borders.bevelLowered(highlight, shadow));
    }

    public void bevelBorderLowered(Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelLowered(highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void bevelBorderLowered(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.bevelLowered(levels, highlight, shadow));
    }

    public void bevelBorderLowered(int levels, Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelLowered(levels, highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void bevelBorderRaised() {
        this.addBorder(Borders.bevelRaised());
    }

    public void bevelBorderRaised(Color highlight, Color shadow) {
        this.addBorder(Borders.bevelRaised(highlight, shadow));
    }

    public void bevelBorderRaised(Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelRaised(highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void bevelBorderRaised(int levels, Color highlight, Color shadow) {
        this.addBorder(Borders.bevelRaised(levels, highlight, shadow));
    }

    public void bevelBorderRaised(int levels, Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        Border border = Borders.bevelRaised(levels, highlightOuter, highlightInner, shadowInner, shadowOuter);
        this.addBorder(border);
    }

    public void titleBorder(String t) {
        TitledBorder border = Borders.title(t);
        this.addBorder(border);
    }

    public void titleBorder(String t, Border base) {
        TitledBorder border = Borders.title(t, base);
        this.addBorder(border);
    }

    public void titleBorder(String t, Font font, Color fontcolor) {
        TitledBorder border = Borders.title(t, font, fontcolor);
        this.addBorder(border);
    }

    public void titleBorder(String t, Border base, Font font, Color fontcolor) {
        TitledBorder border = Borders.title(t, base, font, fontcolor);
        this.addBorder(border);
    }

    public void titleBorder(String t, int hPosition, int vPosition) {
        TitledBorder border = Borders.title(t, hPosition, vPosition);
        this.addBorder(border);
    }

    public void titleBorder(String t, int hPosition, int vPosition, Border base) {
        TitledBorder border = Borders.title(t, hPosition, vPosition, base);
        this.addBorder(border);
    }

    public void titleBorder(String t, int hPosition, int vPosition, Font font, Color fontcolor) {
        TitledBorder border = Borders.title(t, hPosition, vPosition, font, fontcolor);
        this.addBorder(border);
    }

    public void titleBorder(String t, int hPosition, int vPosition, Border base, Font font, Color fontcolor) {
        TitledBorder border = Borders.title(t, hPosition, vPosition, base, font, fontcolor);
        this.addBorder(border);
    }

    public void compoundBorder(Border outer, Border inner) {
        Border border = Borders.compound(outer, inner);
        this.addBorder(border);
    }

    public void compoundBorder(Border[] borders) {
        Border border = Borders.compound(borders);
        this.addBorder(border);
    }

    public void sandwichBorder(Border center, Border wrap) {
        Border border = Borders.sandwich(center, wrap);
        this.addBorder(border);
    }

    public void setDeepBackground(Color c) {
        this.setBackground(c);
        Component[] components = this.getComponents();
        int length = components.length;
        int i = 0;
        while (i < length) {
            Component component = components[i];
            if (component != null) {
                if (component instanceof DisplayPanel) {
                    DisplayPanel panel = (DisplayPanel)component;
                    panel.setDeepBackground(c);
                } else if (component instanceof JPTComponent) {
                    JPTComponent thing = (JPTComponent)component;
                    thing.setDeepBackground(c);
                } else {
                    component.setBackground(c);
                }
            }
            ++i;
        }
    }

    public void setDeepBackground(Color c, Class type) {
        if (type == null) {
            return;
        }
        if (type.isInstance(this)) {
            this.setBackground(c);
        }
        Component[] components = this.getComponents();
        int length = components.length;
        int i = 0;
        while (i < length) {
            Component component = components[i];
            if (component != null) {
                if (component instanceof DisplayPanel) {
                    DisplayPanel panel = (DisplayPanel)component;
                    panel.setDeepBackground(c, type);
                } else if (component instanceof JPTComponent) {
                    JPTComponent thing = (JPTComponent)component;
                    thing.setDeepBackground(c, type);
                } else if (type.isInstance(component)) {
                    component.setBackground(c);
                }
            }
            ++i;
        }
    }

    public Component add(Component c) {
        return this.add(c, -1);
    }

    public Component add(Component c, int index) {
        super.add(c, index);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
        return c;
    }

    public void add(Component c, Object constraints) {
        super.add(c, constraints);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void add(Component c, Object constraints, int index) {
        super.add(c, constraints, index);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public Component add(String name, Component c) {
        super.add(name, c);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.addMalformedDataListener(this);
        }
        this.revalidate();
        return c;
    }

    public Component addObject(Object object) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component);
        }
        return component;
    }

    public Component addObject(Object object, int index) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, index);
        }
        return component;
    }

    public Component addObject(Object object, Object constraints) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, constraints);
        }
        return component;
    }

    public Component addObject(Object object, Object constraints, int index) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, constraints, index);
        }
        return component;
    }

    public Component makeComponent(Object object) {
        return ComponentFactory.makeComponent(object);
    }

    public void remove(Component c) {
        super.remove(c);
        if (c != null && c instanceof Fragile) {
            Fragile f = (Fragile)((Object)c);
            f.removeMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void remove(int index) {
        try {
            try {
                Component c = this.getComponent(index);
                if (c != null && c instanceof Fragile) {
                    Fragile f = (Fragile)((Object)c);
                    f.removeMalformedDataListener(this);
                }
            }
            catch (Exception exception) {}
        }
        finally {
            super.remove(index);
            this.revalidate();
        }
    }

    public void removeAll() {
        while (this.getComponentCount() > 0) {
            this.remove(0);
        }
    }

    public void uniformizeSize() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = new Dimension();
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = DimensionUtilities.max(d, component.getPreferredSize());
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                component.setPreferredSize(d);
            }
            ++i;
        }
    }

    public void uniformizeWidth() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = null;
        int maxWidth = 0;
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = component.getPreferredSize();
                maxWidth = Math.max(maxWidth, (int)d.getWidth());
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = component.getPreferredSize();
                d.setSize(maxWidth, (int)d.getHeight());
                component.setPreferredSize(d);
            }
            ++i;
        }
    }

    public void uniformizeHeight() {
        Component[] list = this.getComponents();
        int length = list.length;
        JComponent component = null;
        Dimension d = null;
        int maxHeight = 0;
        int i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = component.getPreferredSize();
                maxHeight = Math.max(maxHeight, (int)d.getHeight());
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            if (list[i] instanceof JComponent) {
                component = (JComponent)list[i];
                d = component.getPreferredSize();
                d.setSize((int)d.getWidth(), maxHeight);
                component.setPreferredSize(d);
            }
            ++i;
        }
    }

    public void setCodec(String codecID) {
        String oldCodec = this.getCodec();
        if (codecID != null) {
            this.codec = codecID;
        }
        if (this.getCodec() != oldCodec) {
            this.firePropertyChange(CODEC, oldCodec, this.getCodec());
        }
    }

    public String getCodec() {
        return this.codec;
    }

    public JPTFrame frame() {
        return this.frame(null, 0, null);
    }

    public JPTFrame frame(int location) {
        return this.frame(null, location, null);
    }

    public JPTFrame frame(String title) {
        return this.frame(title, 0, null);
    }

    public JPTFrame frame(String title, int location) {
        return this.frame(title, location, null);
    }

    public JPTFrame frame(String title, Insets insets) {
        return this.frame(title, 0, insets);
    }

    public JPTFrame frame(String title, int location, Insets insets) {
        return JPTFrame.frame(this, title, location, insets);
    }

    public GeneralDialog OKDialog() {
        return this.OKDialog(null);
    }

    public GeneralDialog OKDialog(String title) {
        GeneralDialog dialog = GeneralDialog.makeOKDialog(this, title);
        dialog.setVisible(true);
        return dialog;
    }

    public GeneralDialog OKCancelDialog() {
        return this.OKCancelDialog(null);
    }

    public GeneralDialog OKCancelDialog(String title) {
        GeneralDialog dialog = GeneralDialog.makeOKCancelDialog(this, title);
        dialog.setVisible(true);
        return dialog;
    }

    public GeneralDialog YesNoCancelDialog() {
        return this.YesNoCancelDialog(null);
    }

    public GeneralDialog YesNoCancelDialog(String title) {
        GeneralDialog dialog = GeneralDialog.makeYesNoCancelDialog(this, title);
        dialog.setVisible(true);
        return dialog;
    }

    public GeneralDialog generalDialog(Object[][] actionData) {
        return this.generalDialog(null, actionData, null);
    }

    public GeneralDialog generalDialog(Object[][] actionData, Object defaultAction) {
        return this.generalDialog(null, actionData, defaultAction);
    }

    public GeneralDialog generalDialog(String title, Object[][] actionData) {
        return this.generalDialog(title, actionData, null);
    }

    public GeneralDialog generalDialog(String title, Object[][] actionData, Object defaultAction) {
        GeneralDialog dialog = new GeneralDialog((Object)this, title, actionData, defaultAction);
        dialog.setVisible(true);
        return dialog;
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

