/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.StringViewer;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StackTrace;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class DirectApplet
extends JApplet
implements JPTConstants {
    protected boolean initializationSuccessful = false;
    protected Component component = null;

    public abstract Object createGUI();

    public final void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DirectApplet.this.createAppletGUI();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void destroy() {
        if (this.initializationSuccessful) {
            JPTFrame.decrementCounter();
        }
    }

    private final void createAppletGUI() {
        Container pane = this.getContentPane();
        pane.setLayout(new CenterLayout());
        String message = "";
        try {
            Object object = this.createGUI();
            if (object == null) {
                message = "\nNull object returned from createGUI\n";
                throw new RuntimeException(message);
            }
            this.component = ComponentFactory.makeComponent(object);
            if (this.component == null) {
                message = "\nObject returned from createGUI\nis not a Component\nand cannot be converted to one\n\nclass = " + object.getClass() + "\n";
                throw new RuntimeException(message);
            }
            pane.add(this.component);
            if (this.component instanceof JComponent) {
                JComponent c = (JComponent)this.component;
                this.setSize(c.getPreferredSize());
            } else {
                this.setSize(this.component.getSize());
            }
            this.initializationSuccessful = true;
            JPTFrame.incrementCounter();
        }
        catch (Throwable t) {
            String trace = StackTrace.getTrace(t);
            StringViewer.showStringInDialog(trace);
            return;
        }
    }
}

