/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionWrapper;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.SimpleAction;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;

public class DialogAction
extends ActionWrapper
implements ConsoleAware {
    public static final Object KEEP_OPEN = new Object();
    public static final Object AUTO_CLOSE = new Object();
    public static final Object SET_CANCEL = new Object();
    protected GeneralDialog dialog = null;
    protected Object finish = AUTO_CLOSE;

    public DialogAction(GeneralDialog dialog, Action action, Object finish) {
        if (dialog == null) {
            throw new NullPointerException("Null dialog passed to a DialogAction constructor");
        }
        this.dialog = dialog;
        this.setAction(action);
        this.setFinish(finish);
    }

    public DialogAction(GeneralDialog dialog, String name, Object finish) {
        this(dialog, DialogAction.makeTrivialAction(name), finish);
    }

    public DialogAction(GeneralDialog dialog, String name, Icon icon, Object finish) {
        this(dialog, DialogAction.makeTrivialAction(name, icon), finish);
    }

    public DialogAction(GeneralDialog dialog, Object[] actionData) {
        if (dialog == null) {
            throw new NullPointerException("Null dialog passed to a DialogAction constructor");
        }
        this.dialog = dialog;
        this.setActionAndFinish(actionData);
    }

    public void actionPerformed(ActionEvent event) {
        this.dialog.setCancelled(false);
        String name = this.getName();
        try {
            try {
                if (this.action != null) {
                    this.action.actionPerformed(event);
                }
            }
            catch (Exception exception) {
                String message = exception.getMessage();
                if (message == null) {
                    message = "";
                }
                message = "\nDialogAction Error: " + message + "\nIn Action: " + name;
                DialogAction.console.err.println();
                DialogAction.console.err.println(message);
                DialogAction.console.err.println();
                exception.printStackTrace(DialogAction.console.err);
                DialogAction.console.err.println();
                if (this.finish == KEEP_OPEN) {
                    this.finish = AUTO_CLOSE;
                }
                throw new RuntimeException(message);
            }
        }
        finally {
            if (this.finish == KEEP_OPEN) {
                return;
            }
            if (this.finish == SET_CANCEL) {
                this.dialog.setCancelled(true);
            }
            this.dialog.setResponseAndClose(name);
        }
    }

    public Object getFinish() {
        return this.finish;
    }

    public void setFinish(Object finish) {
        this.finish = finish == KEEP_OPEN || finish == AUTO_CLOSE || finish == SET_CANCEL ? finish : AUTO_CLOSE;
    }

    public void setActionAndFinish(Object[] actionData) {
        Action action = null;
        String name = null;
        Icon icon = null;
        Object finish = AUTO_CLOSE;
        if (actionData != null) {
            int length = actionData.length;
            int index = 0;
            while (index < length) {
                if (actionData[index] instanceof Action) {
                    action = (Action)actionData[index];
                    ++index;
                    continue;
                }
                if (actionData[index] instanceof String) {
                    name = (String)actionData[index];
                    if (++index < length && actionData[index] instanceof Icon) {
                        icon = (Icon)actionData[index];
                        ++index;
                        action = DialogAction.makeTrivialAction(name, icon);
                        continue;
                    }
                    action = DialogAction.makeTrivialAction(name);
                    continue;
                }
                if (actionData[index] == KEEP_OPEN) {
                    finish = KEEP_OPEN;
                    break;
                }
                if (actionData[index] == AUTO_CLOSE) {
                    finish = AUTO_CLOSE;
                    break;
                }
                if (actionData[index] != SET_CANCEL) break;
                finish = SET_CANCEL;
                break;
            }
        }
        this.setAction(action);
        this.setFinish(finish);
    }

    public static DialogAction makeDialogAction(GeneralDialog dialog, Object[] actionData) {
        if (dialog == null) {
            throw new NullPointerException("Null dialog passed to makeDialogAction");
        }
        return new DialogAction(dialog, actionData);
    }

    public static DialogAction[] makeDialogActions(GeneralDialog dialog, Object[][] actionData) {
        if (dialog == null) {
            throw new NullPointerException("Null dialog passed to makeDialogActions");
        }
        if (actionData == null) {
            return null;
        }
        int length = actionData.length;
        DialogAction[] actionList = new DialogAction[length];
        int i = 0;
        while (i < length) {
            actionList[i] = DialogAction.makeDialogAction(dialog, actionData[i]);
            ++i;
        }
        return actionList;
    }

    public static Action makeTrivialAction(String name) {
        return new SimpleAction(name){

            public void perform() {
            }
        };
    }

    public static Action makeTrivialAction(String name, Icon icon) {
        return new SimpleAction(name, icon){

            public void perform() {
            }
        };
    }
}

