/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Function;
import edu.neu.ccs.XInterval;
import java.awt.geom.Point2D;

public class DataTables2D {
    public static Point2D[] makeTable(Function.OneArg f, XInterval limits, int divisions) {
        if (f == null || limits == null) {
            return null;
        }
        double lower = limits.getMinimum();
        double upper = limits.getMaximum();
        if (divisions < 1) {
            divisions = 1;
        }
        double delta = (upper - lower) / (double)divisions;
        Point2D[] data = new Point2D[divisions + 1];
        int i = 0;
        while (i <= divisions) {
            double x = i < divisions ? lower + (double)i * delta : upper;
            double y = f.evaluate(x);
            data[i] = new Point2D.Double(x, y);
            ++i;
        }
        return data;
    }

    public static Point2D[] makeTable(Function.OneArg f, double endpointA, double endpointB, int divisions) {
        return DataTables2D.makeTable(f, new XInterval(endpointA, endpointB), divisions);
    }

    public static Point2D[][] makeTable(Function.OneArg[] f, XInterval limits, int divisions) {
        if (f == null || limits == null) {
            return null;
        }
        int size = f.length;
        Point2D[][] data = new Point2D[size][];
        int i = 0;
        while (i < size) {
            data[i] = DataTables2D.makeTable(f[i], limits, divisions);
            ++i;
        }
        return data;
    }

    public static Point2D[][] makeTable(Function.OneArg[] f, double endpointA, double endpointB, int divisions) {
        return DataTables2D.makeTable(f, new XInterval(endpointA, endpointB), divisions);
    }
}

