/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.ImagePaintable;
import edu.neu.ccs.gui.MultiLineTextPaintable;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.PointPaintable;
import edu.neu.ccs.gui.ShapePaintable;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ComponentFactory {
    public static Component makeComponent(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Component) {
            return (Component)o;
        }
        if (o instanceof String) {
            return new Annotation((String)o);
        }
        if (o instanceof Icon) {
            return new Annotation((Icon)o);
        }
        if (o instanceof Action) {
            return new JButton((Action)o);
        }
        if (o instanceof Paint) {
            return new PaintSwatch((Paint)o);
        }
        Paintable p = ComponentFactory.makePaintable(o);
        if (p instanceof Paintable) {
            return new PaintableComponent(p);
        }
        return null;
    }

    public static Icon makeIcon(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Icon) {
            return (Icon)o;
        }
        if (o instanceof Paint) {
            return new PaintSwatch((Paint)o);
        }
        Paintable p = ComponentFactory.makePaintable(o);
        if (p instanceof Paintable) {
            return new PaintableComponent(p);
        }
        return null;
    }

    public static Paintable makePaintable(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Paintable) {
            return (Paintable)o;
        }
        if (o instanceof Image) {
            return new ImagePaintable((Image)o);
        }
        if (o instanceof ImageIcon) {
            return new ImagePaintable((ImageIcon)o);
        }
        if (o instanceof PathList) {
            o = ((PathList)o).makeShape();
        }
        if (o instanceof Shape) {
            return new ShapePaintable((Shape)o);
        }
        if (o instanceof String) {
            return new MultiLineTextPaintable((String)o);
        }
        if (o instanceof Point2D) {
            PointPaintable pp = new PointPaintable();
            pp.setPoint((Point2D)o);
            return pp;
        }
        if (o instanceof Object[]) {
            return new PaintableSequence((Object[])o);
        }
        return null;
    }
}

