/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XColor;
import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.ColorPaneDialog;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.DropdownView;
import edu.neu.ccs.gui.Halo;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SwatchNameRenderer;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TypedView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.Action;

public class ColorView
extends DisplayPanel
implements TypedView {
    public static final String CHOOSER_CLICK_COUNT = "chooser click count";
    public static final String SET_CURRENT_COLOR = "set current color";
    public static final String SET_DEFAULT_COLOR = "set default color";
    public static final Color DEFAULT_COLOR = Color.black;
    public static final int DEFAULT_CHOOSER_CLICK_COUNT = 1;
    public static final int BOX_SIZE = 20;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(20, 20);
    public static final int DEFAULT_WIDTH = 200;
    private Color currentColor = DEFAULT_COLOR;
    private Color defaultColor = DEFAULT_COLOR;
    private int chooserClickCount = 1;
    private PaintSwatch colorBox = new PaintSwatch(DEFAULT_COLOR);
    private MouseActionAdapter colorBoxActions = this.colorBox.getMouseActionAdapter();
    private MouseAction colorBoxAction = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            ColorView.this.colorBoxAction(evt);
        }
    };
    private ColorPaneDialog colorPaneDialog = null;
    private SwatchNameRenderer renderer = new SwatchNameRenderer();
    private DropdownView colorDropdownView;
    private Action setColorFromDropdownView;
    private ActionSequence setColorActions;
    static /* synthetic */ Class class$0;

    public ColorView() {
        this(null, true, null, 0);
    }

    public ColorView(Color color) {
        this(color, true, null, 0);
    }

    public ColorView(Color color, Dimension dimension) {
        this(color, true, dimension, 0);
    }

    public ColorView(Color color, Dimension dimension, int minWidth) {
        this(color, true, dimension, minWidth);
    }

    public ColorView(Color color, int width, int height) {
        this(color, true, new Dimension(width, height), 0);
    }

    public ColorView(Color color, int width, int height, int minWidth) {
        this(color, true, new Dimension(width, height), minWidth);
    }

    public ColorView(Color color, boolean showDropdown) {
        this(color, showDropdown, null, 0);
    }

    public ColorView(Color color, boolean showDropdown, Dimension dimension) {
        this(color, showDropdown, dimension, 0);
    }

    public ColorView(Color color, boolean showDropdown, Dimension dimension, int minWidth) {
        String[] stringArray = this.renderer.getStrings();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XColor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.colorDropdownView = new DropdownView(stringArray, "", 200, true, (Class)clazz);
        this.setColorFromDropdownView = new SimpleAction("Set Color From Drop Down View"){

            public void perform() {
                ColorView.this.setColorFromDropdownView();
            }
        };
        this.setColorActions = new ActionSequence();
        this.setLayout(new TableLayout(1, 2, 5, 5, 0));
        this.installColorBox(color, dimension);
        this.installColorDropdownView(showDropdown, minWidth);
        this.installColorBoxActions();
        this.reset();
    }

    public ColorView(Color color, boolean showDropdown, int width, int height) {
        this(color, showDropdown, new Dimension(width, height), 0);
    }

    public ColorView(Color color, boolean showDropdown, int width, int height, int minWidth) {
        this(color, showDropdown, new Dimension(width, height), minWidth);
    }

    public PaintSwatch getColorBox() {
        return this.colorBox;
    }

    public DropdownView getColorDropdownView() {
        return this.colorDropdownView;
    }

    public void setColor(Color color) {
        if (color == null || color.equals(this.currentColor)) {
            return;
        }
        this.setColorHelper(color);
        this.setColorActions.actionPerformed(new ActionEvent(this, 1001, SET_CURRENT_COLOR));
        this.firePropertyChange(SET_CURRENT_COLOR, null, null);
    }

    public void setColorHelper(Color color) {
        if (color == null || color.equals(this.currentColor)) {
            return;
        }
        this.currentColor = color;
        this.colorBox.setPaint(color);
        this.colorDropdownView.setViewState(this.getViewState());
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setDefaultColor(Color color) {
        if (color == null || color.equals(this.defaultColor)) {
            return;
        }
        this.defaultColor = color;
        this.colorDropdownView.setDefaultViewState(this.getDefaultViewState());
        this.firePropertyChange(SET_DEFAULT_COLOR, null, null);
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public ActionSequence getSetColorActions() {
        return this.setColorActions;
    }

    public void addAction(ActionListener action) {
        this.setColorActions.add(action);
    }

    public void addAction(int index, ActionListener action) {
        this.setColorActions.add(index, action);
    }

    public boolean removeAction(ActionListener action) {
        return this.setColorActions.remove(action);
    }

    public ActionListener removeAction(int index) {
        return this.setColorActions.remove(index);
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.colorBoxActions;
    }

    public void setChooserClickCount(int count) {
        int n = count = count <= 1 ? 1 : 2;
        if (count == this.chooserClickCount) {
            return;
        }
        this.chooserClickCount = count;
        this.firePropertyChange(CHOOSER_CLICK_COUNT, null, null);
    }

    public int getChooserClickCount() {
        return this.chooserClickCount;
    }

    public Stringable demandObject() {
        return new XColor(this.getColor());
    }

    public Stringable requestObject() {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties p) {
        this.getColorDropdownView().setInputProperties(p);
        this.firePropertyChange("input.properties", null, null);
    }

    public InputProperties getInputProperties() {
        return this.getColorDropdownView().getInputProperties();
    }

    public Class getDataType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.neu.ccs.XColor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void setViewState(String data) {
        try {
            XColor xcolor = new XColor(data);
            this.setColor(xcolor.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getViewState() {
        return XColor.colorToString(this.getColor());
    }

    public void setDefaultViewState(String data) {
        try {
            XColor xcolor = new XColor(data);
            this.setDefaultColor(xcolor.getValue());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getDefaultViewState() {
        return XColor.colorToString(this.getDefaultColor());
    }

    public void reset() {
        this.setColor(this.defaultColor);
    }

    protected void setColorFromDropdownView() {
        XColor xcolor = (XColor)this.colorDropdownView.demandObject();
        this.setColor(xcolor.getValue());
    }

    protected void installColorBox(Color color, Dimension dimension) {
        this.currentColor = color = color == null ? DEFAULT_COLOR : color;
        this.defaultColor = color;
        this.colorBox.setPaint(color);
        if (dimension != null) {
            int w = dimension.width;
            int h = dimension.height;
            if (w <= 0 || h <= 0) {
                return;
            }
            this.colorBox.setSize(w, h);
        }
        this.add(this.colorBox);
    }

    protected void installColorDropdownView(boolean showDropdown, int minWidth) {
        this.colorDropdownView.setViewState(this.getViewState());
        this.colorDropdownView.setDefaultViewState(this.getDefaultViewState());
        Dimension size = this.renderer.getMaximumPreferredSize();
        minWidth = Math.max(minWidth, size.width);
        this.colorDropdownView.setMinimumWidth(minWidth);
        this.colorDropdownView.autoSetPreferredWidth();
        this.colorDropdownView.setRenderer(this.renderer);
        this.colorDropdownView.setMaximumRowCount(18);
        this.colorDropdownView.setErrorPromptTitleSuggestion("Color Error", "Color Error Dialog", this.getDefaultViewState());
        this.colorDropdownView.addActionListener(this.setColorFromDropdownView);
        if (showDropdown) {
            this.add(new Halo(this.colorDropdownView));
        }
    }

    protected void installColorBoxActions() {
        this.colorBoxActions.addMouseClickedAction(this.colorBoxAction);
    }

    private void colorBoxAction(MouseEvent evt) {
        if (this.colorBox.isEnabled() && evt.getClickCount() >= this.chooserClickCount) {
            if (this.colorPaneDialog == null) {
                this.colorPaneDialog = new ColorPaneDialog();
            }
            this.colorPaneDialog.setBothColors(this.currentColor);
            this.colorPaneDialog.setVisible(true);
            if (!this.colorPaneDialog.wasCancelled()) {
                this.setColor(this.colorPaneDialog.getColor());
            }
        }
    }
}

