/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XColor;
import edu.neu.ccs.gui.ColorPane;
import edu.neu.ccs.gui.DialogAction;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.util.MathUtilities;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.JButton;

public class ColorPaneDialog
extends GeneralDialog {
    ColorPane colorPane = (ColorPane)this.getDialogContents();

    public ColorPaneDialog() {
        this(Colors.white);
    }

    public ColorPaneDialog(Color color) {
        super(new ColorPane(color));
        Font buttonFont = this.colorPane.getButtonFont();
        Action ok = DialogAction.makeTrivialAction("OK");
        Action cancel = DialogAction.makeTrivialAction("Cancel");
        JButton okButton = this.addAction(ok, DialogAction.AUTO_CLOSE);
        JButton cancelButton = this.addAction(cancel, DialogAction.SET_CANCEL);
        this.setWindowClosingAction(cancel, DialogAction.SET_CANCEL);
        okButton.setFont(buttonFont);
        cancelButton.setFont(buttonFont);
        this.setDeepBackground(Colors.white);
    }

    public Color getColor() {
        return this.colorPane.getColor();
    }

    public void setColor(Color color) {
        this.colorPane.setColor(color);
    }

    public Color getInitialColor() {
        return this.colorPane.getInitialColor();
    }

    public void setInitialColor(Color color) {
        this.colorPane.setInitialColor(color);
    }

    public void setBothColors(Color color) {
        this.colorPane.setColor(color);
        this.colorPane.setInitialColor(color);
    }

    public static void main(String[] args) {
        int r = MathUtilities.randomInt(0, 255);
        int g = MathUtilities.randomInt(0, 255);
        int b = MathUtilities.randomInt(0, 255);
        Color color = new Color(r, g, b);
        ColorPaneDialog dialog = new ColorPaneDialog(color);
        dialog.setVisible(true);
        String message = "";
        if (dialog.wasCancelled()) {
            message = "Color pane dialog was cancelled";
            GeneralDialog.showOKDialog(message, "");
        } else {
            color = dialog.getColor();
            PaintSwatch swatch = new PaintSwatch(color, 200, 200);
            message = "Selected color = " + XColor.colorToString(color);
            Object[] stuff = new Object[]{swatch, message};
            VTable panel = new VTable(stuff, 10, 10, 0);
            panel.emptyBorder(10);
            GeneralDialog.showOKDialog(panel, "");
        }
    }
}

