/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.BasePane;
import edu.neu.ccs.gui.ColorView;
import edu.neu.ccs.gui.HTable;
import edu.neu.ccs.gui.MultiLineTextPaintable;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SliderView;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.VTable;
import edu.neu.ccs.util.MathUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ColorPane
extends BasePane {
    public static final int SIZE = 200;
    public static final int THICK = 2;
    protected PaintSwatch upperSwatch = new PaintSwatch(null, 200, 100, null);
    protected PaintSwatch lowerSwatch = new PaintSwatch(null, 200, 100, null);
    protected Object[] swatchStuff = new Object[]{this.upperSwatch, this.lowerSwatch};
    protected VTable swatchPanel = new VTable(this.swatchStuff, 0, 0, 0);
    protected PaintableComponent swatchLabelComponent = this.makeSwatchPanelLabels();
    protected Object[] labelSwatchStuff = new Object[]{this.swatchLabelComponent, this.swatchPanel};
    protected HTable labelSwatchPanel = new HTable(this.labelSwatchStuff, 2 * this.gap, 2 * this.gap, 0);
    protected Paint R_Paint = new GradientPaint(0.0f, 0.0f, Color.black, 255.0f, 0.0f, Colors.red);
    protected Paint G_Paint = new GradientPaint(0.0f, 0.0f, Color.black, 255.0f, 0.0f, Colors.lime);
    protected Paint B_Paint = new GradientPaint(0.0f, 0.0f, Color.black, 255.0f, 0.0f, Colors.blue);
    protected Paint A_Paint = new GradientPaint(0.0f, 0.0f, Color.black, 255.0f, 0.0f, Colors.white);
    protected Color R_Color = Colors.red;
    protected Color G_Color = Colors.lime;
    protected Color B_Color = Colors.blue;
    protected Color A_Color = Colors.black;
    protected SliderView R_Slider = new SliderView(0, 0, 255, 255, 256, 32, 8, null, this.R_Color, this.R_Paint, this.R_Color, true);
    protected SliderView G_Slider = new SliderView(0, 0, 255, 255, 256, 32, 8, null, this.G_Color, this.G_Paint, this.G_Color, true);
    protected SliderView B_Slider = new SliderView(0, 0, 255, 255, 256, 32, 8, null, this.B_Color, this.B_Paint, this.B_Color, true);
    protected SliderView A_Slider = new SliderView(0, 0, 255, 255, 256, 32, 8, null, this.A_Color, this.A_Paint, this.A_Color, true);
    protected Annotation R_Label = new Annotation("Red", this.labelFont);
    protected Annotation G_Label = new Annotation("Green", this.labelFont);
    protected Annotation B_Label = new Annotation("Blue", this.labelFont);
    protected Annotation A_Label = new Annotation("Alpha", this.labelFont);
    protected Object[][] sliderStuff = new Object[][]{{this.R_Label, this.R_Slider}, {this.G_Label, this.G_Slider}, {this.B_Label, this.B_Slider}, {this.A_Label, this.A_Slider}};
    protected TablePanel sliderPanel = new TablePanel(this.sliderStuff, this.gap, this.gap, 7);
    protected ColorView colorview = new ColorView(null, 0, 0);
    protected Annotation colorviewLabel = new Annotation("Color Dropdown List", this.labelFont);
    protected Object[] colorviewStuff = new Object[]{this.colorviewLabel, this.colorview};
    protected HTable colorviewPanel = new HTable(this.colorviewStuff, this.gap, this.gap, 0);
    protected SimpleAction initialToCurrentAction = new SimpleAction("Reset Selected Color From Original"){

        public void perform() {
            ColorPane.this.setCurrentFromInitial();
        }
    };
    protected JButton initialToCurrentButton = new JButton(this.initialToCurrentAction);
    protected SimpleAction currentToInitialAction = new SimpleAction("Reset Original Color From Selected"){

        public void perform() {
            ColorPane.this.setInitialFromCurrent();
        }
    };
    protected JButton currentToInitialButton = new JButton(this.currentToInitialAction);
    protected Object[] mainStuff = new Object[]{this.labelSwatchPanel, this.sliderPanel, this.colorviewPanel, this.initialToCurrentButton, this.currentToInitialButton};
    protected VTable mainPanel = new VTable(this.mainStuff, 2 * this.gap, 2 * this.gap, 0);
    protected SimpleAction setColorFromSlidersAction = new SimpleAction(){

        public void perform() {
            ColorPane.this.setColorFromSliders();
        }
    };
    protected SimpleAction setColorFromColorViewAction = new SimpleAction(){

        public void perform() {
            ColorPane.this.setColorFromColorView();
        }
    };
    protected ActionSequence pressActions = new ActionSequence();
    protected ActionSequence slidingActions = new ActionSequence();
    protected ActionSequence releaseActions = new ActionSequence();

    public ColorPane() {
        this(Colors.white);
    }

    public ColorPane(Color color) {
        if (color == null) {
            color = Colors.white;
        }
        this.setInitialColor(color);
        this.setColor(color);
        this.R_Slider.addSlidingAction(this.setColorFromSlidersAction);
        this.G_Slider.addSlidingAction(this.setColorFromSlidersAction);
        this.B_Slider.addSlidingAction(this.setColorFromSlidersAction);
        this.A_Slider.addSlidingAction(this.setColorFromSlidersAction);
        this.R_Slider.addPressAction(this.pressActions);
        this.G_Slider.addPressAction(this.pressActions);
        this.B_Slider.addPressAction(this.pressActions);
        this.A_Slider.addPressAction(this.pressActions);
        this.R_Slider.addSlidingAction(this.slidingActions);
        this.G_Slider.addSlidingAction(this.slidingActions);
        this.B_Slider.addSlidingAction(this.slidingActions);
        this.A_Slider.addSlidingAction(this.slidingActions);
        this.R_Slider.addReleaseAction(this.releaseActions);
        this.G_Slider.addReleaseAction(this.releaseActions);
        this.B_Slider.addReleaseAction(this.releaseActions);
        this.A_Slider.addReleaseAction(this.releaseActions);
        this.R_Label.setForeground(this.R_Color);
        this.G_Label.setForeground(this.G_Color);
        this.B_Label.setForeground(this.B_Color);
        this.A_Label.setForeground(this.A_Color);
        this.colorview.addAction(this.setColorFromColorViewAction);
        this.initialToCurrentButton.setFont(this.buttonFont);
        this.currentToInitialButton.setFont(this.buttonFont);
        this.swatchPanel.lineBorder(2);
        this.mainPanel.setDeepBackground(Colors.white);
        this.mainPanel.emptyBorder(this.gap);
        this.addObject(this.mainPanel);
    }

    public Color getColor() {
        return (Color)this.lowerSwatch.getPaint();
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        this.R_Slider.setValue(r);
        this.G_Slider.setValue(g);
        this.B_Slider.setValue(b);
        this.A_Slider.setValue(a);
        this.colorview.setColorHelper(color);
        this.lowerSwatch.setPaint(color);
    }

    public Color getInitialColor() {
        return (Color)this.upperSwatch.getPaint();
    }

    public void setInitialColor(Color color) {
        if (color == null) {
            return;
        }
        this.upperSwatch.setPaint(color);
    }

    public void setCurrentFromInitial() {
        this.setColor(this.getInitialColor());
    }

    public void setInitialFromCurrent() {
        this.setInitialColor(this.getColor());
    }

    protected void setColorFromSliders() {
        int r = this.R_Slider.getValue();
        int g = this.G_Slider.getValue();
        int b = this.B_Slider.getValue();
        int a = this.A_Slider.getValue();
        Color color = new Color(r, g, b, a);
        this.colorview.setColorHelper(color);
        this.lowerSwatch.setPaint(color);
    }

    protected void setColorFromColorView() {
        this.setColor(this.colorview.getColor());
    }

    public void addPressAction(ActionListener a) {
        this.pressActions.add(a);
    }

    public void addSlidingAction(ActionListener a) {
        this.slidingActions.add(a);
    }

    public void addReleaseAction(ActionListener a) {
        this.releaseActions.add(a);
    }

    public void removePressAction(ActionListener a) {
        this.pressActions.remove(a);
    }

    public void removeSlidingAction(ActionListener a) {
        this.slidingActions.remove(a);
    }

    public void removeReleaseAction(ActionListener a) {
        this.releaseActions.remove(a);
    }

    protected PaintableComponent makeSwatchPanelLabels() {
        String label1 = "Original\nColor";
        String label2 = "Selected\nColor";
        MultiLineTextPaintable tp1 = new MultiLineTextPaintable(label1, this.labelFont, TextAnchor.CENTER_ASCENTLINE, 0.0f, 0.0f);
        MultiLineTextPaintable tp2 = new MultiLineTextPaintable(label2, this.labelFont, TextAnchor.CENTER_ASCENTLINE, 0.0f, 0.0f);
        XRect bounds = tp1.getActualBounds2D();
        int w = (int)bounds.width;
        int h = (int)bounds.height;
        w = w % 2 == 0 ? (w += 2 * this.gap) : (w += 2 * this.gap + 1);
        int half_w = w / 2;
        int half_h = h / 2;
        int jump = 50;
        tp1.moveCenterTo(half_w, jump + 2 - half_h);
        tp2.moveCenterTo(half_w, 3 * jump + 2 - half_h);
        bounds = new XRect(0.0, 0.0, w, 204.0);
        PaintableSequence sequence = new PaintableSequence();
        sequence.setDefaultOriginalBounds2D(bounds);
        sequence.addPaintable(tp1);
        sequence.addPaintable(tp2);
        return new PaintableComponent(sequence);
    }

    public static void main(String[] args) {
        int r = MathUtilities.randomInt(0, 255);
        int g = MathUtilities.randomInt(0, 255);
        int b = MathUtilities.randomInt(0, 255);
        Color color = new Color(r, g, b);
        new ColorPane(color).frame();
    }
}

