/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

public class ClippingWrapper
extends AbstractPaintable {
    private Paintable paintable = null;
    private Shape clippingshape = null;

    public ClippingWrapper() {
    }

    public ClippingWrapper(Paintable paintable) {
        this.setPaintable(paintable);
    }

    public ClippingWrapper(Paintable paintable, Shape clippingshape) {
        this.setPaintable(paintable);
        this.setClippingShape(clippingshape);
    }

    public final void originalPaint(Graphics g) {
        if (this.paintable == null || g == null || !this.isVisible()) {
            return;
        }
        Graphics2D h = (Graphics2D)g.create();
        if (this.clippingshape != null) {
            h.clip(this.clippingshape);
        }
        this.paintable.paint(h);
    }

    public final XRect getActualBounds2D() {
        if (this.paintable == null) {
            return null;
        }
        XRect bounds = this.paintable.getBounds2D();
        if (this.clippingshape != null) {
            XRect clippingbounds = new XRect(this.clippingshape.getBounds2D());
            bounds = bounds.createIntersectionRect(clippingbounds);
        }
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return null;
        }
        return bounds;
    }

    public final boolean originalContains(double x, double y) {
        if (this.paintable == null) {
            return false;
        }
        if (this.clippingshape == null) {
            return this.paintable.contains(x, y);
        }
        return this.paintable.contains(x, y) && this.clippingshape.contains(x, y);
    }

    public final void setPaintable(Paintable paintable) {
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange("set.paintable", null, null);
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }

    public final void setClippingShape(Shape clippingshape) {
        if (clippingshape == this.clippingshape) {
            return;
        }
        this.removeAndAddForwardingListener(this.clippingshape, clippingshape);
        this.clippingshape = clippingshape;
        this.firePropertyChange("set.clipping.shape", null, null);
    }

    public final Shape getClippingShape() {
        return this.clippingshape;
    }
}

