/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.ColorView;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TablePanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class CheckerBoard
extends TablePanel {
    public static final int gap = 10;
    public static final int MAXIMUM_BLOCK = 80;
    public static final int BLOCK = 48;
    public static final int MINIMUM_BLOCK = 16;
    public static final Color COLOR0 = Colors.black;
    public static final Color COLOR1 = Colors.white;
    private BufferedPanel window = null;
    private int block = 48;
    private Rectangle2D[][] blocks = new Rectangle2D[8][8];
    private ColorView view0 = null;
    private ColorView view1 = null;
    private SimpleAction colorCheckerBoard = new SimpleAction("Make Checker Board"){

        public void perform() {
            CheckerBoard.this.colorCheckerBoard();
        }
    };
    private SimpleAction resetColorViews = new SimpleAction("Reset Color Views"){

        public void perform() {
            CheckerBoard.this.resetColorViews();
        }
    };

    public CheckerBoard() {
        this(48, null, null, true, false);
    }

    public CheckerBoard(int block, Color color0, Color color1, boolean showColorViews, boolean autoFrame) {
        super(4, 1, 10, 10, 0);
        this.createCheckerBoard(block);
        this.createColorViews(color0, color1);
        this.colorCheckerBoard();
        this.installContents(showColorViews);
        this.autoFramePanel(autoFrame);
    }

    public final BufferedPanel getCheckerboard() {
        return this.window;
    }

    public final int getBlockSize() {
        return this.block;
    }

    public final int getCheckerBoardSize() {
        return 8 * this.block;
    }

    public final Color getColor0() {
        return this.view0.getColor();
    }

    public final Color getColor1() {
        return this.view1.getColor();
    }

    public final void setColor0(Color color0) {
        if (color0 != null) {
            this.view0.setColor(color0);
        }
    }

    public final void setColor1(Color color1) {
        if (color1 != null) {
            this.view1.setColor(color1);
        }
    }

    public final void resetColorViews() {
        this.view0.reset();
        this.view1.reset();
    }

    private final int adjustBlock(int block) {
        if (block < 16) {
            return 16;
        }
        if (block > 80) {
            return 80;
        }
        return block;
    }

    private final void createCheckerBoard(int block) {
        this.block = block = this.adjustBlock(block);
        int size = 8 * block;
        this.window = new BufferedPanel(size, size);
        int row = 0;
        while (row < 8) {
            int col = 0;
            while (col < 8) {
                this.blocks[row][col] = new Rectangle2D.Double(col * block, row * block, block, block);
                ++col;
            }
            ++row;
        }
    }

    private final void createColorViews(Color color0, Color color1) {
        if (color0 == null) {
            color0 = COLOR0;
        }
        if (color1 == null) {
            color1 = COLOR1;
        }
        this.view0 = new ColorView(color0);
        this.view1 = new ColorView(color1);
        this.view0.addAction(this.colorCheckerBoard);
        this.view1.addAction(this.colorCheckerBoard);
    }

    private final void installContents(boolean showColorViews) {
        this.addObject((Object)this.window, 0, 0);
        if (showColorViews) {
            this.addObject((Object)this.view0, 1, 0);
            this.addObject((Object)this.view1, 2, 0);
            this.addObject((Object)this.resetColorViews, 3, 0);
        }
    }

    private final void autoFramePanel(boolean autoFrame) {
        if (autoFrame) {
            this.frame("Checker Board");
        }
    }

    protected final void colorCheckerBoard() {
        this.window.clearPanel();
        Graphics2D graphics = this.window.getBufferGraphics();
        Color[] colors = new Color[]{this.view0.getColor(), this.view1.getColor()};
        int row = 0;
        while (row <= 7) {
            int col = 0;
            while (col <= 7) {
                graphics.setPaint(colors[(row + col) % 2]);
                graphics.fill(this.blocks[row][col]);
                ++col;
            }
            ++row;
        }
        this.window.repaint();
    }
}

