/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XLine2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.KeyActionAdapter;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableSequence;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class BufferedPanel
extends DisplayPanel {
    public static final Color DEFAULT_BUFFER_BACKGROUND = Color.white;
    protected BufferedImage buffer = null;
    private int bufferwidth = 0;
    private int bufferheight = 0;
    protected PaintableSequence paintablesequence = new PaintableSequence();
    protected Painter painter = null;
    protected Paint bufferBackground = DEFAULT_BUFFER_BACKGROUND;
    protected MouseActionAdapter mouseActions = null;
    protected KeyActionAdapter keyActions = null;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected Paintable currentPaintable = null;
    protected boolean autoShiftToTop = false;
    protected boolean mouseIsInPanel = true;
    protected MouseAction SMA_Moved_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Moved(evt);
        }
    };
    protected MouseAction SMA_Pressed_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Pressed(evt);
        }
    };
    protected MouseAction SMA_Released_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Released(evt);
        }
    };
    protected MouseAction SMA_Clicked_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Clicked(evt);
        }
    };
    protected MouseAction SMA_Dragged_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Dragged(evt);
        }
    };
    protected MouseAction SMA_Entered_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Entered(evt);
        }
    };
    protected MouseAction SMA_Exited_Action = new MouseAction(){

        public void mouseActionPerformed(MouseEvent evt) {
            BufferedPanel.this.SMA_Exited(evt);
        }
    };

    public BufferedPanel(int width, int height) {
        this(width, height, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(Dimension dimension) {
        this(dimension == null ? 1 : dimension.width, dimension == null ? 1 : dimension.height, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(int width, int height, Paint background) {
        super(new CenterLayout());
        this.setBufferBackground(background);
        this.setBufferSize(width, height);
        this.makePainterPanelIfNeeded();
        this.add(this.painter);
        this.mouseActions = new MouseActionAdapter(this.painter);
        this.keyActions = new KeyActionAdapter(this.painter);
    }

    public BufferedPanel(Dimension dimension, Paint background) {
        this(dimension == null ? 1 : dimension.width, dimension == null ? 1 : dimension.height, background);
    }

    private void makePainterPanelIfNeeded() {
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
    }

    public final Graphics2D getBufferGraphics() {
        return this.buffer.createGraphics();
    }

    public final BufferedImage getBuffer() {
        return this.buffer;
    }

    public final synchronized void setBufferSize(Dimension size) {
        if (size == null) {
            return;
        }
        this.setBufferSize(size.width, size.height);
    }

    public final synchronized void setBufferSize(int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        if (this.buffer != null && width == this.bufferwidth && height == this.bufferheight) {
            return;
        }
        BufferedImage oldBuffer = this.buffer;
        this.buffer = new BufferedImage(width, height, 1);
        this.bufferwidth = width;
        this.bufferheight = height;
        this.clearPanel();
        if (oldBuffer != null) {
            Graphics2D g2 = this.getBufferGraphics();
            g2.drawImage((Image)oldBuffer, 0, 0, this);
        }
        this.paintablesequence.setDefaultBounds2D(new XRect(0.0, 0.0, width, height));
        this.refreshComponent();
    }

    public final int getBufferWidth() {
        return this.bufferwidth;
    }

    public final int getBufferHeight() {
        return this.bufferheight;
    }

    public final synchronized BufferedImage makeSnapshot() {
        BufferedImage snapshot = new BufferedImage(this.bufferwidth, this.bufferheight, 1);
        Graphics2D g = snapshot.createGraphics();
        g.drawImage((Image)this.buffer, 0, 0, this);
        this.paintablesequence.paint(g);
        this.paintOver(g);
        return snapshot;
    }

    public final DisplayPanel getInnerPanel() {
        this.makePainterPanelIfNeeded();
        return this.painter;
    }

    public final void quickRepaint() {
        DisplayPanel panel = this.getInnerPanel();
        Graphics graphics = panel.getGraphics();
        if (graphics == null) {
            return;
        }
        panel.paint(graphics);
    }

    public final void fillPanel(Paint fill) {
        if (fill == null) {
            return;
        }
        Graphics2D g2 = this.getBufferGraphics();
        g2.setPaint(fill);
        g2.fillRect(0, 0, this.getBufferWidth(), this.getBufferHeight());
    }

    public final void clearPanel() {
        this.fillPanel(this.getBufferBackground());
    }

    public final Paintable[] clearSequence() {
        return this.paintablesequence.clearSequence();
    }

    public final Paintable[] clearPanelAndSequence() {
        this.clearPanel();
        return this.paintablesequence.clearSequence();
    }

    public final Paintable[] clearSequenceData() {
        return this.paintablesequence.clearEverything();
    }

    public final Paintable[] clearPanelAndSequenceData() {
        this.clearPanel();
        return this.paintablesequence.clearEverything();
    }

    public final void setBufferBackground(Paint background) {
        if (background == null) {
            return;
        }
        this.bufferBackground = background;
    }

    public final Paint getBufferBackground() {
        return this.bufferBackground;
    }

    public final void setSequenceBackgroundPaint(Paint background) {
        this.paintablesequence.setBackgroundPaint(background);
    }

    public final Paint getSequenceBackgroundPaint() {
        return this.paintablesequence.getBackgroundPaint();
    }

    public final void clearSequenceBackgroundPaint() {
        this.paintablesequence.clearBackgroundPaint();
    }

    public final void setSequenceBackgroundTile(Object object) {
        this.paintablesequence.setBackgroundTile(object);
    }

    public final Paintable getSequenceBackgroundTile() {
        return this.paintablesequence.getBackgroundTile();
    }

    public final void clearSequenceBackgroundTile() {
        this.paintablesequence.clearBackgroundTile();
    }

    public final void clearBothSequenceBackgrounds() {
        this.paintablesequence.clearBothBackgrounds();
    }

    public void drawGrid(int pixels) {
        this.drawGrid(pixels, null);
    }

    public void drawGrid(int pixels, Color color) {
        if (pixels <= 0) {
            return;
        }
        if (color == null) {
            color = Colors.lightgray;
        }
        Graphics2D g = this.getBufferGraphics();
        Paint oldPaint = g.getPaint();
        g.setPaint(color);
        XLine2D line = new XLine2D();
        int w = this.getBufferWidth();
        int h = this.getBufferHeight();
        int x = pixels;
        while (x < w) {
            line.setValue(x, 0.0, x, h);
            g.draw(line);
            x += pixels;
        }
        int y = pixels;
        while (y < h) {
            line.setValue(0.0, y, w, y);
            g.draw(line);
            y += pixels;
        }
        g.setPaint(oldPaint);
    }

    public final void setBackground(Color background) {
        if (this.painter != null) {
            this.painter.setBackground(background);
        }
        super.setBackground(background);
    }

    public final void setMouseActionAdapter(MouseActionAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.painter.removeMouseListener(this.mouseActions);
        this.painter.removeMouseMotionListener(this.mouseActions);
        this.mouseActions = adapter;
        this.painter.addMouseListener(this.mouseActions);
        this.painter.addMouseMotionListener(this.mouseActions);
    }

    public final MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActions;
    }

    public final void setKeyActionAdapter(KeyActionAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.painter.removeKeyListener(this.keyActions);
        this.keyActions = adapter;
        this.painter.addKeyListener(this.keyActions);
    }

    public final KeyActionAdapter getKeyActionAdapter() {
        return this.keyActions;
    }

    public final void setFocusable(boolean focusable) {
        this.getInnerPanel().setFocusable(focusable);
    }

    public final boolean isFocusable() {
        return this.getInnerPanel().isFocusable();
    }

    public final boolean isRequestFocusEnabled() {
        return this.getInnerPanel().isRequestFocusEnabled();
    }

    public final void requestFocus() {
        this.getInnerPanel().requestFocus();
    }

    public final boolean requestFocusInWindow() {
        return this.getInnerPanel().requestFocusInWindow();
    }

    public final PaintableSequence getPaintableSequence() {
        return this.paintablesequence;
    }

    public final Paintable setPaintable(int index, Object o) {
        return this.paintablesequence.setPaintable(index, o);
    }

    public final Paintable setPaintable(Object o, int index) {
        return this.paintablesequence.setPaintable(o, index);
    }

    public final Paintable getPaintable(int index) {
        return this.paintablesequence.getPaintable(index);
    }

    public final int getIndex(Paintable paintable) {
        return this.paintablesequence.getIndex(paintable);
    }

    public final Paintable addPaintable(int index, Object o) {
        return this.paintablesequence.addPaintable(index, o);
    }

    public final Paintable addPaintable(Object o, int index) {
        return this.paintablesequence.addPaintable(o, index);
    }

    public final Paintable addPaintable(Object o) {
        return this.paintablesequence.addPaintable(o);
    }

    public final Paintable addPaintableAtTop(Object o) {
        return this.paintablesequence.addPaintableAtTop(o);
    }

    public final Paintable appendPaintable(Object o) {
        return this.paintablesequence.appendPaintable(o);
    }

    public final Paintable[] setSequence(Object[] objects) {
        return this.paintablesequence.setSequence(objects);
    }

    public final Paintable[] addSequence(int index, Object[] objects) {
        return this.paintablesequence.addSequence(index, objects);
    }

    public final Paintable[] addSequence(Object[] objects, int index) {
        return this.paintablesequence.addSequence(objects, index);
    }

    public final Paintable[] addSequence(Object[] objects) {
        return this.paintablesequence.addSequence(objects);
    }

    public final Paintable[] addSequenceAtTop(Object[] objects) {
        return this.paintablesequence.addSequenceAtTop(objects);
    }

    public final Paintable[] appendSequence(Object[] objects) {
        return this.paintablesequence.appendSequence(objects);
    }

    public final Paintable removePaintable(int index) {
        return this.paintablesequence.removePaintable(index);
    }

    public final void removePaintable(Paintable paintable) {
        this.paintablesequence.removePaintable(paintable);
    }

    public final Paintable[] removeSequence(int m, int n) {
        return this.paintablesequence.removeSequence(m, n);
    }

    public void paintOver(Graphics2D g2) {
    }

    protected void SMA_Moved(MouseEvent evt) {
        if (this.mouseIsInPanel) {
            this.setMousePosition(evt);
        }
    }

    protected void SMA_Pressed(MouseEvent evt) {
        this.mouseIsInPanel = true;
        this.setMousePosition(evt);
        int newX = this.mouseX;
        int newY = this.mouseY;
        this.currentPaintable = this.paintablesequence != null ? this.paintablesequence.hits(newX, newY) : null;
        if (this.currentPaintable != null && this.autoShiftToTop) {
            this.paintablesequence.shiftPaintableToTop(this.currentPaintable);
            this.repaint();
        }
    }

    protected void SMA_Released(MouseEvent evt) {
    }

    protected void SMA_Clicked(MouseEvent evt) {
    }

    protected void SMA_Dragged(MouseEvent evt) {
        int oldX = this.mouseX;
        int oldY = this.mouseY;
        if (this.mouseIsInPanel) {
            this.setMousePosition(evt);
        }
        int newX = this.mouseX;
        int newY = this.mouseY;
        if (this.currentPaintable != null && (newX != oldX || newY != oldY)) {
            int dx = newX - oldX;
            int dy = newY - oldY;
            this.currentPaintable.move(dx, dy);
            this.repaint();
        }
    }

    protected void SMA_Entered(MouseEvent evt) {
        this.mouseIsInPanel = true;
    }

    protected void SMA_Exited(MouseEvent evt) {
        this.mouseIsInPanel = false;
    }

    public final int getMouseX() {
        return this.mouseX;
    }

    public final int getMouseY() {
        return this.mouseY;
    }

    public final void setMousePosition(MouseEvent evt) {
        if (evt == null) {
            return;
        }
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
    }

    public final void setAutoShiftToTop(boolean shift) {
        this.autoShiftToTop = shift;
    }

    public final boolean getAutoShiftToTop() {
        return this.autoShiftToTop;
    }

    public void installSimpleMouseActions() {
        this.uninstallAllMouseActions();
        this.mouseActions.addMouseMovedAction(this.SMA_Moved_Action);
        this.mouseActions.addMousePressedAction(this.SMA_Pressed_Action);
        this.mouseActions.addMouseReleasedAction(this.SMA_Released_Action);
        this.mouseActions.addMouseClickedAction(this.SMA_Clicked_Action);
        this.mouseActions.addMouseDraggedAction(this.SMA_Dragged_Action);
        this.mouseActions.addMouseEnteredAction(this.SMA_Entered_Action);
        this.mouseActions.addMouseExitedAction(this.SMA_Exited_Action);
    }

    public void installSimpleMouseActions(boolean shift) {
        this.installSimpleMouseActions();
        this.setAutoShiftToTop(shift);
    }

    public final void uninstallAllMouseActions() {
        this.mouseActions.uninstallAllMouseActions();
    }

    public final void uninstallAllKeyActions() {
        this.keyActions.uninstallAllKeyActions();
    }

    protected static class Painter
    extends DisplayPanel {
        protected BufferedPanel panel = null;

        protected Painter(BufferedPanel panel) {
            this.panel = panel;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.panel.getBufferWidth(), this.panel.getBufferHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics g) {
            BufferedPanel bufferedPanel = this.panel;
            synchronized (bufferedPanel) {
                Insets in = this.getInsets();
                int x = in.left;
                int y = in.top;
                g.drawImage(this.panel.getBuffer(), x, y, this);
                g.translate(x, y);
                this.panel.paintablesequence.paint(g);
                g.translate(-x, -y);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            BufferedPanel bufferedPanel = this.panel;
            synchronized (bufferedPanel) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                Insets in = this.getInsets();
                int x = in.left;
                int y = in.top;
                g2.translate(x, y);
                this.panel.paintOver(g2);
                g2.translate(-x, -y);
            }
        }
    }
}

