/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class Borders {
    public static final int LEFT = 1;
    public static final int RIGHT = 3;
    public static final int CENTER = 2;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    public static final int H_DEFAULT = 2;
    public static final int TOP = 2;
    public static final int ABOVE_TOP = 1;
    public static final int BELOW_TOP = 3;
    public static final int BOTTOM = 5;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BELOW_BOTTOM = 6;
    public static final int V_DEFAULT = 2;
    public static final Border DEFAULT_LINE_BORDER = Borders.line(Color.black, 2);

    private Borders() {
    }

    public static Border empty() {
        return Borders.empty(0, 0, 0, 0);
    }

    public static Border empty(int thickness) {
        return Borders.empty(thickness, thickness, thickness, thickness);
    }

    public static Border empty(int vgap, int hgap) {
        return Borders.empty(vgap, hgap, vgap, hgap);
    }

    public static Border empty(int top, int left, int bottom, int right) {
        return BorderFactory.createEmptyBorder(top, left, bottom, right);
    }

    public static Border matte(int thickness, Color color) {
        return Borders.matte(thickness, thickness, thickness, thickness, color);
    }

    public static Border matte(int vgap, int hgap, Color color) {
        return Borders.matte(vgap, hgap, vgap, hgap, color);
    }

    public static Border matte(int top, int left, int bottom, int right, Color color) {
        if (color == null) {
            color = Color.black;
        }
        return BorderFactory.createMatteBorder(top, left, bottom, right, color);
    }

    public static Border matte(int thickness, Icon tileicon) {
        return Borders.matte(thickness, thickness, thickness, thickness, tileicon);
    }

    public static Border matte(int vgap, int hgap, Icon tileicon) {
        return Borders.matte(vgap, hgap, vgap, hgap, tileicon);
    }

    public static Border matte(int top, int left, int bottom, int right, Icon tileicon) {
        if (tileicon != null) {
            return BorderFactory.createMatteBorder(top, left, bottom, right, tileicon);
        }
        return BorderFactory.createMatteBorder(top, left, bottom, right, Color.black);
    }

    public static Border line() {
        return Borders.line(Color.black, 1);
    }

    public static Border line(Color color) {
        return Borders.line(color, 1);
    }

    public static Border line(int thickness) {
        return Borders.line(Color.black, thickness);
    }

    public static Border line(Color color, int thickness) {
        if (color == null) {
            color = Color.black;
        }
        return BorderFactory.createLineBorder(color, thickness);
    }

    public static Border etchLowered() {
        return BorderFactory.createEtchedBorder(1);
    }

    public static Border etchLowered(Color highlight, Color shadow) {
        return Borders.etchLowered(1, highlight, shadow);
    }

    public static Border etchLowered(int levels, Color highlight, Color shadow) {
        boolean error;
        boolean bl = error = levels <= 0 || highlight == null || shadow == null;
        if (error) {
            return Borders.etchLowered();
        }
        CompoundBorder border = null;
        MatteBorder highNW = BorderFactory.createMatteBorder(1, 1, 0, 0, highlight);
        MatteBorder shadNW = BorderFactory.createMatteBorder(1, 1, 0, 0, shadow);
        MatteBorder highSE = BorderFactory.createMatteBorder(0, 0, 1, 1, highlight);
        MatteBorder shadSE = BorderFactory.createMatteBorder(0, 0, 1, 1, shadow);
        int i = 0;
        while (i < levels) {
            border = BorderFactory.createCompoundBorder(highNW, border);
            border = BorderFactory.createCompoundBorder(shadSE, border);
            ++i;
        }
        i = 0;
        while (i < levels) {
            border = BorderFactory.createCompoundBorder(shadNW, border);
            border = BorderFactory.createCompoundBorder(highSE, border);
            ++i;
        }
        return border;
    }

    public static Border etchRaised() {
        return BorderFactory.createEtchedBorder(0);
    }

    public static Border etchRaised(Color highlight, Color shadow) {
        return Borders.etchRaised(1, highlight, shadow);
    }

    public static Border etchRaised(int levels, Color highlight, Color shadow) {
        boolean error;
        boolean bl = error = levels <= 0 || highlight == null || shadow == null;
        if (error) {
            return Borders.etchRaised();
        }
        return Borders.etchLowered(levels, shadow, highlight);
    }

    public static Border bevelLowered() {
        return BorderFactory.createBevelBorder(1);
    }

    public static Border bevelLowered(Color highlight, Color shadow) {
        return Borders.bevelLowered(2, highlight, shadow);
    }

    public static Border bevelLowered(Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        return Borders.bevelLowered(2, highlightOuter, highlightInner, shadowInner, shadowOuter);
    }

    public static Border bevelLowered(int levels, Color highlight, Color shadow) {
        boolean error;
        boolean bl = error = levels <= 0 || highlight == null || shadow == null;
        if (error) {
            return Borders.bevelLowered();
        }
        CompoundBorder border = null;
        MatteBorder shadNW = BorderFactory.createMatteBorder(1, 1, 0, 0, shadow);
        MatteBorder highSE = BorderFactory.createMatteBorder(0, 0, 1, 1, highlight);
        int i = 0;
        while (i < levels) {
            border = BorderFactory.createCompoundBorder(shadNW, border);
            border = BorderFactory.createCompoundBorder(highSE, border);
            ++i;
        }
        return border;
    }

    public static Border bevelLowered(int levels, Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        boolean error;
        boolean bl = error = levels <= 1 || highlightOuter == null || highlightInner == null || shadowInner == null || shadowOuter == null;
        if (error) {
            return Borders.bevelLowered();
        }
        CompoundBorder border = null;
        Color[] high = new Color[levels];
        Color[] shad = new Color[levels];
        int N = levels - 1;
        high[0] = highlightInner;
        high[N] = highlightOuter;
        shad[0] = shadowInner;
        shad[N] = shadowOuter;
        if (N >= 2) {
            int hr0 = high[0].getRed();
            int hg0 = high[0].getGreen();
            int hb0 = high[0].getBlue();
            int ha0 = high[0].getAlpha();
            int hrN = high[N].getRed();
            int hgN = high[N].getGreen();
            int hbN = high[N].getBlue();
            int haN = high[N].getAlpha();
            int sr0 = shad[0].getRed();
            int sg0 = shad[0].getGreen();
            int sb0 = shad[0].getBlue();
            int sa0 = shad[0].getAlpha();
            int srN = shad[N].getRed();
            int sgN = shad[N].getGreen();
            int sbN = shad[N].getBlue();
            int saN = shad[N].getAlpha();
            int i = 1;
            while (i < N) {
                int r = (hr0 * (N - i) + hrN * i) / N;
                int g = (hg0 * (N - i) + hgN * i) / N;
                int b = (hb0 * (N - i) + hbN * i) / N;
                int a = (ha0 * (N - i) + haN * i) / N;
                high[i] = new Color(r, g, b, a);
                r = (sr0 * (N - i) + srN * i) / N;
                g = (sg0 * (N - i) + sgN * i) / N;
                b = (sb0 * (N - i) + sbN * i) / N;
                a = (sa0 * (N - i) + saN * i) / N;
                shad[i] = new Color(r, g, b, a);
                ++i;
            }
        }
        int i = 0;
        while (i <= N) {
            MatteBorder shadNW = BorderFactory.createMatteBorder(1, 1, 0, 0, shad[i]);
            MatteBorder highSE = BorderFactory.createMatteBorder(0, 0, 1, 1, high[i]);
            border = BorderFactory.createCompoundBorder(shadNW, border);
            border = BorderFactory.createCompoundBorder(highSE, border);
            ++i;
        }
        return border;
    }

    public static Border bevelRaised() {
        return BorderFactory.createBevelBorder(0);
    }

    public static Border bevelRaised(Color highlight, Color shadow) {
        return Borders.bevelRaised(2, highlight, shadow);
    }

    public static Border bevelRaised(Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        return Borders.bevelRaised(2, highlightOuter, highlightInner, shadowInner, shadowOuter);
    }

    public static Border bevelRaised(int levels, Color highlight, Color shadow) {
        boolean error;
        boolean bl = error = levels <= 0 || highlight == null || shadow == null;
        if (error) {
            return Borders.bevelRaised();
        }
        return Borders.bevelLowered(levels, shadow, highlight);
    }

    public static Border bevelRaised(int levels, Color highlightOuter, Color highlightInner, Color shadowInner, Color shadowOuter) {
        boolean error;
        boolean bl = error = levels <= 1 || highlightOuter == null || highlightInner == null || shadowInner == null || shadowOuter == null;
        if (error) {
            return Borders.bevelRaised();
        }
        return Borders.bevelLowered(levels, shadowOuter, shadowInner, highlightInner, highlightOuter);
    }

    public static TitledBorder title(String t) {
        return Borders.title(t, 2, 2, null, null, null);
    }

    public static TitledBorder title(String t, Border base) {
        return Borders.title(t, 2, 2, base, null, null);
    }

    public static TitledBorder title(String t, Font font, Color fontcolor) {
        return Borders.title(t, 2, 2, null, font, fontcolor);
    }

    public static TitledBorder title(String t, Border base, Font font, Color fontcolor) {
        return Borders.title(t, 2, 2, base, font, fontcolor);
    }

    public static TitledBorder title(String t, int hPosition, int vPosition) {
        return Borders.title(t, hPosition, vPosition, null, null, null);
    }

    public static TitledBorder title(String t, int hPosition, int vPosition, Border base) {
        return Borders.title(t, hPosition, vPosition, base, null, null);
    }

    public static TitledBorder title(String t, int hPosition, int vPosition, Font font, Color fontcolor) {
        return Borders.title(t, hPosition, vPosition, null, font, fontcolor);
    }

    public static TitledBorder title(String t, int hPosition, int vPosition, Border base, Font font, Color fontcolor) {
        if (t == null) {
            t = "";
        }
        TitledBorder titled = new TitledBorder(t);
        switch (hPosition) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                hPosition = 2;
            }
        }
        switch (vPosition) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                vPosition = 2;
            }
        }
        titled.setTitleJustification(hPosition);
        titled.setTitlePosition(vPosition);
        if (base == null) {
            base = DEFAULT_LINE_BORDER;
        }
        titled.setBorder(base);
        if (font != null) {
            titled.setTitleFont(font);
        }
        if (fontcolor != null) {
            titled.setTitleColor(fontcolor);
        }
        return titled;
    }

    public static Border compound(Border outer, Border inner) {
        if (outer == null) {
            return inner;
        }
        if (inner == null) {
            return outer;
        }
        return BorderFactory.createCompoundBorder(outer, inner);
    }

    public static Border compound(Border[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        int N = length - 1;
        Border border = null;
        int i = N;
        while (i >= 0) {
            border = Borders.compound(array[i], border);
            --i;
        }
        return border;
    }

    public static Border sandwich(Border center, Border wrap) {
        return Borders.compound(wrap, Borders.compound(center, wrap));
    }
}

