/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.util.FloatArray;

public class BaseVertexShape
extends BaseShape {
    public static final String SET_VERTEX = "set.vertex";
    public static final String ADD_VERTEX = "add.vertex";
    public static final String REMOVE_VERTEX = "remove.vertex";

    protected BaseVertexShape() {
    }

    public final void setVertexData(float[][] vertex) {
        if (vertex == null) {
            this.vertex = new float[0][2];
        } else {
            if (!FloatArray.checkArray(vertex, 2)) {
                return;
            }
            this.vertex = FloatArray.deepclone(vertex);
        }
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setVertex(int index, float x, float y) {
        if (index < 0 || index >= this.vertex.length) {
            return;
        }
        this.vertex[index][0] = x;
        this.vertex[index][1] = y;
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setVertex(int index, float[] point) {
        if (point == null || point.length != 2) {
            return;
        }
        this.setVertex(index, point[0], point[1]);
    }

    public final void addVertex(int index, float x, float y) {
        int N = this.vertex.length;
        int M = N + 1;
        if (index < 0) {
            index = 0;
        } else if (index > N) {
            index = N;
        }
        float[][] oldvertex = this.vertex;
        this.vertex = new float[M][2];
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            ++i;
        }
        this.vertex[index][0] = x;
        this.vertex[index][1] = y;
        i = index + 1;
        while (i < M) {
            int j = i - 1;
            this.vertex[i][0] = oldvertex[j][0];
            this.vertex[i][1] = oldvertex[j][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX, null, null);
    }

    public final void addVertex(int index, float[] point) {
        if (point == null || point.length != 2) {
            return;
        }
        this.addVertex(index, point[0], point[1]);
    }

    public final void addVertices(int index, float[][] points) {
        int j;
        if (!FloatArray.checkArray(points, 2)) {
            return;
        }
        int K = points.length;
        if (K == 0) {
            return;
        }
        int N = this.vertex.length;
        int M = N + K;
        float[][] oldvertex = this.vertex;
        this.vertex = new float[M][2];
        if (index < 0) {
            index = 0;
        } else if (index > N) {
            index = N;
        }
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            ++i;
        }
        i = 0;
        while (i < K) {
            j = i + index;
            this.vertex[j][0] = points[i][0];
            this.vertex[j][1] = points[i][1];
            ++i;
        }
        i = index;
        while (i < N) {
            j = i + K;
            this.vertex[j][0] = oldvertex[i][0];
            this.vertex[j][1] = oldvertex[i][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX, null, null);
    }

    public final void appendVertex(float x, float y) {
        this.addVertex(this.vertex.length, x, y);
    }

    public final void appendVertex(float[] point) {
        this.addVertex(this.vertex.length, point);
    }

    public final void appendVertices(int index, float[][] points) {
        this.addVertices(this.vertex.length, points);
    }

    public final float[] removeVertex(int index) {
        int N = this.vertex.length;
        int M = N - 1;
        if (index < 0 || index >= N) {
            return null;
        }
        float[][] oldvertex = this.vertex;
        this.vertex = new float[M][2];
        int i = 0;
        while (i < index) {
            this.vertex[i][0] = oldvertex[i][0];
            this.vertex[i][1] = oldvertex[i][1];
            ++i;
        }
        i = index + 1;
        while (i < N) {
            int j = i - 1;
            this.vertex[j][0] = oldvertex[i][0];
            this.vertex[j][1] = oldvertex[i][1];
            ++i;
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX, null, null);
        return oldvertex[index];
    }

    public final float[][] removeVertices(int m, int n) {
        int K;
        int N = this.vertex.length;
        if (m < 0) {
            m = 0;
        }
        if (n > N) {
            n = N;
        }
        if ((K = n - m) <= 0) {
            return new float[0][2];
        }
        int M = N - K;
        float[][] oldvertex = this.vertex;
        this.vertex = new float[M][2];
        float[][] result = null;
        if (M == 0) {
            result = oldvertex;
        } else {
            int j;
            result = new float[K][2];
            int i = 0;
            while (i < m) {
                this.vertex[i][0] = oldvertex[i][0];
                this.vertex[i][1] = oldvertex[i][1];
                ++i;
            }
            i = m;
            while (i < n) {
                j = i - m;
                result[j][0] = oldvertex[i][0];
                result[j][1] = oldvertex[i][1];
                ++i;
            }
            i = n;
            while (i < N) {
                j = i - K;
                this.vertex[j][0] = oldvertex[i][0];
                this.vertex[j][1] = oldvertex[i][1];
                ++i;
            }
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX, null, null);
        return result;
    }

    public final float[][] removeAllVertices() {
        return this.removeVertices(0, this.vertex.length);
    }
}

