/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.PolygonDotsShape;
import edu.neu.ccs.gui.PolygonShape;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.SupportsPropertyChange;
import edu.neu.ccs.gui.TweakableShape;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.Bezier;
import edu.neu.ccs.util.FloatArray;
import edu.neu.ccs.util.Metric;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class BaseShape
implements Shape,
SupportsPropertyChange {
    public static final String SET_PATH_STRATEGY = "set.path.strategy";
    public static final String SET_CLOSURE_MODE = "set.closure.mode";
    public static final String SET_WINDING_RULE = "set.winding.rule";
    public static final String REMOVE_SHAPE_DATA = "remove.shape.data";
    protected float[][] vertex = new float[0][2];
    protected float[][] tangent = null;
    private GeneralPath path = new GeneralPath(1);
    private Path.Strategy pathstrategy = Path.POLYGON;
    private ClosureMode closuremode = ClosureMode.CLOSED;
    private WindingRule windingrule = WindingRule.WIND_NON_ZERO;
    private final PropertyChangeSupport changeAdapter = new PropertyChangeSupport(this);
    private final PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);

    protected BaseShape() {
    }

    public final int length() {
        return this.vertex.length;
    }

    public final boolean isTangentNull() {
        return this.tangent == null;
    }

    public final float getVX(int index) {
        int N = this.vertex.length;
        if (index < 0 || index >= N) {
            return 0.0f;
        }
        return this.vertex[index][0];
    }

    public final float getVY(int index) {
        int N = this.vertex.length;
        if (index < 0 || index >= N) {
            return 0.0f;
        }
        return this.vertex[index][1];
    }

    public final float[] getVertex(int index) {
        return new float[]{this.getVX(index), this.getVY(index)};
    }

    public final float getTX(int index) {
        if (this.tangent == null) {
            return 0.0f;
        }
        int N = this.vertex.length;
        if (index < 0 || index >= N) {
            return 0.0f;
        }
        return this.tangent[index][0];
    }

    public final float getTY(int index) {
        if (this.tangent == null) {
            return 0.0f;
        }
        int N = this.vertex.length;
        if (index < 0 || index >= N) {
            return 0.0f;
        }
        return this.tangent[index][1];
    }

    public final float[] getTangent(int index) {
        return new float[]{this.getTX(index), this.getTY(index)};
    }

    public final float getAX(int index) {
        return this.getVX(index) + this.getTX(index);
    }

    public final float getAY(int index) {
        return this.getVY(index) + this.getTY(index);
    }

    public final float[] getControlA(int index) {
        return new float[]{this.getAX(index), this.getAY(index)};
    }

    public final float getBX(int index) {
        return this.getVX(index) - this.getTX(index);
    }

    public final float getBY(int index) {
        return this.getVY(index) - this.getTY(index);
    }

    public final float[] getControlB(int index) {
        return new float[]{this.getBX(index), this.getBY(index)};
    }

    public final float[] getVertexTangent(int index) {
        return new float[]{this.getVX(index), this.getVY(index), this.getTX(index), this.getTY(index)};
    }

    public final float[][] getVertexData() {
        int N = this.vertex.length;
        float[][] result = new float[N][];
        int i = 0;
        while (i < N) {
            result[i] = this.getVertex(i);
            ++i;
        }
        return result;
    }

    public final float[][] getTangentData() {
        int N = this.vertex.length;
        float[][] result = new float[N][];
        int i = 0;
        while (i < N) {
            result[i] = this.getTangent(i);
            ++i;
        }
        return result;
    }

    public final float[][] getVertexTangentData() {
        int N = this.vertex.length;
        float[][] result = new float[N][];
        int i = 0;
        while (i < N) {
            result[i] = this.getVertexTangent(i);
            ++i;
        }
        return result;
    }

    public final float[] getPolygonPoint(float t) {
        int N = this.vertex.length;
        if (N == 0) {
            return new float[2];
        }
        if (N == 1 || t <= 0.0f || t >= (float)N) {
            return this.getVertex(0);
        }
        int a = (int)t;
        float f = t - (float)a;
        if (f == 0.0f) {
            return this.getVertex(a);
        }
        int b = (a + 1) % N;
        float x0 = this.getVX(a);
        float x1 = this.getVX(b);
        float y0 = this.getVY(a);
        float y1 = this.getVY(b);
        return new float[]{Bezier.bezierF(f, x0, x1), Bezier.bezierF(f, y0, y1)};
    }

    public final float[] getCubicCurvePoint(float t) {
        int N = this.vertex.length;
        if (N == 0) {
            return new float[2];
        }
        if (N == 1 || t <= 0.0f || t >= (float)N) {
            return this.getVertex(0);
        }
        int a = (int)t;
        float f = t - (float)a;
        if (f == 0.0f) {
            return this.getVertex(a);
        }
        int b = (a + 1) % N;
        float x0 = this.getVX(a);
        float x3 = this.getVX(b);
        float x1 = x0 + this.getTX(a);
        float x2 = x3 - this.getTX(b);
        float y0 = this.getVY(a);
        float y3 = this.getVY(b);
        float y1 = y0 + this.getTY(a);
        float y2 = y3 - this.getTY(b);
        return new float[]{Bezier.bezierF(f, x0, x1, x2, x3), Bezier.bezierF(f, y0, y1, y2, y3)};
    }

    public final int findVertex(double x, double y, double epsilon) {
        return this.findVertex(x, y, epsilon, Metric.MAX);
    }

    public final int findVertex(double x, double y, double epsilon, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int N = this.vertex.length;
        int i = 0;
        while (i < N) {
            if (metric.isNear(x, y, this.getVX(i), this.getVY(i), epsilon)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int findControlA(double x, double y, double epsilon) {
        return this.findControlA(x, y, epsilon, Metric.MAX);
    }

    public final int findControlA(double x, double y, double epsilon, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int N = this.vertex.length;
        int i = 0;
        while (i < N) {
            if (metric.isNear(x, y, this.getAX(i), this.getAY(i), epsilon)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int findControlB(double x, double y, double epsilon) {
        return this.findControlB(x, y, epsilon, Metric.MAX);
    }

    public final int findControlB(double x, double y, double epsilon, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int N = this.vertex.length;
        int i = 0;
        while (i < N) {
            if (metric.isNear(x, y, this.getBX(i), this.getBY(i), epsilon)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPathStrategy(Path.Strategy pathstrategy) {
        if (pathstrategy == null || pathstrategy == this.pathstrategy) {
            return;
        }
        this.pathstrategy = pathstrategy;
        this.makePath();
        this.firePropertyChange(SET_PATH_STRATEGY, null, null);
    }

    public final Path.Strategy getPathStrategy() {
        return this.pathstrategy;
    }

    public final void setClosureMode(ClosureMode closuremode) {
        if (closuremode == null || closuremode == this.closuremode) {
            return;
        }
        this.closuremode = closuremode;
        this.makePath();
        this.firePropertyChange(SET_CLOSURE_MODE, null, null);
    }

    public final ClosureMode getClosureMode() {
        return this.closuremode;
    }

    public final void setWindingRule(WindingRule windingrule) {
        if (windingrule == null || windingrule == this.windingrule) {
            return;
        }
        this.windingrule = windingrule;
        this.makePath();
        this.firePropertyChange(SET_WINDING_RULE, null, null);
    }

    public final void setWindingRule(int rule) {
        if (rule == 1) {
            this.setWindingRule(WindingRule.WIND_NON_ZERO);
        } else if (rule == 0) {
            this.setWindingRule(WindingRule.WIND_EVEN_ODD);
        }
    }

    public final WindingRule getWindingRule() {
        return this.windingrule;
    }

    public final void removeShapeData() {
        this.vertex = new float[0][2];
        if (this.tangent != null) {
            this.tangent = new float[0][2];
        }
        this.makePath();
        this.firePropertyChange(REMOVE_SHAPE_DATA, null, null);
    }

    public final GeneralPath getPath() {
        return this.pathstrategy.makePath(this.vertex, this.tangent, this.closuremode, this.windingrule);
    }

    protected void makePath() {
        this.path = this.getPath();
    }

    public final PolygonShape makeClosedPolygon() {
        return new PolygonShape(this.getVertexData(), ClosureMode.CLOSED, this.getWindingRule());
    }

    public final PolygonShape makeOpenPolygon() {
        return new PolygonShape(this.getVertexData(), ClosureMode.OPEN, this.getWindingRule());
    }

    public final PolygonDotsShape makePolygonDots() {
        return new PolygonDotsShape(this.getVertexData());
    }

    public final PolygonShape makeClosedBezierFrame() {
        return new PolygonShape(this.getClosedBezierFrameData(), ClosureMode.CLOSED, this.getWindingRule());
    }

    public final PolygonShape makeOpenBezierFrame() {
        return new PolygonShape(this.getOpenBezierFrameData(), ClosureMode.OPEN, this.getWindingRule());
    }

    public final PolygonDotsShape makeClosedControlDots() {
        return new PolygonDotsShape(this.getClosedBezierControlData());
    }

    public final PolygonDotsShape makeOpenControlDots() {
        return new PolygonDotsShape(this.getOpenBezierControlData());
    }

    public final TweakableShape makeBezierTangentSegments() {
        return new TweakableShape(this.getVertexData(), this.getTangentData(), Path.BEZIER_TANGENT_SEGMENTS, ClosureMode.OPEN, this.getWindingRule());
    }

    public final float[][] getClosedBezierFrameData() {
        int N = this.vertex.length;
        int M = 3 * N;
        float[][] result = new float[M][];
        int i = 0;
        while (i < N) {
            int j = (i + 1) % N;
            int r = 3 * i;
            int s = r + 1;
            int t = s + 1;
            result[r] = this.getVertex(i);
            result[s] = this.getControlA(i);
            result[t] = this.getControlB(j);
            ++i;
        }
        return result;
    }

    public final float[][] getOpenBezierFrameData() {
        int N = this.vertex.length;
        if (N == 0) {
            return new float[0][2];
        }
        int L = N - 1;
        int M = 3 * N - 2;
        float[][] result = new float[M][];
        int i = 0;
        while (i < L) {
            int j = i + 1;
            int r = 3 * i;
            int s = r + 1;
            int t = s + 1;
            result[r] = this.getVertex(i);
            result[s] = this.getControlA(i);
            result[t] = this.getControlB(j);
            ++i;
        }
        result[M - 1] = this.getVertex(L);
        return result;
    }

    public final float[][] getClosedBezierControlData() {
        int N = this.vertex.length;
        int M = 2 * N;
        float[][] result = new float[M][];
        int i = 0;
        while (i < N) {
            int j = (i + 1) % N;
            int r = 2 * i;
            int s = r + 1;
            result[r] = this.getControlA(i);
            result[s] = this.getControlB(j);
            ++i;
        }
        return result;
    }

    public final float[][] getOpenBezierControlData() {
        int N = this.vertex.length;
        if (N <= 1) {
            return new float[0][2];
        }
        int L = N - 1;
        int M = 2 * N - 2;
        float[][] result = new float[M][];
        int i = 0;
        while (i < L) {
            int j = i + 1;
            int r = 3 * i;
            int s = r + 1;
            result[r] = this.getControlA(i);
            result[s] = this.getControlB(j);
            ++i;
        }
        return result;
    }

    public final float[][] getBezierTangentSegmentData() {
        int N = this.vertex.length;
        int M = 2 * N;
        float[][] result = new float[M][];
        int i = 0;
        while (i < N) {
            int r = 2 * i;
            int s = r + 1;
            result[r] = this.getControlB(i);
            result[s] = this.getControlA(i);
            ++i;
        }
        return result;
    }

    public static float[][] closedBezierFramePoints(float[][] vertex, float[][] tangent) {
        if (tangent == null ? !FloatArray.checkArray(vertex, 2) : !FloatArray.checkArrayPair(vertex, tangent, 2)) {
            return new float[0][2];
        }
        BaseShape shape = new BaseShape();
        shape.vertex = vertex;
        shape.tangent = tangent;
        return shape.getClosedBezierFrameData();
    }

    public static float[][] openBezierFramePoints(float[][] vertex, float[][] tangent) {
        if (tangent == null ? !FloatArray.checkArray(vertex, 2) : !FloatArray.checkArrayPair(vertex, tangent, 2)) {
            return new float[0][2];
        }
        BaseShape shape = new BaseShape();
        shape.vertex = vertex;
        shape.tangent = tangent;
        return shape.getOpenBezierFrameData();
    }

    public static float[][] closedBezierControlPoints(float[][] vertex, float[][] tangent) {
        if (tangent == null ? !FloatArray.checkArray(vertex, 2) : !FloatArray.checkArrayPair(vertex, tangent, 2)) {
            return new float[0][2];
        }
        BaseShape shape = new BaseShape();
        shape.vertex = vertex;
        shape.tangent = tangent;
        return shape.getClosedBezierControlData();
    }

    public static float[][] openBezierControlPoints(float[][] vertex, float[][] tangent) {
        if (tangent == null ? !FloatArray.checkArray(vertex, 2) : !FloatArray.checkArrayPair(vertex, tangent, 2)) {
            return new float[0][2];
        }
        BaseShape shape = new BaseShape();
        shape.vertex = vertex;
        shape.tangent = tangent;
        return shape.getOpenBezierControlData();
    }

    public static float[][] bezierTangentSegmentPoints(float[][] vertex, float[][] tangent) {
        if (tangent == null ? !FloatArray.checkArray(vertex, 2) : !FloatArray.checkArrayPair(vertex, tangent, 2)) {
            return new float[0][2];
        }
        BaseShape shape = new BaseShape();
        shape.vertex = vertex;
        shape.tangent = tangent;
        return shape.getBezierTangentSegmentData();
    }

    public final boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    public final boolean contains(Point2D p) {
        return this.path.contains(p);
    }

    public final boolean contains(double x, double y, double w, double h) {
        return this.path.contains(x, y, w, h);
    }

    public final boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    public final boolean intersects(double x, double y, double w, double h) {
        return this.path.intersects(x, y, w, h);
    }

    public final boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at, flatness);
    }

    public final Shape getTransformedShape(AffineTransform at) {
        GeneralPath newpath = new GeneralPath(this.windingrule.rule());
        newpath.append(this.getPathIterator(at), false);
        return newpath;
    }

    public final Shape getTransformedShape(AffineTransform at, double flatness) {
        GeneralPath newpath = new GeneralPath(this.windingrule.rule());
        newpath.append(this.getPathIterator(at, flatness), false);
        return newpath;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListeners(PropertyChangeListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            this.addPropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public void addPropertyChangeListeners(String propertyName, PropertyChangeListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            this.addPropertyChangeListener(propertyName, listeners[i]);
            ++i;
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeAdapter.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.changeAdapter.getPropertyChangeListeners(propertyName);
    }

    public final boolean hasListeners(String propertyName) {
        return this.changeAdapter.hasListeners(propertyName);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeAdapter.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public final void firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Byte(oldValue), new Byte(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, short oldValue, short newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Short(oldValue), new Short(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public final void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
        }
    }

    public final void firePropertyChange(PropertyChangeEvent evt) {
        this.changeAdapter.firePropertyChange(evt);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange spc = (SupportsPropertyChange)object;
            spc.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange spc = (SupportsPropertyChange)object;
            spc.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object oldobject, Object newobject) {
        this.removeForwardingListener(oldobject);
        this.addForwardingListener(newobject);
    }
}

