/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Strings;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Fonts;
import edu.neu.ccs.gui.LookAndFeelTools;
import edu.neu.ccs.gui.TextFieldView;
import java.awt.Font;

public class BasePane
extends DisplayPanel {
    public static final int DEFAULT_BASE_FONT_SIZE = 12;
    public static final int MINIMUM_FONT_SIZE = 8;
    protected String monospacedFontName = Fonts.getMonospacedFontFamilyName();
    protected String serifFontName = Fonts.getSerifFontFamilyName();
    protected String sansserifFontName = Fonts.getSansSerifFontFamilyName();
    protected int baseFontSize = 12;
    protected int fontSize = 12;
    protected Font fieldFont = null;
    protected Font labelFont = null;
    protected Font buttonFont = null;
    protected int smallFieldWidth = 100;
    protected int mediumFieldWidth = 200;
    protected int largeFieldWidth = 300;
    protected int gap = 6;

    public BasePane() {
        this.initializeBasePane();
    }

    public BasePane(int baseFontSize) {
        this.baseFontSize = baseFontSize;
        this.initializeBasePane();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Font getFieldFont() {
        return this.fieldFont;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Font getButtonFont() {
        return this.buttonFont;
    }

    public int getSmallFieldWidth() {
        return this.smallFieldWidth;
    }

    public int getMediumFieldWidth() {
        return this.mediumFieldWidth;
    }

    public int getLargeFieldWidth() {
        return this.largeFieldWidth;
    }

    public int getGap() {
        return this.gap;
    }

    protected void initializeBasePane() {
        this.fontSize = this.baseFontSize + (int)LookAndFeelTools.getNetFontSizeAdjustment();
        if (this.fontSize < 8) {
            this.fontSize = 8;
        }
        this.fieldFont = new Font(this.monospacedFontName, 1, this.fontSize);
        this.labelFont = new Font(this.serifFontName, 1, this.fontSize);
        this.buttonFont = new Font(this.sansserifFontName, 1, this.fontSize);
        this.smallFieldWidth = TextFieldView.getSampleWidth(this.fieldFont, Strings.suffixRepeatChar("", ' ', 20));
        this.mediumFieldWidth = 2 * this.smallFieldWidth;
        this.largeFieldWidth = 3 * this.smallFieldWidth;
    }
}

