/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseVertexShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.PolygonDotsShape;
import edu.neu.ccs.gui.Tangent;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;
import edu.neu.ccs.util.Metric;

public class AutomaticShape
extends BaseVertexShape {
    public static final String SET_TANGENT_STRATEGY = "set.tangent.strategy";
    public static final String SET_END_TANGENT = "set.end.tangent";
    private Tangent.Strategy tangentstrategy = Tangent.bezierStrategy();
    private float[][] endTangent = null;

    public AutomaticShape() {
        this(null, null, null, null, null, null);
    }

    public AutomaticShape(float[][] vertex) {
        this(vertex, null, null, null, null, null);
    }

    public AutomaticShape(float[][] vertex, float[][] endTangent) {
        this(vertex, endTangent, null, null, null, null);
    }

    public AutomaticShape(float[][] vertex, float[][] endTangent, Tangent.Strategy tangentstrategy) {
        this(vertex, endTangent, tangentstrategy, null, null, null);
    }

    public AutomaticShape(float[][] vertex, float[][] endTangent, Tangent.Strategy tangentstrategy, Path.Strategy pathstrategy) {
        this(vertex, endTangent, tangentstrategy, pathstrategy, null, null);
    }

    public AutomaticShape(float[][] vertex, float[][] endTangent, Tangent.Strategy tangentstrategy, Path.Strategy pathstrategy, ClosureMode closuremode) {
        this(vertex, endTangent, tangentstrategy, pathstrategy, closuremode, null);
    }

    public AutomaticShape(float[][] vertex, float[][] endTangent, Tangent.Strategy tangentstrategy, Path.Strategy pathstrategy, ClosureMode closuremode, WindingRule windingrule) {
        this.vertex = new float[0][2];
        if (pathstrategy == null) {
            pathstrategy = Path.BEZIER_CUBIC;
        }
        this.setTangentStrategy(tangentstrategy);
        this.setPathStrategy(pathstrategy);
        this.setClosureMode(closuremode);
        this.setWindingRule(windingrule);
        this.setEndTangentData(endTangent);
        this.setVertexData(vertex);
        this.makePath();
    }

    public final boolean isEndTangentNull() {
        return this.endTangent == null;
    }

    public final void setEndTangentData(float[][] endTangent) {
        if (endTangent == null) {
            this.endTangent = null;
        } else {
            if (!FloatArray.checkArray(endTangent, 2) || endTangent.length != 2) {
                return;
            }
            this.endTangent = FloatArray.deepclone(endTangent);
        }
        this.makePath();
        this.firePropertyChange(SET_END_TANGENT, null, null);
    }

    public final float[][] getEndTangentData() {
        return FloatArray.deepclone(this.endTangent);
    }

    public final void setEndTangent(int index, float dx, float dy) {
        if (index < 0 || index > 1) {
            return;
        }
        if (this.endTangent == null) {
            this.endTangent = new float[2][2];
        }
        this.endTangent[index][0] = dx;
        this.endTangent[index][1] = dy;
        this.makePath();
        this.firePropertyChange(SET_END_TANGENT, null, null);
    }

    public final void setEndTangent(int index, float[] delta) {
        if (delta == null || delta.length != 2) {
            return;
        }
        this.setEndTangent(index, delta[0], delta[1]);
    }

    public final float getEndTX(int index) {
        if (this.endTangent == null) {
            return 0.0f;
        }
        if (index < 0 || index > 1) {
            return 0.0f;
        }
        return this.endTangent[index][0];
    }

    public final float getEndTY(int index) {
        if (this.endTangent == null) {
            return 0.0f;
        }
        if (index < 0 || index > 1) {
            return 0.0f;
        }
        return this.endTangent[index][1];
    }

    public final float[] getEndTangent(int index) {
        if (this.endTangent == null) {
            return null;
        }
        if (index < 0 || index > 1) {
            return null;
        }
        return new float[]{this.getEndTX(index), this.getEndTY(index)};
    }

    public final void setEndTangentViaControl(int index, float x, float y) {
        if (index < 0 || index > 1) {
            return;
        }
        int N = this.vertex.length;
        if (N < 2) {
            return;
        }
        int M = N - 1;
        if (this.endTangent == null) {
            this.endTangent = new float[2][2];
        }
        if (index == 0) {
            this.endTangent[0][0] = x - this.vertex[0][0];
            this.endTangent[0][1] = y - this.vertex[0][1];
        } else {
            this.endTangent[1][0] = this.vertex[M][0] - x;
            this.endTangent[1][1] = this.vertex[M][1] - y;
        }
        this.makePath();
        this.firePropertyChange(SET_END_TANGENT, null, null);
    }

    public final void setEndTangentViaControl(int index, float[] control) {
        if (control == null || control.length != 2) {
            return;
        }
        this.setEndTangentViaControl(index, control[0], control[1]);
    }

    public final float[] getEndTangentControl(int index) {
        if (index < 0 || index > 1) {
            return null;
        }
        int N = this.vertex.length;
        if (N < 2) {
            return null;
        }
        if (this.endTangent == null) {
            return null;
        }
        if (index == 0) {
            return new float[]{this.vertex[0][0] + this.endTangent[0][0], this.vertex[0][1] + this.endTangent[0][1]};
        }
        return new float[]{this.vertex[N - 1][0] - this.endTangent[1][0], this.vertex[N - 1][1] - this.endTangent[1][1]};
    }

    public final float[][] getEndTangentControlData() {
        return new float[][]{this.getEndTangentControl(0), this.getEndTangentControl(1)};
    }

    public final int findEndTangentControl(double x, double y, double epsilon) {
        return this.findEndTangentControl(x, y, epsilon, Metric.MAX);
    }

    public final int findEndTangentControl(double x, double y, double epsilon, Metric metric) {
        float[][] p;
        int N = this.vertex.length;
        if (N < 2) {
            return -1;
        }
        if (this.endTangent == null) {
            return -1;
        }
        if (metric == null) {
            metric = Metric.MAX;
        }
        if (metric.isNear(x, y, (p = this.getEndTangentControlData())[0][0], p[0][1], epsilon)) {
            return 0;
        }
        if (metric.isNear(x, y, p[1][0], p[1][1], epsilon)) {
            return 1;
        }
        return -1;
    }

    public final PolygonDotsShape makeEndTangentControlDots() {
        return new PolygonDotsShape(this.getEndTangentControlData());
    }

    public final void setTangentStrategy(Tangent.Strategy tangentstrategy) {
        if (tangentstrategy == null || tangentstrategy == this.tangentstrategy) {
            return;
        }
        this.tangentstrategy = tangentstrategy;
        this.makePath();
        this.firePropertyChange(SET_TANGENT_STRATEGY, null, null);
    }

    public final Tangent.Strategy getTangentStrategy() {
        return this.tangentstrategy;
    }

    protected final void makePath() {
        this.tangent = this.getClosureMode() == ClosureMode.CLOSED ? this.tangentstrategy.makeTangents(this.vertex) : this.tangentstrategy.makeTangents(this.vertex, this.endTangent);
        super.makePath();
    }
}

