/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.CellPosition;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class Annotation
extends DisplayPanel {
    public static final String SET_TEXT = "set.text";
    public static final String SET_ICON = "set.icon";
    public static final String SET_DISABLED_ICON = "set.disabled.icon";
    public static final String SET_ALERT_ICON = "set.alert.icon";
    public static final String SET_FONT = "set.font";
    public static final String SET_FOREGROUND = "set.foreground";
    public static final String SET_BACKGROUND = "set.background";
    public static final String SET_OPAQUE = "set.opaque";
    public static final int DEFAULT_ALIGNMENT = 1;
    protected Color oldForeground = null;
    protected Color oldBackground = null;
    protected JLabel iconLabel = new JLabel();
    protected JTextArea textLabel = new JTextArea(){

        public boolean isFocusTraversable() {
            return this.isEditable();
        }

        public void requestFocus() {
            if (!this.isEditable()) {
                this.transferFocus();
            }
        }
    };
    protected int align = 1;
    protected Icon alertIcon = null;

    public Annotation() {
        this(null, null, 1, null);
    }

    public Annotation(String text) {
        this(text, null, 1, null);
    }

    public Annotation(String text, Font font) {
        this(text, null, 1, font);
    }

    public Annotation(Icon icon) {
        this(null, icon, 1, null);
    }

    public Annotation(String text, Icon icon, int alignment) {
        this(text, icon, 1, null);
    }

    public Annotation(String text, Icon icon, int alignment, Font font) {
        this.setLayout(new TableLayout(2, 2, 2, 2, 0));
        this.setAlignment(alignment);
        if (font == null) {
            font = this.iconLabel.getFont();
        } else {
            this.iconLabel.setFont(font);
        }
        super.setFont(font);
        super.setForeground(this.iconLabel.getForeground());
        super.setBackground(this.iconLabel.getBackground());
        this.textLabel.setFont(font);
        this.textLabel.setForeground(this.iconLabel.getForeground());
        this.textLabel.setBackground(this.iconLabel.getBackground());
        this.textLabel.setLineWrap(false);
        this.textLabel.setEditable(false);
        this.setText(text);
        this.setIcon(icon);
        this.setOpaque(false);
    }

    public static Annotation makeAnnotation(String text, Object object, int alignment) {
        Icon icon = ComponentFactory.makeIcon(object);
        return new Annotation(text, icon, alignment);
    }

    public static Annotation makeAnnotation(String text, Object object, int alignment, Font font) {
        Icon icon = ComponentFactory.makeIcon(object);
        return new Annotation(text, icon, alignment, font);
    }

    public void dataMalformed(MalformedDataEvent evt) {
        if (evt.isAlertOn()) {
            this.startAlert(evt);
        } else {
            this.endAlert(evt);
        }
    }

    public void startAlert(AlertEvent evt) {
        this.oldForeground = this.textLabel.getForeground();
        this.oldBackground = this.getBackground();
        this.setForeground(SystemColor.textHighlightText);
        this.setBackground(SystemColor.textHighlight);
        if (this.alertIcon != null) {
            this.iconLabel.setIcon(this.alertIcon);
        }
    }

    public void endAlert(AlertEvent evt) {
        this.setForeground(this.oldForeground);
        this.setBackground(this.oldBackground);
        this.setEnabled(this.isEnabled());
    }

    public void setAlignment(int alignment) {
        int oldAlignment = this.getAlignment();
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = alignment;
                break;
            }
            case -1: {
                this.align = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.removeAll();
        switch (this.align) {
            case 2: {
                this.add((Component)this.iconLabel, new CellPosition(0, 0));
                this.add((Component)this.textLabel, new CellPosition(0, 1));
                break;
            }
            case 4: {
                this.add((Component)this.textLabel, new CellPosition(0, 0));
                this.add((Component)this.iconLabel, new CellPosition(0, 1));
                break;
            }
            case 1: {
                this.add((Component)this.iconLabel, new CellPosition(0, 0));
                this.add((Component)this.textLabel, new CellPosition(1, 0));
                break;
            }
            case 3: {
                this.add((Component)this.textLabel, new CellPosition(0, 0));
                this.add((Component)this.iconLabel, new CellPosition(1, 0));
                break;
            }
            default: {
                return;
            }
        }
        this.refreshComponent();
        if (this.align != oldAlignment) {
            this.firePropertyChange("alignment", null, null);
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.iconLabel != null) {
            this.iconLabel.setOpaque(opaque);
        }
        if (this.textLabel != null) {
            this.textLabel.setOpaque(opaque);
        }
        this.firePropertyChange(SET_OPAQUE, null, null);
    }

    public void setForeground(Color foreground) {
        if (foreground == null) {
            return;
        }
        super.setForeground(foreground);
        if (this.iconLabel != null) {
            this.iconLabel.setForeground(foreground);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(foreground);
        }
        this.firePropertyChange(SET_FOREGROUND, null, null);
    }

    public void setBackground(Color background) {
        if (background == null) {
            return;
        }
        super.setBackground(background);
        if (this.iconLabel != null) {
            this.iconLabel.setBackground(background);
        }
        if (this.textLabel != null) {
            this.textLabel.setBackground(background);
        }
        this.firePropertyChange(SET_BACKGROUND, null, null);
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Annotation.getDefaultFont();
        }
        super.setFont(font);
        if (this.iconLabel != null) {
            this.iconLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        this.refreshComponent();
        this.firePropertyChange(SET_FONT, null, null);
    }

    public static Font getDefaultFont() {
        return new JLabel(" ").getFont();
    }

    public void setText(String text) {
        String oldText;
        if (this.textLabel != null && text != (oldText = this.getText())) {
            this.textLabel.setText(text);
            this.refreshComponent();
            this.firePropertyChange(SET_TEXT, null, null);
        }
    }

    public String getText() {
        if (this.textLabel != null) {
            return this.textLabel.getText();
        }
        return null;
    }

    public void setIcon(Icon icon) {
        Icon oldIcon;
        if (this.iconLabel != null && icon != (oldIcon = this.getIcon())) {
            this.iconLabel.setIcon(icon);
            this.refreshComponent();
            this.firePropertyChange(SET_ICON, null, null);
        }
    }

    public Icon getIcon() {
        if (this.iconLabel != null) {
            return this.iconLabel.getIcon();
        }
        return null;
    }

    public void setDisabledIcon(Icon icon) {
        Icon oldIcon;
        if (this.iconLabel != null && icon != (oldIcon = this.getDisabledIcon())) {
            this.iconLabel.setDisabledIcon(icon);
            this.firePropertyChange(SET_DISABLED_ICON, null, null);
        }
    }

    public Icon getDisabledIcon() {
        if (this.iconLabel != null) {
            return this.iconLabel.getDisabledIcon();
        }
        return null;
    }

    public void setAlertIcon(Icon icon) {
        Icon oldIcon = this.getAlertIcon();
        if (icon != oldIcon) {
            this.alertIcon = icon;
            this.firePropertyChange(SET_ALERT_ICON, null, null);
        }
    }

    public Icon getAlertIcon() {
        return this.alertIcon;
    }
}

