/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.PathNode;
import java.awt.Shape;

public class AlgebraicArea {
    private AlgebraicArea() {
    }

    public static double area1(double x0, double y0, double x1, double y1) {
        return (x1 - x0) * (y0 + y1) / 2.0;
    }

    public static double area2(double x0, double y0, double x1, double y1, double x2, double y2) {
        double a = (x1 - x0) * (3.0 * y0 + 2.0 * y1 + y2) + (x2 - x1) * (y0 + 2.0 * y1 + 3.0 * y2);
        return a / 6.0;
    }

    public static double area3(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double a = (x1 - x0) * (10.0 * y0 + 6.0 * y1 + 3.0 * y2 + y3) + (x2 - x1) * (4.0 * y0 + 6.0 * y1 + 6.0 * y2 + 4.0 * y3) + (x3 - x2) * (y0 + 3.0 * y1 + 6.0 * y2 + 10.0 * y3);
        return a / 20.0;
    }

    public static float area(PathList path) {
        double y0;
        double x0;
        if (path == null) {
            return 0.0f;
        }
        PathNode[] node = path.getPathNodes();
        int length = node.length;
        if (length == 0) {
            return 0.0f;
        }
        int index = 0;
        while (index < length) {
            if (node[index].getNodeType() != 4) break;
            ++index;
        }
        if (index >= length) {
            return 0.0f;
        }
        double a = 0.0;
        double[] coords = new double[6];
        double z0 = x0 = (double)node[index].getEndX();
        double w0 = y0 = (double)node[index].getEndY();
        int i = 1;
        while (i < length) {
            int type = node[i].nodeInfo(coords);
            switch (type) {
                case 0: {
                    a += AlgebraicArea.area1(x0, y0, z0, w0);
                    z0 = x0 = coords[0];
                    w0 = y0 = coords[1];
                    break;
                }
                case 1: {
                    double x1 = coords[0];
                    double y1 = coords[1];
                    a += AlgebraicArea.area1(x0, y0, x1, y1);
                    x0 = x1;
                    y0 = y1;
                    break;
                }
                case 2: {
                    double x1 = coords[0];
                    double y1 = coords[1];
                    double x2 = coords[2];
                    double y2 = coords[3];
                    a += AlgebraicArea.area2(x0, y0, x1, y1, x2, y2);
                    x0 = x2;
                    y0 = y2;
                    break;
                }
                case 3: {
                    double x1 = coords[0];
                    double y1 = coords[1];
                    double x2 = coords[2];
                    double y2 = coords[3];
                    double x3 = coords[4];
                    double y3 = coords[5];
                    a += AlgebraicArea.area3(x0, y0, x1, y1, x2, y2, x3, y3);
                    x0 = x3;
                    y0 = y3;
                    break;
                }
                case 4: {
                    a += AlgebraicArea.area1(x0, y0, z0, w0);
                    x0 = z0;
                    y0 = w0;
                    break;
                }
            }
            ++i;
        }
        return (float)(a += AlgebraicArea.area1(x0, y0, z0, w0));
    }

    public static float area(Shape shape) {
        if (shape == null) {
            return 0.0f;
        }
        return AlgebraicArea.area(new PathList(shape));
    }

    public static float absArea(PathList path) {
        return Math.abs(AlgebraicArea.area(path));
    }

    public static float absArea(Shape shape) {
        return Math.abs(AlgebraicArea.area(shape));
    }
}

