/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableTools;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.SupportsPropertyChange;
import edu.neu.ccs.gui.TransformFactory;
import edu.neu.ccs.util.MathUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractPaintable
implements Paintable {
    public static final String SET_BACKGROUND_PAINT = "set.background.paint";
    public static final String SET_BACKGROUND_TILE = "set.background.tile";
    private XRect defaultBounds2D = null;
    private XPoint2D defaultCenter = null;
    private XRect defaultOriginalBounds2D = null;
    private XPoint2D defaultOriginalCenter = null;
    private boolean visible = true;
    private float opacity = 1.0f;
    private Paint background = null;
    private Paintable backgroundTile = null;
    private AffineTransform mutator = new AffineTransform();
    private AffineTransform inverse = new AffineTransform();
    private final PropertyChangeSupport changeAdapter = new PropertyChangeSupport(this);
    private final PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);

    public void paint(Graphics g) {
        if (g == null || !this.visible) {
            return;
        }
        Graphics2D h = this.getPreparedGraphics2D(g);
        if (this.background != null || this.backgroundTile != null) {
            XRect rect = this.getBounds2D();
            if (this.background != null) {
                Paint paint = h.getPaint();
                h.setPaint(this.background);
                h.fill(rect);
                h.setPaint(paint);
            }
            if (this.backgroundTile != null) {
                this.backgroundTile.paintAsTiles(h, rect);
            }
        }
        h.transform(this.mutator);
        this.originalPaint(h);
        h.transform(this.inverse);
    }

    public final void paintAt(Graphics g, double x, double y) {
        if (g == null) {
            return;
        }
        Graphics2D h = (Graphics2D)g;
        h.translate(x, y);
        this.paint(h);
        h.translate(-x, -y);
    }

    public final void paintAt(Graphics g, Point2D p) {
        if (p == null) {
            return;
        }
        this.paintAt(g, p.getX(), p.getY());
    }

    public final void paintAt(Graphics g, AffineTransform T, double x, double y) {
        if (T == null || T.isIdentity()) {
            this.paintAt(g, x, y);
            return;
        }
        Point2D.Double p = new Point2D.Double(x, y);
        T.transform(p, p);
        this.paintAt(g, p.getX(), p.getY());
    }

    public final void paintAt(Graphics g, AffineTransform T, Point2D p) {
        if (p == null) {
            return;
        }
        this.paintAt(g, T, p.getX(), p.getY());
    }

    public final void paintAsTiles(Graphics g, double x, double y, double w, double h) {
        if (g == null || !this.visible || w == 0.0 || h == 0.0) {
            return;
        }
        if (w < 0.0) {
            x += w;
            w = -w;
        }
        if (h < 0.0) {
            y += h;
            h = -h;
        }
        XRect rect = this.getBounds2D();
        double x0 = rect.getMinX();
        double y0 = rect.getMinY();
        double w0 = rect.getWidth();
        double h0 = rect.getHeight();
        if (w0 <= 0.0 || h0 <= 0.0) {
            return;
        }
        int[] xLimits = MathUtilities.getTileIndexLimits(x, w, x0, w0);
        int[] yLimits = MathUtilities.getTileIndexLimits(y, h, y0, h0);
        if (xLimits != null && yLimits != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setClip((int)x, (int)y, (int)w, (int)h);
            int i = xLimits[0];
            while (i < xLimits[1]) {
                int j = yLimits[0];
                while (j < yLimits[1]) {
                    this.paintAt((Graphics)g2, (double)i * w0, (double)j * h0);
                    ++j;
                }
                ++i;
            }
        }
    }

    public final void paintAsTiles(Graphics g, double w, double h) {
        this.paintAsTiles(g, 0.0, 0.0, w, h);
    }

    public final void paintAsTiles(Graphics g, Rectangle2D rect) {
        if (g == null || rect == null) {
            return;
        }
        double x = rect.getMinX();
        double y = rect.getMinY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        this.paintAsTiles(g, x, y, w, h);
    }

    public final Graphics2D getPreparedGraphics2D(Graphics g) {
        Graphics2D h = (Graphics2D)g.create();
        h.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        h.clip(this.getBounds2D());
        this.applyOpacity(h);
        return h;
    }

    public final BufferedImage makeSnapshot() {
        return PaintableTools.makeBufferedImage(this);
    }

    public XRect getBounds2D() {
        XRect bounds = this.getDefaultBounds2D();
        if (bounds != null) {
            return bounds;
        }
        bounds = this.getOriginalBounds2D();
        if (this.mutator.isIdentity()) {
            return bounds;
        }
        double x1 = bounds.getMinX();
        double y1 = bounds.getMinY();
        double x2 = bounds.getMaxX();
        double y2 = bounds.getMaxY();
        double[] source = new double[]{x1, y1, x2, y1, x2, y2, x1, y2};
        double[] target = new double[8];
        this.mutator.transform(source, 0, target, 0, 4);
        x1 = Math.min(target[0], Math.min(target[2], Math.min(target[4], target[6])));
        y1 = Math.min(target[1], Math.min(target[3], Math.min(target[5], target[7])));
        x2 = Math.max(target[0], Math.max(target[2], Math.max(target[4], target[6])));
        y2 = Math.max(target[1], Math.max(target[3], Math.max(target[5], target[7])));
        return new XRect(x1, y1, x2 - x1, y2 - y1);
    }

    public XPoint2D getCenter() {
        XPoint2D center = this.getDefaultCenter();
        if (center != null) {
            return center;
        }
        center = this.getOriginalCenter();
        if (this.mutator.isIdentity()) {
            return center;
        }
        return (XPoint2D)this.mutator.transform(center, center);
    }

    public final XPoint2D getCorner() {
        XRect bounds = this.getBounds2D();
        return new XPoint2D(bounds.getMinX(), bounds.getMinY());
    }

    public boolean contains(double x, double y) {
        if (this.mutator.isIdentity()) {
            return this.originalContains(x, y);
        }
        XPoint2D p = new XPoint2D(x, y);
        this.inverse.transform(p, p);
        return this.originalContains(p.getX(), p.getY());
    }

    public final boolean contains(Point2D p) {
        if (p == null) {
            return false;
        }
        return this.contains(p.getX(), p.getY());
    }

    public final void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.firePropertyChange("set.visible", null, null);
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setOpacity(float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        if (this.opacity != opacity) {
            this.opacity = opacity;
            this.firePropertyChange("set.opacity", null, null);
        }
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final void setBackgroundPaint(Paint background) {
        if (background == this.background) {
            return;
        }
        this.background = background;
        this.firePropertyChange(SET_BACKGROUND_PAINT, null, null);
    }

    public final Paint getBackgroundPaint() {
        return this.background;
    }

    public final void clearBackgroundPaint() {
        this.setBackgroundPaint(null);
    }

    public final void setBackgroundTile(Object object) {
        Paintable tile = ComponentFactory.makePaintable(object);
        if (tile == this.backgroundTile) {
            return;
        }
        this.backgroundTile = tile;
        this.firePropertyChange(SET_BACKGROUND_TILE, null, null);
    }

    public final Paintable getBackgroundTile() {
        return this.backgroundTile;
    }

    public final void clearBackgroundTile() {
        this.setBackgroundTile(null);
    }

    public final void clearBothBackgrounds() {
        this.setBackgroundPaint(null);
        this.setBackgroundTile(null);
    }

    public void setMutator(AffineTransform M) {
        if (M == null || M.equals(this.mutator)) {
            return;
        }
        try {
            AffineTransform N = M.createInverse();
            this.mutator = M;
            this.inverse = N;
            this.firePropertyChange("set.mutator", null, null);
        }
        catch (NoninvertibleTransformException exception) {
            return;
        }
    }

    public void addPreMutation(AffineTransform M) {
        if (M == null) {
            return;
        }
        this.setMutator(TransformFactory.compose(this.mutator, M));
    }

    public void addPostMutation(AffineTransform M) {
        if (M == null) {
            return;
        }
        this.setMutator(TransformFactory.compose(M, this.mutator));
    }

    public void setMutator(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.setMutator(strategy.mutator(this.getOriginalCenter()));
    }

    public void addPreMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.addPreMutation(strategy.mutator(this.getOriginalCenter()));
    }

    public void addPostMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.addPostMutation(strategy.mutator(this.getCenter()));
    }

    public final AffineTransform getMutator() {
        return new AffineTransform(this.mutator);
    }

    public final AffineTransform getMutatorInverse() {
        return new AffineTransform(this.inverse);
    }

    public final void mutate(AffineTransform M) {
        this.addPostMutation(M);
    }

    public final void mutate(Mutator.Strategy strategy) {
        this.addPostMutation(strategy);
    }

    public final void move(double dx, double dy) {
        this.addPostMutation(TransformFactory.translate(dx, dy));
    }

    public final void move(Point2D p) {
        if (p == null) {
            return;
        }
        this.move(p.getX(), p.getY());
    }

    public final void moveCenterTo(double x, double y) {
        XPoint2D p = this.getCenter();
        this.move(x - p.getX(), y - p.getY());
    }

    public final void moveCenterTo(Point2D p) {
        if (p == null) {
            return;
        }
        this.moveCenterTo(p.getX(), p.getY());
    }

    public final void moveCornerTo(double x, double y) {
        XPoint2D p = this.getCorner();
        this.move(x - p.getX(), y - p.getY());
    }

    public final void moveCornerTo(Point2D p) {
        if (p == null) {
            return;
        }
        this.moveCornerTo(p.getX(), p.getY());
    }

    public final void rotate(double degrees) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.rotate(p.getX(), p.getY(), degrees));
    }

    public final void reflect(double degrees) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.reflect(p.getX(), p.getY(), degrees));
    }

    public final void hreflect() {
        this.reflect(0.0);
    }

    public final void vreflect() {
        this.reflect(90.0);
    }

    public final void scale(double s) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.scale(p.getX(), p.getY(), 0.0, s, s));
    }

    public final void scale(double degrees, double s, double t) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.scale(((Point2D)p).getX(), ((Point2D)p).getY(), degrees, s, t));
    }

    public final void shear(double degrees, double s) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.shear(((Point2D)p).getX(), ((Point2D)p).getY(), degrees, s));
    }

    public final void glide(double degrees, double distance) {
        this.addPostMutation(TransformFactory.glide(degrees, distance));
    }

    public final void glidereflect(double degrees, double distance) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.glidereflect(p.getX(), p.getY(), degrees, distance));
    }

    public final void lineartransform(double m00, double m10, double m01, double m11) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.centeredTransform(p.getX(), p.getY(), m00, m10, m01, m11, 0.0, 0.0));
    }

    public final void affinetransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        XPoint2D p = this.getCenter();
        this.addPostMutation(TransformFactory.centeredTransform(p.getX(), p.getY(), m00, m10, m01, m11, m02, m12));
    }

    public abstract void originalPaint(Graphics var1);

    public final XRect getOriginalBounds2D() {
        XRect bounds = this.getDefaultOriginalBounds2D();
        if (bounds != null) {
            return bounds;
        }
        bounds = this.getActualBounds2D();
        if (bounds != null) {
            return bounds;
        }
        return new XRect();
    }

    public abstract XRect getActualBounds2D();

    public XPoint2D getOriginalCenter() {
        XPoint2D center = this.getDefaultOriginalCenter();
        if (center != null) {
            return center;
        }
        XRect bounds = this.getOriginalBounds2D();
        double x = bounds.getCenterX();
        double y = bounds.getCenterY();
        return new XPoint2D(x, y);
    }

    public abstract boolean originalContains(double var1, double var3);

    public final boolean originalContains(Point2D p) {
        if (p == null) {
            return false;
        }
        return this.originalContains(p.getX(), p.getY());
    }

    protected final boolean possiblyContains(double x, double y) {
        return this.visible && this.getOriginalBounds2D().contains(x, y);
    }

    public final void applyOpacity(Graphics2D h) {
        if (this.opacity >= 1.0f) {
            return;
        }
        Composite composite = h.getComposite();
        float netOpacity = this.opacity;
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            if (alphaComposite.getRule() != 3) {
                return;
            }
            netOpacity *= alphaComposite.getAlpha();
        } else if (composite != null) {
            return;
        }
        h.setComposite(AlphaComposite.getInstance(3, netOpacity));
    }

    public final void setDefaultBounds2D(Rectangle2D rectangle) {
        if (rectangle == null) {
            if (this.defaultBounds2D == null) {
                return;
            }
            this.defaultBounds2D = null;
        } else {
            double x = rectangle.getX();
            double y = rectangle.getY();
            double w = rectangle.getWidth();
            double h = rectangle.getHeight();
            this.defaultBounds2D = new XRect(x, y, w, h);
        }
        this.firePropertyChange("set.default.bounds2d", null, null);
    }

    public final XRect getDefaultBounds2D() {
        if (this.defaultBounds2D == null) {
            return null;
        }
        return new XRect(this.defaultBounds2D);
    }

    public final void setDefaultCenter(Point2D center) {
        if (center == null) {
            if (this.defaultCenter == null) {
                return;
            }
            this.defaultCenter = null;
        } else {
            double x = center.getX();
            double y = center.getY();
            this.defaultCenter = new XPoint2D(x, y);
        }
        this.firePropertyChange("set.default.center", null, null);
    }

    public final XPoint2D getDefaultCenter() {
        if (this.defaultCenter == null) {
            return null;
        }
        return new XPoint2D(this.defaultCenter);
    }

    public final void setDefaultOriginalBounds2D(Rectangle2D rectangle) {
        if (rectangle == null) {
            if (this.defaultOriginalBounds2D == null) {
                return;
            }
            this.defaultOriginalBounds2D = null;
        } else {
            double x = rectangle.getX();
            double y = rectangle.getY();
            double w = rectangle.getWidth();
            double h = rectangle.getHeight();
            this.defaultOriginalBounds2D = new XRect(x, y, w, h);
        }
        this.firePropertyChange("set.default.original.bounds2d", null, null);
    }

    public final XRect getDefaultOriginalBounds2D() {
        if (this.defaultOriginalBounds2D == null) {
            return null;
        }
        return new XRect(this.defaultOriginalBounds2D);
    }

    public final void setDefaultOriginalCenter(Point2D center) {
        if (center == null) {
            if (this.defaultOriginalCenter == null) {
                return;
            }
            this.defaultOriginalCenter = null;
        } else {
            double x = center.getX();
            double y = center.getY();
            this.defaultOriginalCenter = new XPoint2D(x, y);
        }
        this.firePropertyChange("set.default.original.center", null, null);
    }

    public final XPoint2D getDefaultOriginalCenter() {
        if (this.defaultOriginalCenter == null) {
            return null;
        }
        return new XPoint2D(this.defaultOriginalCenter);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public final void addPropertyChangeListeners(PropertyChangeListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            this.addPropertyChangeListener(listeners[i]);
            ++i;
        }
    }

    public final void addPropertyChangeListeners(String propertyName, PropertyChangeListener[] listeners) {
        if (listeners == null) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            this.addPropertyChangeListener(propertyName, listeners[i]);
            ++i;
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeAdapter.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.changeAdapter.getPropertyChangeListeners(propertyName);
    }

    public final boolean hasListeners(String propertyName) {
        return this.changeAdapter.hasListeners(propertyName);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeAdapter.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public final void firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Byte(oldValue), new Byte(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, short oldValue, short newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Short(oldValue), new Short(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public final void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
        }
    }

    public final void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (newValue != oldValue) {
            this.changeAdapter.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
        }
    }

    public final void firePropertyChange(PropertyChangeEvent evt) {
        this.changeAdapter.firePropertyChange(evt);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange spc = (SupportsPropertyChange)object;
            spc.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange spc = (SupportsPropertyChange)object;
            spc.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object oldobject, Object newobject) {
        this.removeForwardingListener(oldobject);
        this.addForwardingListener(newobject);
    }
}

