/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class AbsoluteLayout
implements LayoutManager2 {
    protected Vector components = new Vector();

    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (component == null) {
            return;
        }
        this.components.add(component);
    }

    public void removeLayoutComponent(Component component) {
        if (component != null) {
            this.components.remove(component);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Rectangle limits = null;
        Rectangle bounds = null;
        int i = 0;
        while (i < this.components.size()) {
            Component c = (Component)this.components.get(i);
            bounds = AbsoluteLayout.getPreferredBounds(c);
            limits = limits == null ? bounds : limits.union(bounds);
            ++i;
        }
        if (limits == null) {
            return new Dimension();
        }
        Insets insets = parent.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int w = limits.width + insets.left + insets.right;
        int h = limits.height + insets.top + insets.bottom;
        return new Dimension(w, h);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int a = insets.left;
        int b = insets.top;
        int i = 0;
        while (i < this.components.size()) {
            Component c = (Component)this.components.get(i);
            if (c != null) {
                Rectangle bounds = AbsoluteLayout.getPreferredBounds(c);
                bounds.x += a;
                bounds.y += b;
                c.setBounds(bounds);
            }
            ++i;
        }
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container parent) {
        parent.repaint();
    }

    public static Rectangle getPreferredBounds(Component c) {
        if (c == null) {
            return new Rectangle();
        }
        Point corner = c.getLocation();
        Rectangle bounds = c.getBounds();
        bounds.x = corner.x;
        bounds.y = corner.y;
        if (c instanceof Container) {
            Container x = (Container)c;
            Dimension d = x.getPreferredSize();
            bounds.width = d.width;
            bounds.height = d.height;
        } else {
            Dimension d = c.getMinimumSize();
            Dimension e = c.getSize();
            bounds.width = Math.max(d.width, e.width);
            bounds.height = Math.max(d.height, e.height);
        }
        return bounds;
    }
}

