/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XString;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import java.io.Serializable;

public class CaseActionFilter
implements StringableFilter,
Cloneable,
Serializable {
    public static final CaseActionFilter UPPER_CASE = new CaseActionFilter(){

        public Stringable filterStringable(Stringable obj) throws FilterException {
            super.filterStringable(obj);
            XString x = (XString)obj;
            String input = x.getValue();
            x.setValue(input.toUpperCase());
            return x;
        }
    };
    public static final CaseActionFilter LOWER_CASE = new CaseActionFilter(){

        public Stringable filterStringable(Stringable obj) throws FilterException {
            super.filterStringable(obj);
            XString x = (XString)obj;
            String input = x.getValue();
            x.setValue(input.toLowerCase());
            return x;
        }
    };
    public static final CaseActionFilter TITLE_CASE = new CaseActionFilter(){

        public Stringable filterStringable(Stringable obj) throws FilterException {
            super.filterStringable(obj);
            XString x = (XString)obj;
            StringBuffer buffer = new StringBuffer(x.getValue());
            boolean capitalize = true;
            int i = 0;
            while (i < buffer.length()) {
                char c = buffer.charAt(i);
                if (Character.isLetter(c)) {
                    buffer.setCharAt(i, capitalize ? Character.toUpperCase(c) : Character.toLowerCase(c));
                    capitalize = false;
                } else if (Character.isWhitespace(c)) {
                    capitalize = true;
                }
                ++i;
            }
            x.setValue(buffer.toString());
            return x;
        }
    };

    public Stringable filterStringable(Stringable obj) throws FilterException {
        if (obj instanceof XString) {
            return obj;
        }
        throw new FilterException(obj, "Not a string: " + obj.toString());
    }
}

