/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.console.ConsoleGateway;
import edu.neu.ccs.console.ConsoleTextPane;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.FileExistsException;
import edu.neu.ccs.util.FileUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

final class ConsoleWindow
extends JPTFrame
implements JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private static int minFontSize = 10;
    private static int maxFontSize = 72;
    private static int widthDeduction = 200;
    private static int heightDeduction = 150;
    private Hashtable actions = null;
    private Action save = null;
    private Action transcript = null;
    private transient FileOutputStream scriptStream = null;
    private ConsoleGateway gateway = null;
    private File scriptFile = null;
    private JScrollPane scroll = null;
    private ConsoleTextPane tablet = null;
    private Object inputmode_mutex = new Object();

    public ConsoleWindow(ConsoleGateway gateway) {
        super("Text console");
        if (gateway == null) {
            throw new IllegalArgumentException("Null ConsoleGateway passed to ConsoleWindow constructor");
        }
        this.gateway = gateway;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConsoleWindow.this.close();
            }
        });
        this.tablet = new ConsoleTextPane(this);
        this.actions = this.createActionsTable();
        this.setJMenuBar(this.createMenuBar());
        this.save.setEnabled(false);
        this.scroll = new JScrollPane(this.tablet);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.setContentPane(this.scroll);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width - widthDeduction;
        int height = screenSize.height - heightDeduction;
        this.setSize(width, height);
        this.setResizable(true);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.scriptStream = new FileOutputStream(this.scriptFile);
        }
        catch (Exception ex) {
            this.scriptFile = null;
            this.scriptStream = null;
            this.transcript.putValue("Name", "Start transcript");
        }
    }

    public void consoleInputPerformed(String text) {
        this.save.setEnabled(true);
        this.fireConsoleInputPerformed(text);
    }

    public void consoleOutputPerformed(String text, int stream) {
        this.save.setEnabled(true);
        this.tablet.append(text, stream);
        if (this.scriptStream != null) {
            try {
                this.scriptStream.write(text.getBytes());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "There was an error writing to the transcript file.", "Warning!", 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMode(boolean input) {
        Object object = this.inputmode_mutex;
        synchronized (object) {
            if (input) {
                this.tablet.setStream(2);
                this.normal();
            } else {
                this.tablet.setStream(0);
            }
        }
    }

    public void setInputColor(Color c) {
        this.tablet.setInputColor(c);
    }

    public Color getInputColor() {
        return this.tablet.getInputColor();
    }

    public void setOutputColor(Color c) {
        this.tablet.setOutputColor(c);
    }

    public Color getOutputColor() {
        return this.tablet.getOutputColor();
    }

    public void setErrorColor(Color c) {
        this.tablet.setErrorColor(c);
    }

    public Color getErrorColor() {
        return this.tablet.getErrorColor();
    }

    public final String getFontFamilyName() {
        return this.tablet.getFontFamilyName();
    }

    public final int getFontSize() {
        return this.tablet.getFontSize();
    }

    public static final int getMinimumFontSize() {
        return minFontSize;
    }

    public static final int getMaximumFontSize() {
        return maxFontSize;
    }

    public final void setFontSize(int size) {
        this.tablet.setFontSize(size);
    }

    public void close() {
        if (this.gateway.isActivated()) {
            this.gateway.setActivated(false);
            return;
        }
        if (this.save.isEnabled() && JOptionPane.showConfirmDialog(this, "Do you want to save a transcript of the console contents?", "Save contents", 0) == 0) {
            this.save();
        }
        this.setVisible(false);
        this.dispose();
        if (ConsoleWindow.getJPTFrameCount() == 0) {
            System.exit(0);
        }
    }

    ConsoleTextPane getTextPane() {
        return this.tablet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConsoleInputPerformed(String text) {
        Object object = this.inputmode_mutex;
        synchronized (object) {
            this.gateway.consoleInputPerformed(text);
        }
    }

    private Hashtable createActionsTable() {
        Hashtable<String, Action> table = new Hashtable<String, Action>();
        Action[] a = this.tablet.getActions();
        int i = 0;
        while (i < a.length) {
            table.put((String)a[i].getValue("Name"), a[i]);
            ++i;
        }
        return table;
    }

    private Action getAction(String name) {
        return (Action)this.actions.get(name);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createEditMenu());
        menubar.add(this.createFontMenu());
        return menubar;
    }

    private JMenu createFileMenu() {
        JMenu file = new JMenu("File");
        this.save = new SimpleAction("Save contents"){

            public void perform() {
                ConsoleWindow.this.save();
            }
        };
        file.add(this.save);
        this.transcript = new SimpleAction("Start transcript"){

            public void perform() {
                ConsoleWindow.this.transcript();
            }
        };
        file.add(this.transcript);
        file.addSeparator();
        file.add(new SimpleAction("Close window"){

            public void perform() {
                ConsoleWindow.this.close();
            }
        });
        return file;
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu("Edit");
        edit.add(new SimpleAction("Cut"){

            public void perform() {
                ConsoleWindow.this.getTextPane().cut();
            }
        });
        edit.add(new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent evt) {
                Action a = ConsoleWindow.this.getAction("copy-to-clipboard");
                if (a != null) {
                    a.actionPerformed(evt);
                }
            }
        });
        edit.add(new SimpleAction("Paste"){

            public void perform() {
                ConsoleWindow.this.getTextPane().paste();
            }
        });
        edit.addSeparator();
        edit.add(new AbstractAction("Select all"){

            public void actionPerformed(ActionEvent evt) {
                Action a = ConsoleWindow.this.getAction("select-all");
                if (a != null) {
                    a.actionPerformed(evt);
                }
            }
        });
        return edit;
    }

    private JMenu createFontMenu() {
        JMenu font = new JMenu("Font size");
        int size = 10;
        while (size <= 36) {
            font.add(this.setFontAction(size));
            size += 2;
        }
        size = 48;
        while (size <= 72) {
            font.add(this.setFontAction(size));
            size += 12;
        }
        return font;
    }

    private SimpleAction setFontAction(final int size) {
        return new SimpleAction(String.valueOf(size) + " point"){

            public void perform() {
                ConsoleWindow.this.setFontSize(size);
            }
        };
    }

    private void save() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save contents");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "All files (*.*)";
            }
        });
        while (fc.showSaveDialog(this) == 0) {
            try {
                try {
                    FileUtilities.writeFile(fc.getSelectedFile(), this.tablet.getText(), false);
                    this.save.setEnabled(false);
                }
                catch (FileExistsException ex) {
                    int result = JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2);
                    if (result == 0) {
                        FileUtilities.writeFile(fc.getSelectedFile(), this.tablet.getText(), true);
                        this.save.setEnabled(false);
                        break;
                    }
                    if (result != 2) continue;
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "The file could not be saved.", "Error!", 0);
            }
            break;
        }
    }

    private void transcript() {
        block8: {
            block9: {
                if (this.scriptStream != null) break block9;
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Start transcript");
                fc.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return true;
                    }

                    public String getDescription() {
                        return "All files (*.*)";
                    }
                });
                while (fc.showDialog(this, "Select") == 0) {
                    File file = fc.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2) != 0) continue;
                    try {
                        this.scriptFile = fc.getSelectedFile();
                        this.scriptStream = new FileOutputStream(this.scriptFile);
                        this.transcript.putValue("Name", "Stop transcript");
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "The transcript could not be opened.", "Error!", 0);
                    }
                    break block8;
                }
                break block8;
            }
            if (JOptionPane.showConfirmDialog(null, "Do you want to close the transcript file?", "Stop transcript", 0) != 0) break block8;
            try {
                try {
                    this.scriptStream.close();
                }
                catch (IOException iOException) {}
            }
            finally {
                this.scriptFile = null;
                this.scriptStream = null;
                this.transcript.putValue("Name", "Start transcript");
            }
        }
    }
}

