/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.Colors;
import edu.neu.ccs.console.ConsoleGateway;
import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

final class ConsoleTextPane
extends JTextPane
implements JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private transient String endl = null;
    private int start = 0;
    private StyleContext context = null;
    private DefaultStyledDocument doc = null;
    private Style base = null;
    private Color[] color = new Color[]{Color.black, Color.black, Color.black};
    private ConsoleWindow window = null;
    private int currentstream = 0;
    protected static final int minFontSize = 10;
    protected static final int maxFontSize = 72;
    private int fontSize = 10;

    private ConsoleTextPane() {
        this.endl = SystemUtilities.getLineSeparator();
    }

    public ConsoleTextPane(ConsoleWindow w) {
        this();
        this.window = w;
        this.context = new StyleContext();
        this.doc = new DefaultStyledDocument(this.context);
        this.setStyledDocument(this.doc);
        String familyName = ConsoleGateway.getMonospacedFontFamilyName();
        this.base = this.context.getStyle("default");
        StyleConstants.setFontFamily(this.base, familyName);
        StyleConstants.setBold(this.base, true);
        int size = new JLabel("0").getFont().getSize();
        if (size % 2 != 0) {
            ++size;
        }
        StyleConstants.setFontSize(this.base, size += 4);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.base, false);
        this.setStream(0);
    }

    public void processComponentKeyEvent(KeyEvent evt) {
        int eventID = evt.getID();
        int keycode = evt.getKeyCode();
        char keychar = evt.getKeyChar();
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 144: 
            case 145: 
            case 154: 
            case 157: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 240: 
            case 241: 
            case 242: 
            case 245: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 65406: {
                return;
            }
        }
        if (keychar == '\u0003' || keychar == '\u0016' || keychar == '\u0018') {
            return;
        }
        switch (eventID) {
            case 401: {
                if (keycode == 10) {
                    evt.consume();
                    return;
                }
                if (keycode != 8) break;
                if (this.getCaretPosition() < this.start || this.getSelectionStart() < this.start) {
                    evt.consume();
                    return;
                }
                if (this.getCaretPosition() != this.start || this.getSelectionStart() != this.getSelectionEnd()) break;
                evt.consume();
                return;
            }
            case 402: {
                if (keycode != 10 && keycode != 8) break;
                evt.consume();
                return;
            }
            default: {
                if (this.getCaretPosition() < this.start || this.getSelectionStart() < this.start) {
                    evt.consume();
                    return;
                }
                if (keychar == '\b' && this.getCaretPosition() == this.start && this.getSelectionStart() == this.getSelectionEnd()) {
                    evt.consume();
                    return;
                }
                if (keychar != '\n' && keychar != '\r') break;
                try {
                    try {
                        this.doc.insertString(this.doc.getLength(), this.endl, this.getStyleFor(2));
                        this.fireConsoleInputPerformed(this.doc.getText(this.start, this.doc.getLength() - this.start));
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (Throwable throwable) {}
                evt.consume();
                return;
            }
        }
        this.setCharacterAttributes(this.getStyleFor(2), true);
    }

    public void append(String text, int stream) {
        this.setStream(stream);
        this.start = this.doc.getLength();
        this.setCaretPosition(this.start);
        try {
            this.doc.insertString(this.doc.getLength(), text, this.getStyleFor(stream));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.start = this.doc.getLength();
        this.setCaretPosition(this.start);
    }

    public void replaceSelection(String text) {
        if (this.getCaretPosition() >= this.start && this.getSelectionStart() >= this.start) {
            this.setCharacterAttributes(this.getStyleFor(2), true);
            super.replaceSelection(text);
        }
    }

    public void cut() {
        if (this.getCaretPosition() >= this.start && this.getSelectionStart() >= this.start) {
            super.cut();
        }
    }

    public void paste() {
        if (this.getCaretPosition() >= this.start && this.getSelectionStart() >= this.start) {
            this.setCharacterAttributes(this.getStyleFor(2), true);
            super.paste();
        }
    }

    public final String getFontFamilyName() {
        return StyleConstants.getFontFamily(this.base);
    }

    public final int getFontSize() {
        return this.fontSize;
    }

    public static final int getMinimumFontSize() {
        return 10;
    }

    public static final int getMaximumFontSize() {
        return 72;
    }

    public final void setFontSize(int size) {
        if (size < 10) {
            size = 10;
        } else if (size > 72) {
            size = 72;
        }
        Style font = this.context.addStyle(null, this.context.getStyle("default"));
        StyleConstants.setFontSize(font, size);
        StyleConstants.setFontSize(this.base, size);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), font, false);
        this.fontSize = size;
    }

    public void setStream(int stream) {
        if (stream < 0 || stream > 2) {
            return;
        }
        this.currentstream = stream;
        if (stream == 2) {
            this.start = this.doc.getLength();
            this.setCaretPosition(this.start);
            this.setCharacterAttributes(this.getStyleFor(stream), true);
            this.setCaretColor(null);
            this.setEditable(true);
            this.requestFocus();
        } else {
            this.setCaretColor(Colors.transparent);
            this.setEditable(false);
            this.transferFocus();
        }
    }

    public void setInputColor(Color c) {
        if (c == null) {
            c = Color.black;
        }
        this.color[2] = c;
    }

    public Color getInputColor() {
        return this.color[2];
    }

    public void setOutputColor(Color c) {
        if (c == null) {
            c = Color.black;
        }
        this.color[0] = c;
    }

    public Color getOutputColor() {
        return this.color[0];
    }

    public void setErrorColor(Color c) {
        if (c == null) {
            c = Color.black;
        }
        this.color[1] = c;
    }

    public Color getErrorColor() {
        return this.color[1];
    }

    private void fireConsoleInputPerformed(String text) {
        if (this.window != null) {
            this.window.consoleInputPerformed(text);
        }
    }

    private Style getStyleFor(int stream) {
        Style s = this.context.addStyle(null, this.base);
        StyleConstants.setForeground(s, this.color[stream]);
        return s;
    }

    private void beep() {
        new DefaultEditorKit.BeepAction().actionPerformed(new ActionEvent(this, 1001, "beep"));
    }
}

